%% Make Figure 1 %%
%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%
clear

%% Load INT, Cortical Thickness (CT), and Myelin Map (MM) data from 100 HCP subjects
load('Figure1_data.mat')


%% Set colors for figures
colors_visual(1,:) = [27,158,119]/255; % V1
colors_visual(2,:) = [24,142,107]/255; % V2
colors_visual(3,:) = [22,126,95]/255; % V3
colors_visual(5,:) = [19,111,83]/255; % MT
colors_visual(4,:) = [16,95,71]/255; % V4
colors_visual(6,:) = [14,79,60]/255; % V6
colors_visual(7,:) = [11,63,48]/255; % V7
colors_visual(8,:) = [64,64,64]/255; % 8a
colors_visual(9,:) = [0,0,0]; % DLPFC


colors_auditory(1,:) = [117,112,179]/255; % A1
colors_auditory(2,:) = [105,101,161]/255; % LBelt
colors_auditory(3,:) = [94,90,143]/255; % MBelt
colors_auditory(4,:) = [82,78,125]/255; % PBelt
colors_auditory(5,:) = [70,67,107]/255; % RI
colors_auditory(6,:) = [59,56,90]/255; % A4
colors_auditory(7,:) = [47,45,72]/255; % A5
colors_auditory(8,:) = [64,64,64]/255; % 8a
colors_auditory(9,:) = [0,0,0]; % DLPFC


colors_somatosensory(1,:) = [217,95,2]/255; % 3b
colors_somatosensory(2,:) = [195,86,2]/255; % 3a
colors_somatosensory(3,:) = [174,76,2]/255; % 1
colors_somatosensory(4,:) = [152,67,1]/255; % 2
colors_somatosensory(5,:) = [130,57,1]/255; % 5m
colors_somatosensory(6,:) = [109,48,1]/255; % 7b (PF)
colors_somatosensory(7,:) = [87,38,1]/255; % 7a (PG)
colors_somatosensory(8,:) = [64,64,64]/255; % 8a
colors_somatosensory(9,:) = [0,0,0]; % DLPFC


color_sig    = [0.02,0.25,0.49]; % significant effects
color_notsig = [0.41,0.53,0.64]; % non-significant effecs
color_null = [0.5,0.5,0.5]; % null distribution
colorw = [1,1,1]; % white
colorr = [1,0,0]; % red


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% AUDITORY
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Set auditory hierarchies
% A1 LBelt MBelt PBelt  RI   A4   A5  8a  46
% 24  174   173   124  104  175  125  68  84

% A1 LBelt MBelt PBelt RI A4 A5
auditory_index(:,1) = [24,174,173,124,104,175,125];

% A1 MBelt LBelt PBelt RI A4 A5
auditory_index(:,2) = [24,173,174,124,104,175,125];

% A1 LBelt MBelt RI PBelt A4 A5
auditory_index(:,3) = [24,174,173,104,124,175,125];

% A1 MBelt LBelt RI PBelt A4 A5
auditory_index(:,4) = [24,173,174,104,124,175,125]; 

% Add PFC Regions
% A1 MBelt LBelt RI PBelt A4 A5 46 8Ad
auditory_index_PFC(:,1) = [24,174,173,124,104,175,125,84,68];

% A1 MBelt LBelt RI PBelt A4 A5 8Ad 46
auditory_index_PFC(:,2) = [24,174,173,124,104,175,125,68,84];

% Plot model comparison figure
figure; hold on
for i = [1:4]
    plot([prctile(r_comb_perm_auditory,0),prctile(r_comb_perm_auditory,95)],[i,i],'color',color_null,'LineWidth',3)
end
scatter(r_comb_auditory(1),1,200,'MarkerEdgeColor',colorr,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);
scatter(r_comb_auditory([2:4]),[2:4],200,'MarkerEdgeColor',colorw,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);
for i = [6:7]
    plot([prctile(r_comb_perm_auditory_PFC,0),prctile(r_comb_perm_auditory_PFC,95)],[i,i],'color',color_null,'LineWidth',3)
end
scatter(r_comb_auditory(5),6,200,'MarkerEdgeColor',colorw,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);
scatter(r_comb_auditory(6),7,200,'MarkerEdgeColor',colorr,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);

set(gcf,'WindowStyle','docked')
box off
set(gca,'FontSize',50,'TickDir','out','XColor','k','YColor','k','LineWidth',2,'YTickLabelRotation',50)
grid off
yticks([1:4,6:7])
yticklabels({'Order 1','Order 2','Order 3','Order 4','PFC 1','PFC 2'})
set(gca,'FontSize',35)
xlim([0,1])
xlabel(['Goodness-of-fit (R^2)'])
ylim([0,8])
title('Auditory System')


% Plot INT figure HCP
% Analysis of winning model
% A1 LBelt MBelt PBelt RI A4 A5 8Ad 46
auditory_index_best = [24,174,173,124,104,175,125,68,84];
x1 = mean(INT(auditory_index_best,:),2);
y = [1:size(auditory_index_best,2)]';
rho_mean_auditory = corr(y,x1,'type','spearman');
figure; hold on
scatter(y,x1,500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw,'MarkerFaceAlpha',0)
xlim([0.5,9.5])
ylim([1.3,2.1])
xticks([0,2,4,6,8,10])
yticks([1.3,1.5,1.7,1.9,2.1])
lsline
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
for i = 1:length(y)
    scatter(y(i),x1(i),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_auditory(i,:),'MarkerFaceAlpha',1)
end
ylim([1.3,2.1])
xlim([0,10])
grid off; box off
xlabel('Hierarchical Level')
ylabel({'INT (s)'})
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Auditory System HCP')


% Plot INT figure Controls
% Analysis of winning model
% A1 LBelt MBelt PBelt RI A4 A5 8Ad 46
auditory_index_best = [24,174,173,124,104,175,125,68,84];
x1 = mean(INT_controls(auditory_index_best,:),2);
y = [1:size(auditory_index_best,2)]';
rho_mean_auditory = corr(y,x1,'type','spearman');
figure; hold on
scatter(y,x1,500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw,'MarkerFaceAlpha',0)
xlim([0.5,9.5])
ylim([1.7,2.1])
xticks([0,2,4,6,8,10])
yticks([1.7,1.8,1.9,2.0,2.1])
lsline
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
for i = 1:length(y)
    scatter(y(i),x1(i),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_auditory(i,:),'MarkerFaceAlpha',1)
end
grid off; box off
ylim([1.7,2.1])
xlim([0,10])
xlabel('Hierarchical Level')
ylabel({'INT (s)'})
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Auditory System Controls')




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% VISUAL
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Set visual hierarchies
% V1  V2  V3  V4  MT  V6  V7  8a  46
%  1   4   5   6  23   3  16  68  84

% V1 V2 V3 V4 MT V6 V7
visual_index(:,1) = [1,4,5,6,23,3,16]; 

% V1 V2 V3 MT V4 V6 V7
visual_index(:,2) = [1,4,5,23,6,3,16]; 

% V1 V2 V3 MT V4 V7 V6
visual_index(:,3) = [1,4,5,23,6,16,3]; 

% V1 V2 V3 V4 MT V7 V6
visual_index(:,4) = [1,4,5,6,23,16,3]; 

% Add PFC Regions
% V1 V2 V3 MT V4 V6 V7 46 8Ad
visual_index_PFC(:,1) = [1,4,5,23,6,3,16,84,68];

% V1 V2 V3 MT V4 V6 V7 8Ad 46
visual_index_PFC(:,2) = [1,4,5,23,6,3,16,68,84];

% Plot model comparison figure
figure; hold on
for i = [1:4]
    plot([prctile(r_comb_perm_visual,0),prctile(r_comb_perm_visual,95)],[i,i],'color',color_null,'LineWidth',3)
end
scatter(r_comb_visual(2),2,200,'MarkerEdgeColor',colorr,'MarkerFaceColor',color_notsig,'MarkerFaceAlpha',0.8);
scatter(r_comb_visual([1,3,4]),[1,3,4],200,'MarkerEdgeColor',colorw,'MarkerFaceColor',color_notsig,'MarkerFaceAlpha',0.8);
for i = [6:7]
    plot([prctile(r_comb_perm_visual_PFC,0),prctile(r_comb_perm_visual_PFC,95)],[i,i],'color',color_null,'LineWidth',3)
end
scatter(r_comb_visual(5),6,200,'MarkerEdgeColor',colorw,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);
scatter(r_comb_visual(6),7,200,'MarkerEdgeColor',colorr,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);

set(gcf,'WindowStyle','docked')
box off
set(gca,'FontSize',50,'TickDir','out','XColor','k','YColor','k','LineWidth',2,'YTickLabelRotation',50)
grid off
yticks([1:4,6:7])
yticklabels({'Order 1','Order 2','Order 3','Order 4','PFC 1','PFC 2'})
set(gca,'FontSize',35)
xlim([0,1])
xlabel(['Goodness-of-fit (R^2)'])
ylim([0,8])
title('Visual System')


% Plot INT figure HCP
% Analysis of winning model
% V1 V2 V3 MT V4 V6 V7 8Ad 46
visual_index_best = [1,4,5,23,6,3,16,68,84];
x1 = mean(INT(visual_index_best,:),2);
y = [1:size(visual_index_best,2)]';
rho_mean_visual = corr(y,x1,'type','spearman');
figure; hold on
scatter(y,x1,500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw,'MarkerFaceAlpha',0)
xlim([0.5,9.5])
ylim([1.3,2.1])
xticks([0,2,4,6,8,10])
yticks([1.3,1.5,1.7,1.9,2.1])
lsline
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
for i = 1:length(y)
    scatter(y(i),x1(i),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_visual(i,:),'MarkerFaceAlpha',1)
end
grid off; box off
ylim([1.3,2.1])
xlim([0,10])
xlabel('Hierarchical Level')
ylabel({'INT (s)'})
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Visual System HCP')


% Plot INT figure controls
% Analysis of winning model
% V1 V2 V3 MT V4 V6 V7 8Ad 46
visual_index_best = [1,4,5,23,6,3,16,68,84];
x1 = mean(INT_controls(visual_index_best,:),2);
y = [1:size(visual_index_best,2)]';
rho_mean_visual = corr(y,x1,'type','spearman');
figure; hold on
scatter(y,x1,500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw,'MarkerFaceAlpha',0)
xlim([0.5,9.5])
ylim([1.7,2.1])
xticks([0,2,4,6,8,10])
yticks([1.7,1.8,1.9,2.0,2.1])
lsline
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
for i = 1:length(y)
    scatter(y(i),x1(i),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_visual(i,:),'MarkerFaceAlpha',1)
end
grid off; box off
ylim([1.7,2.1])
xlim([0,10])
xlabel('Hierarchical Level')
ylabel({'INT (s)'})
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Visual System Controls')




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% SOMATOSENSORY
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Set somatosensory hierarchies
% 3a  3b  1  2  5m   7b   7a  8a  46
% 53   9 51 52  36  148  150  68  84

%3b  3a  1  2  5m  7b  7a
somatosensory_index(:,1) = [9,53,51,52,36,148,150]; 

%3a  3b  1  2  5m  7b  7a
somatosensory_index(:,2) = [53,9,51,52,36,148,150]; 

%3b  3a  2  1  5m  7b  7a
somatosensory_index(:,3) = [9,53,52,51,36,148,150]; 

%3a  3b  2  1  5m  7b  7a
somatosensory_index(:,4) = [53,9,52,51,36,148,150]; 

% Add PFC Regions
% 3b  3a  1  2  5m  7b  7a  46  8a
somatosensory_index_PFC(:,1) = [9,53,51,52,36,148,150,84,68];

% 3b  3a  1  2  5m  7b  7a  8a  46
somatosensory_index_PFC(:,2) = [9,53,51,52,36,148,150,68,84];

% Plot model comparison figure
figure; hold on
for i = [1:4]
    plot([prctile(r_comb_perm_somatosensory,0),prctile(r_comb_perm_somatosensory,95)],[i,i],'color',color_null,'LineWidth',3)
end
scatter(r_comb_somatosensory(1),1,200,'MarkerEdgeColor',colorr,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);
scatter(r_comb_somatosensory([2:4]),[2:4],200,'MarkerEdgeColor',colorw,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);
for i = [6:7]
    plot([prctile(r_comb_perm_somatosensory_PFC,0),prctile(r_comb_perm_somatosensory_PFC,95)],[i,i],'color',color_null,'LineWidth',3)
end
scatter(r_comb_somatosensory(5),6,200,'MarkerEdgeColor',colorw,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);
scatter(r_comb_somatosensory(6),7,200,'MarkerEdgeColor',colorr,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);

set(gcf,'WindowStyle','docked')
box off
set(gca,'FontSize',50,'TickDir','out','XColor','k','YColor','k','LineWidth',2,'YTickLabelRotation',50)
grid off
yticks([1:4,6:7])
yticklabels({'Order 1','Order 2','Order 3','Order 4','PFC 1','PFC 2'})
set(gca,'FontSize',35)
xlim([0,1])
xlabel(['Goodness-of-fit (R^2)'])
ylim([0,8])
title('Somatosensory System')


% Plot INT figure HCP
% Analysis of winning model
% 3b  3a  1  2  5m  7b  7a  8a  46
somatosensory_index_best = [9,53,51,52,36,148,150,68,84];
x1 = mean(INT(somatosensory_index_best,:),2);
y = [1:size(somatosensory_index_best,2)]';
rho_mean_somatosensory = corr(y,x1,'type','spearman');
figure; hold on
scatter(y,x1,500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw,'MarkerFaceAlpha',0)
xlim([0.5,9.5])
ylim([1.3,2.1])
xticks([0,2,4,6,8,10])
yticks([1.3,1.5,1.7,1.9,2.1])
lsline
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
for i = 1:length(y)
    scatter(y(i),x1(i),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_somatosensory(i,:),'MarkerFaceAlpha',1)
end
grid off; box off
ylim([1.3,2.1])
xlim([0,10])
xlabel('Hierarchical Level')
ylabel({'INT (s)'})
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Somatosensory System HCP')


% Plot INT figure controls
% Analysis of winning model
% 3b  3a  1  2  5m  7b  7a  8a  46
somatosensory_index_best = [9,53,51,52,36,148,150,68,84];
x1 = mean(INT_controls(somatosensory_index_best,:),2);
y = [1:size(somatosensory_index_best,2)]';
rho_mean_somatosensory = corr(y,x1,'type','spearman');
figure; hold on
scatter(y,x1,500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw,'MarkerFaceAlpha',0)
xlim([0.5,9.5])
ylim([1.7,2.1])
xticks([0,2,4,6,8,10])
yticks([1.7,1.8,1.9,2.0,2.1])
lsline
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
for i = 1:length(y)
    scatter(y(i),x1(i),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_somatosensory(i,:),'MarkerFaceAlpha',1)
end
ylim([1.7,2.1])
xlim([0,10])
grid off; box off
xlabel('Hierarchical Level')
ylabel({'INT (s)'})
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Somatosensory System Controls')