%% Make Figure 3 %%
%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%
clear

%% Load file
load('Figure3_data.mat')

%% Set colors for figures
color_sig    = [0.02,0.25,0.49]; % significant effects
color_notsig = [0.41,0.53,0.64]; %non-significant effecs
color_null   = [0.5,0.5,0.5]; % null distribution 
colorw       = [1,1,1]; % white

colors_visual(1,:) = [27,158,119]/255; % V1
colors_visual(2,:) = [24,142,107]/255; % V2
colors_visual(3,:) = [22,126,95]/255; % V3
colors_visual(5,:) = [19,111,83]/255; % MT
colors_visual(4,:) = [16,95,71]/255; % V4
colors_visual(6,:) = [14,79,60]/255; % V6
colors_visual(7,:) = [11,63,48]/255; % V7
colors_visual(8,:) = [64,64,64]/255; % 8a
colors_visual(9,:) = [0,0,0]; % DLPFC

colors_auditory(1,:) = [117,112,179]/255; % A1
colors_auditory(2,:) = [105,101,161]/255; % LBelt
colors_auditory(3,:) = [94,90,143]/255; % MBelt
colors_auditory(4,:) = [82,78,125]/255; % PBelt
colors_auditory(5,:) = [70,67,107]/255; % RI
colors_auditory(6,:) = [59,56,90]/255; % A4
colors_auditory(7,:) = [47,45,72]/255; % A5
colors_auditory(8,:) = [64,64,64]/255; % 8a
colors_auditory(9,:) = [0,0,0]; % DLPFC

colors_somatosensory(1,:) = [217,95,2]/255; % 3b
colors_somatosensory(2,:) = [195,86,2]/255; % 3a
colors_somatosensory(3,:) = [174,76,2]/255; % 1
colors_somatosensory(4,:) = [152,67,1]/255; % 2
colors_somatosensory(5,:) = [130,57,1]/255; % 5m
colors_somatosensory(6,:) = [109,48,1]/255; % 7b (PF)
colors_somatosensory(7,:) = [87,38,1]/255; % 7a (PG)
colors_somatosensory(8,:) = [64,64,64]/255; % 8a
colors_somatosensory(9,:) = [0,0,0]; % DLPFC


%% Set Parcel Indicies for Auditory 
% A1 LBelt MBelt PBelt RI A4 A5 8Ad 46
auditory_index = [24,174,173,124,104,175,125,68,84];

%% Set Parcel Indicies for Visual 
% V1 V2 V3 MT V4 V6 V7 8Ad 46
visual_index = [1,4,5,23,6,3,16,68,84];

%% Set Parcel Indicies for Somatosensory 
% 3b  3a  1  2  5m  7b  7a  8a  46
somatosensory_index = [9,53,51,52,36,148,150,68,84];


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% HALLUCINATIONS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Hallucination Severity Effect (M1_primary) vs Hierarchical Level %%%

% Auditory
figure
scatter([1:length(auditory_index)]',Hallucinations_tStat(auditory_index),'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
for i = 1:length(auditory_index)
    scatter(i,Hallucinations_tStat(auditory_index(i)),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_auditory(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
xticks([0,2,4,6,8,10])
ylim([-2,2])
yticks([-2,0,2])
grid off; box off
xlabel('Hierarchical Level')
ylabel({'Hallucination Effect','on INT (t-statistic)'})
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Auditory System')


% Visual
figure
scatter([1:length(visual_index)]',Hallucinations_tStat(visual_index),'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
for i = 1:length(visual_index)
    scatter(i,Hallucinations_tStat(visual_index(i)),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_visual(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
xticks([0,2,4,6,8,10])
ylim([-2,2])
yticks([-2,0,2])
grid off; box off
xlabel('Hierarchical Level')
ylabel({'Hallucination Effect','on INT (t-statistic)'})
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Visual System')


% Somatosensory
figure
scatter([1:length(somatosensory_index)]',Hallucinations_tStat(somatosensory_index),'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
for i = 1:length(somatosensory_index)
    scatter(i,Hallucinations_tStat(somatosensory_index(i)),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_somatosensory(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
xticks([0,2,4,6,8,10])
ylim([-2,2])
yticks([-2,0,2])
grid off; box off
xlabel('Hierarchical Level')
ylabel({'Hallucination Effect','on INT (t-statistic)'})
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Somatosensory System')




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% DELUSIONS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Delusion Severity Effect (M1_primary) vs Hierarchical Level %%%

% Auditory
figure
scatter([1:length(auditory_index)]',Delusions_tStat(auditory_index),'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
for i = 1:length(auditory_index)
    scatter(i,Delusions_tStat(auditory_index(i)),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_auditory(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
xticks([0,2,4,6,8,10])
ylim([-2,2])
yticks([-2,0,2])
grid off; box off
xlabel('Hierarchical Level')
ylabel({'Delusion Effect','on INT (t-statistic)'})
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Auditory System')

% Visual
figure
scatter([1:length(visual_index)]',Delusions_tStat(visual_index),'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
for i = 1:length(visual_index)
    scatter(i,Delusions_tStat(visual_index(i)),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_visual(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
xticks([0,2,4,6,8,10])
ylim([-2,2])
yticks([-2,0,2])
grid off; box off
xlabel('Hierarchical Level')
ylabel({'Delusion Effect','on INT (t-statistic)'})
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Visual System')


% Somatosensory
figure
scatter([1:length(somatosensory_index)]',Delusions_tStat(somatosensory_index),'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
for i = 1:length(somatosensory_index)
    scatter(i,Delusions_tStat(somatosensory_index(i)),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_somatosensory(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
xticks([0,2,4,6,8,10])
ylim([-2,2])
yticks([-2,0,2])
grid off; box off
xlabel('Hierarchical Level')
ylabel({'Delusion Effect','on INT (t-statistic)'})
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Somatosensory System')




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 3-WAY INTERACTION MODEL (M2)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Auditory System and Hallucinations as Reference 
% null distributions
figure
hold on
plot([0:13]*0,0:13,'color','k','LineWidth',1.5)
for i = 1:12
    plot([prctile(t_null_H0_A0(:,i),2.5),prctile(t_null_H0_A0(:,i),97.5)],[i,i],'color',color_null,'LineWidth',3)
end

% effects
y_vals = mdl_H0_A0.Coefficients.tStat;
scatter(y_vals([1,4,7,10,12]),[1,4,7,10,12],200,'MarkerEdgeColor',colorw,'MarkerFaceColor',color_notsig,'MarkerFaceAlpha',0.8);
scatter(y_vals([2,3,5,6,8,9,11]),[2,3,5,6,8,9,11],200,'MarkerEdgeColor',colorw,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);

grid off; box off
set(gcf,'WindowStyle','docked')
set(gca,'FontSize',35,'TickDir','out','XColor','k','YColor','k','LineWidth',2,'YTickLabelRotation',40)
yticks([1:12]);
yticklabels({'Intercept','Hierarchical Level (HL)','Visual System (VS)','Somatosensroy System (SS)','Symptom (S)','HL-by-VS','HL-by-SS','HL-by-S','VS-by-S','SS-by-S','HL-by-VS-by-S','HL-by-SS-by-S'})
xlabel(['t-statistic'])
xlim([-6,6])
ylim([0,13])
title({'Auditory System and','Hallucinations as Reference'})


%%
% Auditory System and Delusions as Reference 
% null distributions
figure
hold on
plot([0:13]*0,0:13,'color','k','LineWidth',1.5)
for i = 1:12
    plot([prctile(t_null_D0_A0(:,i),2.5),prctile(t_null_D0_A0(:,i),97.5)],[i,i],'color',color_null,'LineWidth',3)
end

% effects
y_vals = mdl_D0_A0.Coefficients.tStat;
scatter(y_vals([1,4,7,10,12]),[1,4,7,10,12],200,'MarkerEdgeColor',colorw,'MarkerFaceColor',color_notsig,'MarkerFaceAlpha',0.8);
scatter(y_vals([2,3,5,6,8,9,11]),[2,3,5,6,8,9,11],200,'MarkerEdgeColor',colorw,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);

grid off; box off
set(gcf,'WindowStyle','docked')
set(gca,'FontSize',35,'TickDir','out','XColor','k','YColor','k','LineWidth',2,'YTickLabelRotation',40)
yticks([1:12]);
yticklabels({'Intercept','Hierarchical Level (HL)','Visual System (VS)','Somatosensroy System (SS)','Symptom (S)','HL-by-VS','HL-by-SS','HL-by-S','VS-by-S','SS-by-S','HL-by-VS-by-S','HL-by-SS-by-S'})
xlabel(['t-statistic'])
xlim([-6,6])
ylim([0,13])
title({'Auditory System and','Delusions as Reference'})


%%
% Somatosensory System and Delusions as Reference 
% null distributionsfmr
figure
hold on
plot([0:13]*0,0:13,'color','k','LineWidth',1.5)
for i = 1:12
    plot([prctile(t_null_D0_S0(:,i),2.5),prctile(t_null_D0_S0(:,i),97.5)],[i,i],'color',color_null,'LineWidth',3)
end

% effects
y_vals = mdl_D0_S0.Coefficients.tStat;
scatter(y_vals([1,4,5,7,10,12]),[1,4,5,7,10,12],200,'MarkerEdgeColor',colorw,'MarkerFaceColor',color_notsig,'MarkerFaceAlpha',0.8);
scatter(y_vals([2,3,6,8,9,11]),[2,3,6,8,9,11],200,'MarkerEdgeColor',colorw,'MarkerFaceColor',color_sig,'MarkerFaceAlpha',0.8);

grid off; box off
set(gcf,'WindowStyle','docked')
set(gca,'FontSize',35,'TickDir','out','XColor','k','YColor','k','LineWidth',2,'YTickLabelRotation',40)
yticks([1:12]);
yticklabels({'Intercept','Hierarchical Level (HL)','Visual System (VS)','Somatosensroy System (SS)','Symptom (S)','HL-by-VS','HL-by-SS','HL-by-S','VS-by-S','SS-by-S','HL-by-VS-by-S','HL-by-SS-by-S'})
xlabel(['t-statistic'])
xlim([-6,6])
ylim([0,13])
title({'Somatosensory System and','Delusions as Reference'})