%% Make Figure 4 %%
%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%
clear

%% Load in silico results (biophysical model) and in vivo results (M1)
load('Figure4_data.mat')


%% Set colors for figures
colors(1,:) = [199,199,199]/255; % V1
colors(2,:) = [170,170,170]/255; % V2
colors(3,:) = [109,109,109]/255; % V4
colors(4,:) = [70,70,70]/255; % MT
colors(5,:) = [40,40,40]/255; % 8l
colors(6,:) = [0,0,0]/255; % 46d

colors_auditory(1,:) = [117,112,179]/255; % A1
colors_auditory(2,:) = [105,101,161]/255; % LBelt
colors_auditory(3,:) = [94,90,143]/255; % MBelt
colors_auditory(4,:) = [82,78,125]/255; % PBelt
colors_auditory(5,:) = [70,67,107]/255; % RI
colors_auditory(6,:) = [59,56,90]/255; % A4
colors_auditory(7,:) = [47,45,72]/255; % A5
colors_auditory(8,:) = [64,64,64]/255; % 8a
colors_auditory(9,:) = [0,0,0]; % DLPFC

colorw      = [1,1,1]; % white
colorp      = [231,41,138]/255; % pink




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% REFERENCE in vivo
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
scatter([1:9]',INT_ref_invivo,'LineWidth',0.5,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
grid off; box off
xlabel('Hierarchical Level')
ylabel(['INT (ms)'])
title('Reference')
set(gca,'TickDir','out','FontSize',70,'LineWidth',2,'XColor',[0,0,0],'YColor',[0,0,0],'XTick',[0,2,4,6,8])
set(gcf,'WindowStyle','docked')
h = findobj(gca,'Type','line');
h.LineWidth = 6;
h.Color = [0,0,0];
hold on
for i = 1:9
    if i==1 || i==2 || i==4 || i==5 || i==8 || i==9
        scatter(i,INT_ref_invivo(i),400,'LineWidth',0.5,'MarkerEdgeColor',colorp,'MarkerFaceColor',colors_auditory(i,:));
    else
        scatter(i,INT_ref_invivo(i),400,'LineWidth',0.5,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_auditory(i,:));
    end
end
xlim([0,10])
ylim([1700,2000])
xticks([0:2:10])




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% HALLUCINATIONS in vivo
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
scatter([1:9]',INT_hallucinations_invivo-INT_ref_invivo,'LineWidth',0.5,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
grid off; box off
xlabel('Hierarchical Level')
ylabel(['\DeltaINT (ms)'])
title('Hallucinations')
set(gca,'TickDir','out','FontSize',70,'LineWidth',2,'XColor',[0,0,0],'YColor',[0,0,0],'XTick',[0,2,4,6,8])
set(gcf,'WindowStyle','docked')
h = findobj(gca,'Type','line');
h.LineWidth = 6;
h.Color = [0,0,0];
hold on
for i = 1:9
     if i==1 || i==2 || i==4 || i==5 || i==8 || i==9
         scatter(i,INT_hallucinations_invivo(i)-INT_ref_invivo(i),400,'LineWidth',0.5,'MarkerEdgeColor',colorp,'MarkerFaceColor',colors_auditory(i,:));
     else
         scatter(i,INT_hallucinations_invivo(i)-INT_ref_invivo(i),400,'LineWidth',0.5,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_auditory(i,:));
     end
end
xlim([0,10])
ylim([-80,80])
xticks([0:2:10])
yticks([-80:40:80])




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% DELUSIONS in vivo
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
scatter([1:9]',INT_delusions_invivo-INT_ref_invivo,'LineWidth',0.5,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
grid off; box off
xlabel('Hierarchical Level')
ylabel(['\DeltaINT (ms)'])
title('Delusions')
set(gca,'TickDir','out','FontSize',70,'LineWidth',2,'XColor',[0,0,0],'YColor',[0,0,0],'XTick',[0,2,4,6,8])
set(gcf,'WindowStyle','docked')
h = findobj(gca,'Type','line');
h.LineWidth = 6;
h.Color = [0,0,0];
hold on
for i = 1:9
    if i==1 || i==2 || i==4 || i==5 || i==8 || i==9
        scatter(i,INT_delusions_invivo(i)-INT_ref_invivo(i),400,'LineWidth',0.5,'MarkerEdgeColor',colorp,'MarkerFaceColor',colors_auditory(i,:));
    else
        scatter(i,INT_delusions_invivo(i)-INT_ref_invivo(i),400,'LineWidth',0.5,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_auditory(i,:));
    end
end
xlim([0,10])
ylim([-80,80])
xticks([0:2:10])
yticks([-80:40:80])




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Hallucinations AND Delusions (BOTH) in vivo
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
scatter([1:9]',INT_both_invivo-INT_ref_invivo,'LineWidth',0.5,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
grid off; box off
xlabel('Hierarchical Level')
ylabel(['\DeltaINT (ms)'])
title('Both')
set(gca,'TickDir','out','FontSize',70,'LineWidth',2,'XColor',[0,0,0],'YColor',[0,0,0],'XTick',[0,2,4,6,8])
set(gcf,'WindowStyle','docked')
h = findobj(gca,'Type','line');
h.LineWidth = 6;
h.Color = [0,0,0];
hold on
for i = 1:9
    if i==1 || i==2 || i==4 || i==5 || i==8 || i==9
        scatter(i,INT_both_invivo(i)-INT_ref_invivo(i),400,'LineWidth',0.5,'MarkerEdgeColor',colorp,'MarkerFaceColor',colors_auditory(i,:));
    else
        scatter(i,INT_both_invivo(i)-INT_ref_invivo(i),400,'LineWidth',0.5,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors_auditory(i,:));
    end
end
xlim([0,10])
ylim([-80,80])
xticks([0:2:10])
yticks([-80:40:80])




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% REFERENCE in silico
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
scatter(xIndex,INT_ref,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
for i = 1:length(INT_ref)
    scatter(xIndex(i),INT_ref(i),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
ylim([1500,3500])
xticks([0,2,4,6,8,10])
yticks([1500,2500,3500])
grid off; box off
xlabel('Hierarchical Level')
ylabel('INT (ms)')
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Reference')


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% HALLUCINATIONS in silico
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
scatter(xIndex,INT_hallucinations-INT_ref,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
plot([0,10],[0,0],'color','k')
for i = 1:length(INT_hallucinations)
    scatter(xIndex(i),INT_hallucinations(i)-INT_ref(i),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
ylim([-80,83]) 
xticks([0,2,4,6,8,10])
yticks([-80,-40,0,40,80])
grid off; box off
xlabel('Hierarchical Level')
ylabel('\Delta INT (ms)')
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Hallucinations')

figure
scatter(xIndex,w_factors_h-1,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
plot([0,10],[0,0],'color','k')
for i = 1:length(w_factors_h)
    scatter(xIndex(i),w_factors_h(i)-1,500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
ylim([-0.10,0.25])
xticks([0,2,4,6,8,10])
yticks([-0.1,0,0.1,0.2])
grid off; box off
xlabel('Hierarchical Level')
ylabel('\Delta E/I Ratio') 
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Hallucinations')


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% DELUSIONS in silico
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
scatter(xIndex,INT_delusions-INT_ref,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
plot([0,10],[0,0],'color','k')
for i = 1:length(INT_delusions)
    scatter(xIndex(i),INT_delusions(i)-INT_ref(i),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
ylim([-80,80]) 
xticks([0,2,4,6,8,10])
yticks([-80,-40,0,40,80])
grid off; box off
xlabel('Hierarchical Level')
ylabel('\Delta INT (ms)')
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Delusions')

figure
scatter(xIndex,w_factors_d-1,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
plot([0,10],[0,0],'color','k')
for i = 1:length(w_factors_d)
    scatter(xIndex(i),w_factors_d(i)-1,500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
ylim([-0.10,0.25])
xticks([0,2,4,6,8,10])
yticks([-0.1,0,0.1,0.2])
grid off; box off
xlabel('Hierarchical Level')
ylabel('\Delta E/I Ratio') 
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Delusions')


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Hallucinations AND Delusions (Both) in silico
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
scatter(xIndex,INT_both-INT_ref,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
plot([0,10],[0,0],'color','k')
for i = 1:length(INT_both)
    scatter(xIndex(i),INT_both(i)-INT_ref(i),500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
ylim([-80,80]) 
xticks([0,2,4,6,8,10])
yticks([-80,-40,0,40,80])
grid off; box off
xlabel('Hierarchical Level')
ylabel('\Delta INT (ms)')
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Both')

figure
scatter(xIndex,w_factors_b-1,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colorw);
lsline
h = findobj(gca,'Type','scatter');
h.SizeData = 400;
h = findobj(gca,'Type','line');
h.LineWidth = 4;
h.Color = [0,0,0];
hold on
plot([0,10],[0,0],'color','k')
for i = 1:length(w_factors_b)
    scatter(xIndex(i),w_factors_b(i)-1,500,'LineWidth',2,'MarkerEdgeColor',colorw,'MarkerFaceColor',colors(i,:),'MarkerFaceAlpha',1);
end
xlim([0,10])
ylim([-0.10,0.25])
xticks([0,2,4,6,8,10])
yticks([-0.1,0,0.1,0.2])
grid off; box off
xlabel('Hierarchical Level')
ylabel('\Delta E/I Ratio') 
set(gca,'FontSize',60,'TickDir','out','XColor','k','YColor','k','LineWidth',2)
set(gcf,'WindowStyle','docked')
title('Both')