function singleGaussian = gaussianForSpot(y, x, snippet)

%fits: [amplitude, x position, x width, y position, y width, offset, angle, linear offset x, linear offset y]
%
%     % to do- rewrite the parameters in terms of a covariance matrix: sigma
%     % = { {sigma_x^2, rho*sigma_x*sigma_y  }, {rho*sigma_x*sigma_y,sigma_y^2} }
%     singleGaussian = @(params) (p(1).*...
%     exp(-(...
%     (((cos(p(7)))^2 / (2*p(3)^2) ) + ((sin(p(7)))^2 / (2*p(5)^2)))  .* (x-p(2)).^2 ...
%     - 2*((-sin(2*p(7)) / (4*p(3)^2) ) + (sin(2*p(7)) / (4*p(5)^2))) .* (x-p(2)).*(y-p(4))...
%     + (((sin(p(7)))^2 / (2*p(3)^2) ) + ((cos(p(7)))^2 / (2*p(5)^2))).* (y-p(4)).^2 ...
%         )))...
%     + p(6) + p(8).*x + p(9).*y - double(snippet);


%fits: [amplitude, position vector, covariance matrix, offset vector)
%params- @(A, x0, y0, rho, sigma_x, sigma_y, offset, offset_x, offset_y)

singleGaussian = @(p) p(1).*...
    exp(-(1./(2.*(1-p(4)^2))).*(...
    ( (x-p(2)).^2./(2*p(5).^2) ) +...
    ( (y-p(3)).^2./(2*p(6).^2) ) -...
    ( (2.*p(4).*(x-p(2)).*(y-p(3))) ./  (p(5).*p(6)) )...
    ))...
    + p(7) + p(8).*x + p(9).*y...
    - double(snippet);


end