function AddNuclearPosition(varargin)

%V2: Changed this function to use a correlation in order to center the
%images.

%Get the relevant folders for this data set
[SourcePath, FISHPath, DefaultDropboxFolder, DropboxFolder, MS2CodePath, PreProcPath,...
configValues, movieDatabasePath] = DetermineAllLocalFolders(varargin{1});

close all

if ~isempty(varargin)
    Prefix = varargin{1};
else
    FolderTemp = uigetdir(DropboxFolder,'Choose folder with files to analyze');
    Dashes = strfind(FolderTemp,filesep);
    Prefix = FolderTemp((Dashes(end)+1):end);
end

%Load the schnitzcells
load([DropboxFolder,filesep,Prefix,filesep,Prefix,'_lin.mat'])

if isfield(schnitzcells,'APpos')
    warning([Prefix,'_lin.mat already has AP positions stored.'])
end
if isfield(schnitzcells,'DVpos')
    warning([Prefix,'_lin.mat already has DV positions stored.'])
end


%Load the AP detection information generated by AddParticlePosition. This
%means that all alignments and manual corrections have to be done at that
%level.
load([DropboxFolder,filesep,Prefix,filesep,'APDetection.mat'])

%Get the surface image in the zoomed case by looking at the last
%frame of our movie
DHis=dir([PreProcPath,filesep,Prefix,filesep,Prefix,'-His*.tif']);
ZoomImage=imread([PreProcPath,filesep,Prefix,filesep,DHis(end-1).name]);


%With AP coordinates in hand we can now determine the AP position of
%all particles. Look I my notes in "Calculating AP positions" in Notability
%for details of the calculation.

%Angle between the x-axis and the AP-axis
APAngle=atan2((coordPZoom(2)-coordAZoom(2)),(coordPZoom(1)-coordAZoom(1)));
APLength=sqrt((coordPZoom(2)-coordAZoom(2))^2+(coordPZoom(1)-coordAZoom(1))^2);



for i=1:length(schnitzcells)
    %Angle between the x-axis and the particle using the A position as a
    %zero
    Angles=atan2((double(schnitzcells(i).ceny)-coordAZoom(2)),...
        (double(schnitzcells(i).cenx)-coordAZoom(1)));

    %Distance between the points and the A point
    Distances=sqrt((coordAZoom(2)-double(schnitzcells(i).ceny)).^2+(coordAZoom(1)-double(schnitzcells(i).cenx)).^2);
    APPositions=Distances.*cos(Angles-APAngle);
    schnitzcells(i).APpos=APPositions/APLength;

    %Determine the distance perpendicular to the AP axis. This is a
    %proxy for a DV axis.

    schnitzcells(i).DVpos=Distances.*sin(Angles-APAngle);

end





save([DropboxFolder,filesep,Prefix,filesep,Prefix,'_lin.mat'],'schnitzcells');

    
    
    
    

