import matplotlib as mpl
import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np
import pandas as pd
from pandas import DataFrame, Series  # for convenience

import pims
import trackpy as tp

mpl.rc('figure', figsize=(20, 5))
mpl.rc('image', cmap='gray')
rc_para = {
        'lines.markersize': 8.0,
        'axes.labelsize': 20,
        'axes.titlesize': 20,
        'font.size': 18,
        # 'font.family': 'serif',
        'legend.fontsize': 20,
        'xtick.labelsize': 18,
        'ytick.labelsize': 18,
        'grid.linewidth': 0.8,
        'grid.alpha': 0.7,
        'axes.axisbelow': True,
        'text.usetex': True,
        'text.latex.preamble': [
            r'\usepackage[separate-uncertainty = true]{siunitx}',
            # r'\usepackage{helvet, times}',
            # i need upright \micro symbols, but you need...
            r'\sisetup{detect-all}',  # ...this to force siunitx to actually use your fonts
            # r'\usepackage[urw-garamond]{mathdesign}',  # set the normal font here
            # r'\usepackage{sansmath}',  # load up the sansmath so that math -> helvet
            # r'\sansmath'  # <- tricky! -- gotta actually tell tex to use!
            r'\DeclareSIUnit\px{px}',
        ],
        # 'lines.markeredgecolor': 'white',

        'lines.solid_capstyle': 'round',
        'patch.edgecolor': 'w',
        'patch.force_edgecolor': True
        }


sns.set_style('white', {'axes.linewidth': 0.5})
sns.set(style='ticks',rc=rc_para)



frames = pims.ImageSequence('pictures/*png', as_grey=True)

f = tp.batch(frames, 31, maxsize=9.0)
f = f[((f['x'] < 160) & (f['x'] > 50) & (f['y'] < 200) & (f['y'] > 100))]

t = tp.link_df(f, 50, memory=3)

t1 = tp.filter_stubs(t, 10)

t1 = t1[(t1['raw_mass'] > 100000)]


data = t1[['x', 'y']]
data = data / 75 * 7

time = data.index.values

position = data.values
distance = distance = np.diff(position, axis=0)
distance = np.linalg.norm(distance, axis=1)

delta_t = np.diff(time)

velocity = distance / delta_t

median = np.median(velocity)

label = f"$v_\mathrm{{surface}} = \SI{{ {median:.2f} }}{{\micro\meter\per\second}}$"


tau = 0.92
D_0 = 6.5

velocity *= tau/D_0

print(velocity)

velocity1 = velocity/0.92 ;


figure, axis = plt.subplots(figsize=[2.4, 4])

axis = sns.boxplot(y=velocity1, ax=axis, sym='',color='grey')


axis.set_ylabel(r'$v$ in \si{\micro\meter\per\second}')
axis.set_ylabel(r'surface velocity in \si{\micro\meter\per\second}')
axis.set_ylabel(r'$\Delta d/ D_0$')

axis.set_title('Experiments')

axis.set_ylim((-0.003569364118719818, 0.18455309441076412))


figure.tight_layout()
figure.savefig('Fig2_b_experiments.pdf')




yy = np.loadtxt('velocities_sims.dat')

yy1 = yy/0.92 ;

figure, axis = plt.subplots(figsize=[2.4, 4])

axis = sns.boxplot(y=yy1,ax=axis,sym='',color='red')

axis.set_ylabel(r'$v$ in \si{\micro\meter\per\second}')
axis.set_ylabel(r'surface velocity in \si{\micro\meter\per\second}')
axis.set_ylabel(r'$\Delta d/ D_0$')

axis.set_title('Simulations')
axis.set_ylim((-0.003569364118719818, 0.18455309441076412))


figure.tight_layout()
figure.savefig('Fig2_b_simulations.pdf')
