#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Dec 10 11:09:29 2019

@author: dasanna
"""

import numpy as np
import matplotlib.pyplot as plt
import matplotlib
import seaborn as sns
import pandas as pd


rc_para = {
    'lines.markersize': 3.0,
    'axes.labelsize': 16,
    'axes.titlesize': 20,
    'font.size': 18,
    # 'font.family': 'serif',
    'legend.fontsize': 15,
    'xtick.labelsize': 16,
    'ytick.labelsize': 16,
    'grid.linewidth': 0.8,
    'grid.alpha': 0.7,
    'axes.axisbelow': True,
    'text.usetex': True,
    'text.latex.preamble': [
        r'\usepackage[separate-uncertainty = true]{siunitx}',
        # r'\usepackage{helvet, times}',
        # i need upright \micro symbols, but you need...
        r'\sisetup{detect-all}',  # ...this to force siunitx to actually use your fonts
        # r'\usepackage[urw-garamond]{mathdesign}',  # set the normal font here
        # r'\usepackage{sansmath}',  # load up the sansmath so that math -> helvet
        # r'\sansmath'  # <- tricky! -- gotta actually tell tex to use!
    ]
}

sns.set_style('white', {'axes.linewidth': 0.5})
sns.set(style='ticks',rc=rc_para)



t1,sp,be,ie = np.loadtxt('lineplot_deformation_energy.dat',usecols=(0,1,2,3),unpack=True)
t2,lb,sb = np.loadtxt('lineplot_bonds.dat',usecols=(0,1,2),unpack=True)
t3,dh,ang = np.loadtxt('lineplot_distance_angle.dat',usecols=(0,1,2),unpack=True)

datae = pd.read_excel('boxplot_deform_energy.xlsx')
datab = pd.read_excel('boxplot_bonds.xlsx')
datad = pd.read_excel('boxplot_distance_angle.xlsx')



D0 = 6.5


fig,ax = plt.subplots(3, 2, sharex='col',figsize=(10,8),gridspec_kw={'width_ratios': [5, 1],'wspace':0.05, 'hspace':0.2})

ax[0,0].plot(t1[::4]/153.0,sp[::4],'-',color='red',linewidth=0.7,label=r'$\Delta E_\mathrm{sp}$')
ax[0,0].plot(t1[::4]/153.0,be[::4],'-',color='b',linewidth=0.7,label=r'$\Delta E_\mathrm{bend}$')

ax[0,0].xaxis.set_tick_params(labelsize=17)
ax[0,0].yaxis.set_tick_params(labelsize=17)

ax[0,0].set_ylabel(r'$\Delta E/k_\mathrm{B}T$ ',fontsize=17,labelpad=14)


ax[0,0].set_xlim(11,22)
ax[0,0].set_ylim(-60,670)


ax[0,0].get_xaxis().set_major_formatter(matplotlib.ticker.ScalarFormatter())

ax[0,0].legend(loc='upper center',fancybox=True,shadow=True,handlelength=1,ncol=2,fontsize=19)






ax[1,0].xaxis.set_tick_params(labelsize=17)
ax[1,0].yaxis.set_tick_params(labelsize=17)

ax[1,0].plot(t2[::4]/153.0,lb[::4]/1230,'-',color='red',linewidth=0.8,label=r'Long')
ax[1,0].plot(t2[::4]/153.0,sb[::4]/1230,'-',color='b',linewidth=0.8,label=r'Short')

ax[1,0].set_ylabel(r'$n_\mathrm{b}/N_\mathrm{para}$',fontsize=17,labelpad=15)


ax[1,0].set_xlim(11,22)
ax[1,0].set_ylim(0,0.06)

ax[1,0].get_xaxis().set_major_formatter(matplotlib.ticker.ScalarFormatter())
ax[1,0].legend(loc='upper center',fancybox=True,shadow=True,handlelength=1,ncol=2,fontsize=19)





ax[2,0].xaxis.set_tick_params(labelsize=17)
ax[2,0].yaxis.set_tick_params(labelsize=17,color='b')

#ax[2,0].plot(t3[::4]/153.0,dh[::4],'-',color='red',linewidth=0.8,label=r'$d_\mathrm{apex}$')
ax[2,0].plot(t3[::4]/153.0,ang[::4],'-',color='b',linewidth=0.8,label=r'$\theta/\pi$')
ax[2,0].yaxis.label.set_color('b')

#ax[2,0].axhline(y=0.232,linewidth=1,color='r',linestyle='--')
ax[2,0].axhline(y=0.8,linewidth=1,color='b',linestyle='--')

ax[2,0].set_xlim(11,22)
ax[2,0].set_ylim(0,1.2)
color = 'b'

ax[2,0].tick_params(axis='y', labelcolor=color)


ax[2,0].set_ylabel(r'$\theta/\pi$ ',fontsize=17,labelpad=18)
ax[2,0].set_xlabel(r'time (s) ',fontsize=17)

ax[2,0].get_xaxis().set_major_formatter(matplotlib.ticker.ScalarFormatter())

#ln1 = ax[2,0].annotate(r'$\theta(t)/\pi$', xy=(19,0.85),textcoords='offset points', ha='center', va='bottom',color='b')

ax20 = ax[2,0].twinx()
ax20.set_ylim(0.025,0.22)

#ln2 = ax20.annotate(r'$d_\mathrm{apex}(t)/D_0$', xy=(19,0.07),textcoords='offset points', ha='center', va='bottom',color='red')

color = 'red'
ax20.plot(t3[::4]/153.0,dh[::4]/D0,'-',color='red',linewidth=0.8,label=r'$d_\mathrm{apex}/D_0$')
ax20.axhline(y=0.232/D0,linewidth=1,color='r',linestyle='--')
ax20.tick_params(axis='y', labelcolor=color,direction="in",pad=-30)

ax20.yaxis.set_tick_params(labelsize=17,color='red')


ax20.set_ylabel(r'$d_\mathrm{apex}/D_0$', color=color,labelpad=-49,fontsize=18)

ax[2,0].plot(np.nan, '-', color='red',label=r'$d_\mathrm{apex}/D_0$')  # Make an agent in ax

ax[2,0].legend(loc='upper center',fancybox=True,shadow=True,handlelength=1,ncol=2,fontsize=18)

#ax[2,0].legend(loc='upper center',fancybox=True,shadow=True,handlelength=1,ncol=2,fontsize=21)




my_pal = ['red', 'b']

#sns.violinplot(x="index",y="energy",data=datae, ax=ax[0,1],palette=my_pal,inner=None)
sns.boxplot(x="index",y="energy",data=datae, ax=ax[0,1],whis=2.5,palette=my_pal,width=0.5)
ax[0,1].set_ylabel(r'',fontsize=22)
ax[0,1].set_xlabel(r'',fontsize=22)
ax[0,1].tick_params(axis='both', which='both', bottom=False, top=False, labelbottom=False, right=False, left=False, labelleft=False)

ax[0,1].set_ylim(-60,670)
ax[0,1].yaxis.set_tick_params(labelsize=0)
plt.setp(ax[0,1].get_xticklabels(), visible=False)



#sns.violinplot(x="index",y="bonds",data=datab, ax=ax[1,1],palette=my_pal,inner=None)
sns.boxplot(x="index",y="bonds",data=datab, ax=ax[1,1],whis=3,palette=my_pal,width=0.5)
ax[1,1].set_ylabel(r'',fontsize=22)
ax[1,1].set_xlabel(r'',fontsize=22)

ax[1,1].tick_params(axis='both', which='both', bottom=False, top=False, labelbottom=False, right=False, left=False, labelleft=False)
ax[1,1].set_ylim(0,75)
ax[1,1].yaxis.set_tick_params(labelsize=0)
plt.setp(ax[1,1].get_xticklabels(), visible=False)

#sns.violinplot(x="index",y="distangle",data=datad, ax=ax[2,1],palette=my_pal,inner=None)
sns.boxplot(x="index",y="distangle1",data=datad, ax=ax[2,1],whis=5,palette=my_pal,width=0.5)
ax[2,1].set_ylabel(r'',fontsize=22)
ax[2,1].set_xlabel(r'',fontsize=22)

ax[2,1].tick_params(axis='both', which='both', bottom=False, top=False, labelbottom=False, right=False, left=False, labelleft=False)
ax[2,1].set_ylim(0,1.22)
ax[2,1].yaxis.set_tick_params(labelsize=0)
plt.setp(ax[2,1].get_xticklabels(), visible=False)


fig.tight_layout()


plt.savefig('Fig5.pdf',bbox_inches='tight')


plt.show()