/* mental disorder, using crime3*/
%sign (matrix);
rsubmit;
libname Crime3m odbc complete="driver=SQL Server; server=meb-sql02.meb.ki.se; database=MGRCRIME3; Trusted_Connection=yes" schema=MGRCRIME3;
libname myHome '/nfs/home/sonhua'; 
endrsubmit;

*local submit; 
libname Crime3 slibref=Crime3m server=matrix;
libname mt  slibref=myHome server=matrix; 
libname mtw slibref=work server=matrix; 
option compress=yes;
libname STR 'Z:\projects\PTSD\STR\Data';

/*data preparation: see mental disorder_Crime3_data preparation*/
/***********************************************analysis one:table 1-models*/
/*start of analysis*/
%macro ana_first(data=,n=,cohort=);
data test1;Set &data;
if year(xstart_cox)<1973 then delete;
run;

proc univariate data=test1;var xage xcum_y;run;
proc freq data=test1;
table _cc;run;

proc sort data=test1;by _cc;
proc means sum data=test1;by _cc; var xcum_y psy_n;
output out=ir sum=;run;

DATA ir_&n;
 SET ir;
 ir=psy_n/xcum_y*1000;
 mark=&cohort;
run;

proc phreg data=test1;
class _cc(ref='0') kon(ref='1') ;
model xcum*psy_n(0)=_cc xage kon /ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_1; 
retain label HR; 
set tab1; 
length mark $32.;
mark='model1';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc phreg data=test1;
class _cc(ref='0') kon(ref='1') ;
model xcum*psy_n(0)=_cc xage kon xedu_n xrel_n xinkp_n /ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_2; 
retain label HR; 
set tab1; 
length mark $32.;
mark='model2';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 


proc phreg data=test1;
class _cc(ref='0') kon(ref='1') ;
model xcum*psy_n(0)=_cc xage kon xedu_n xrel_n xinkp_n xcci_n /ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_3; 
retain label HR; 
set tab1; 
length mark $32.;
mark='model3';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

/*additional adjust for family history of psychiatric diseases and suicide attempt/death*/
proc phreg data=test1;
class _cc(ref='0') kon(ref='1') ;
model xcum*psy_n(0)=_cc xage kon xedu_n xrel_n xinkp_n xcci_n inf_fh_n/ties=efron rl;
strata _setno_new;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_4; 
retain label HR; 
set tab1; 
length mark $32.;
mark='model4';
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

data twinallmodel_&n;
set tab_1-tab_4;
mark=compress(&cohort||'_'||mark);
run;
%mend;

%ana_first(data=myhome.test1_n,n=1,cohort='cohort1');

%ana_first(data=myhome.test_nfs,n=2,cohort='cohort2');

data ir_all;set ir_1-ir_2;run;
data model_all;set twinallmodel_1-twinallmodel_2;run;


ods rtf file='Z:\projects\PTSD\STR\SAS RESULTS 20190507\cohort_model_all0507.rtf';

proc print data=mtw.ir_all noobs;
run;

proc print data=mtw.model_all noobs;
run;
ods rtf close;

/*subgroup analyses*/
/********************'analysis for cohort1*****************************/
/*run macro in 'macro_allcohort_sub'*/
%ana_sub(data=test1,name='cohort1');
data sub_allhr1;set sub_allhr;
run;
data sub_allir1;set sub_allir;
run;

/*by zygosity*/
%macro ir_rd(data=,n=,mark=,var=);
data all;set &data;
rename xcum=xcum_n;
rename psy_n=ai_all;
xcum_y=xcum/365.25;
person=1;
run;

proc phreg data=all;
class _cc(ref='0') kon;
model xcum_n*ai_all(0)=_cc xage kon &var/ties=efron rl;
strata _setno_new ;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_&n; 
retain label HR; 
set tab1; 
length mark $32.;
mark=&mark;
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc sort data=all; by _cc;run;
proc means sum data=all;
var xcum_y ai_all person;
by _cc;output out=ir_all sum= ;
run;

DATA ir&n;
 SET ir_all;
 ir=ai_all/xcum_y*1000;
 risk=ai_all/person;
length mark $32.;
mark=&mark;
DROP _TYPE_ _FREQ_;

data irs1;set ir&n;
perc=compress(ai_all||' ('||put(round(ir, 0.01), d5.3)||')');
run;

proc sort data=irs1;by mark descending _cc;run;
proc transpose data=irs1 out=ir_all;
var perc;
by mark;
id _cc;run;

data ir&n;set ir_all;
ir=compress(_1||' /'||_0);run;
run;
%mend;

data zyg0 zyg1 zyg2 zyg3 zyg4 zyg5;
set test1;
if zyg1=1 then output zyg1;
else if zyg1=2 and zyg1^=4 then output zyg2;
else if zyg1^=4 then output zyg3;
if zyg1=4 then output zyg4;
if zyg1^=4 then output zyg0;
if zyg1=2 or zyg1=4 then output zyg5;
run;

%ir_rd(data=zyg0,n=1,mark='8.twintype_som_1all',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd(data=zyg1,n=2,mark='8.twintype_som_2mon',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd(data=zyg2,n=3,mark='8.twintype_som_3diz',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd(data=zyg3,n=4,mark='8.twintype_som_4unknown',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd(data=zyg4,n=5,mark='8.twintype_dif',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd(data=zyg5,n=6,mark='8.twintype_diz_all',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);

data sub_adhr;set tab_1-tab_6;
mark=compress('cohort1'||'_'||mark);
run;
data sub_adir;
set ir1-ir6;
mark=compress('cohort1'||'_'||mark);
run;

/*follow-up by zygosity*/
%macro ir_rd_followup(data=,a=,b=,n=,mark=,var=);
data ana_1;set &data;
format xstart_cox_str YYMMDD10. xend_cox_str YYMMDD10.;
xstart_cox_str=INTNX('day',xstart_cox,&a,'s');
xend_cox_str=min (INTNX( 'day',xstart_cox,&b,'s'),xend_cox);
xcum_str=intck('day',xstart_cox_str,xend_cox_str);
if xend_cox_str=psy_date then cancer_str=1; else cancer_str=0;
if xcum_str<0 then delete;
run;

data ana_2;set ana_1;
rename cancer_str=ai_all;
rename xcum_str=xcum_n;
xcum_y=xcum_str/365.25;
person=1;
run;

proc phreg data=ana_2;
class _cc(ref='0') kon;
model xcum_n*ai_all(0)=_cc xage kon &var/ties=efron rl;
strata _setno_new ;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_&n; 
retain label HR; 
set tab1; 
length mark $32.;
mark=&mark;
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc sort data=ana_2; by _cc;run;
proc means sum data=ana_2;
var xcum_y ai_all person;
by _cc;output out=ir_all sum= ;
run;

DATA ir&n;
 SET ir_all;
 ir=ai_all/xcum_y*1000;
 risk=ai_all/person;
length mark $32.;
mark=&mark;
DROP _TYPE_ _FREQ_;
run;

data irs1;set ir&n;
perc=compress(ai_all||' ('||put(round(ir, 0.01), d5.3)||')');
run;

proc sort data=irs1;by mark descending _cc;run;
proc transpose data=irs1 out=ir_all;
var perc;
by mark;
id _cc;run;

data ir&n;set ir_all;
ir=compress(_1||' /'||_0);run;
%mend;

data follow;
set zyg1;
run;

%ir_rd_followup(data=follow,a=0,b=28,n=6,mark='3.fol1-within4weeks',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n );
%ir_rd_followup(data=follow,a=29,b=365,n=7,mark='3.fol11-5-52weeks',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd_followup(data=follow,a=366,b=3652,n=8,mark='3.fol14-2-10years',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd_followup(data=follow,a=3653,b=365300,n=9,mark='3.fol5-morethan10years',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);

data sub_adhr1;set tab_6-tab_9;
mark=compress('cohort1_mon'||'_'||mark);
run;
data sub_adir1;
set ir6-ir9;
mark=compress('cohort1_mon'||'_'||mark);
run;

data follow;
set zyg5;
run;

%ir_rd_followup(data=follow,a=0,b=28,n=6,mark='3.fol1-within4weeks',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n );
%ir_rd_followup(data=follow,a=29,b=365,n=7,mark='3.fol11-5-52weeks',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd_followup(data=follow,a=366,b=3652,n=8,mark='3.fol14-2-10years',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd_followup(data=follow,a=3653,b=365300,n=9,mark='3.fol5-morethan10years',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);

data sub_adhr2;set tab_6-tab_9;
mark=compress('cohort1_diz'||'_'||mark);
run;
data sub_adir2;
set ir6-ir9;
mark=compress('cohort1_diz'||'_'||mark);
run;


data myhome.sub_allhr1_0507;set sub_allhr1 sub_adhr sub_adhr1 sub_adhr2;
keep hr mark ProbChiSq;run;
data myhome.sub_allir1_0507;set sub_allir1 sub_adir sub_adir1 sub_adir2;
run;

ods rtf file='Z:\projects\PTSD\STR\SAS RESULTS 20190507\cohort1_sub0507.rtf';
proc print data=mt.sub_allhr1_0507 noobs;
title 'Cohort1';
run;

proc print data=mt.sub_allir1_0507 noobs;
title 'Cohort1';
run;
ods rtf close;

/*cause of death*/
data sui1 sui2;set zyg1;
if accdeath_twin=1 then output sui1;
else if accdeath_twin=0 then output sui2;
run;

%ir_rd(data=sui1,n=1,mark='c1.unnatural_1_mon',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd(data=sui2,n=2,mark='c1.unnatural_0_mon',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);

data sui1 sui2;set zyg5;
if accdeath_twin=1 then output sui1;
else if accdeath_twin=0 then output sui2;
run;

%ir_rd(data=sui1,n=3,mark='c1.unnatural_1_diz',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd(data=sui2,n=4,mark='c1.unnatural_0_diz',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);

data sub_adhr;set tab_1-tab_4;
run;
data sub_adir;
set ir1-ir4;
run;

ods rtf file='Z:\projects\PTSD\STR\zygosity_death0823.rtf';

proc print data=mtw.sub_adhr noobs;
run;

proc print data=mtw.sub_adir noobs;
run;
ods rtf close;

/********************'analysis for cohort2*****************************/
data test1;set myhome.test_nfs;run;
proc means sum data=test1;
var xcum_y;run;

data test2;set test1;
if _cc=1;
xage_exp=intck('year',bir_nfs,deathdate_nfs);/*age of the deceased siblings*/
if xage_exp=. then delete;
keep xage_exp _setno_new;
run;

proc sort data=test2;by _setno_new;
proc sort data=test1;by _setno_new;run;

data test3;merge test2 test1;by _setno_new;
run;

data myhome.test_nfs;set test3;
run;

data test1;set myhome.test_nfs;
rename accdeath_nfs=accdeath_twin;
rename suicide_nfs=suicide_twin;
run;
/*run macro in 'macro_allcohort_sub'*/
%ana_sub(data=test1,name='cohort2');
data sub_allhr1;set sub_allhr;
run;
data sub_allir1;set sub_allir;
run;

/*by zygosity*/
%macro ir_rd(data=,n=,mark=,var=);
data all;set &data;
rename xcum=xcum_n;
rename psy_n=ai_all;
xcum_y=xcum/365.25;
person=1;
run;

proc phreg data=all;
class _cc(ref='0') kon;
model xcum_n*ai_all(0)=_cc xage kon &var/ties=efron rl;
strata _setno_new ;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_&n; 
retain label HR; 
set tab1; 
length mark $32.;
mark=&mark;
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc sort data=all; by _cc;run;
proc means sum data=all;
var xcum_y ai_all person;
by _cc;output out=ir_all sum= ;
run;

DATA ir&n;
 SET ir_all;
 ir=ai_all/xcum_y*1000;
 risk=ai_all/person;
length mark $32.;
mark=&mark;
DROP _TYPE_ _FREQ_;

data irs1;set ir&n;
perc=compress(ai_all||' ('||put(round(ir, 0.01), d5.3)||')');
run;

proc sort data=irs1;by mark descending _cc;run;
proc transpose data=irs1 out=ir_all;
var perc;
by mark;
id _cc;run;

data ir&n;set ir_all;
ir=compress(_1||' /'||_0);run;
run;
%mend;

data zyg0 zyg1 zyg2 zyg3 zyg4 zyg5;
set test1;
if zyg1=1 then output zyg1;
else if zyg1=2 and zyg1^=4 then output zyg2;
else if zyg1^=4 then output zyg3;
if zyg1=4 then output zyg4;
if zyg1^=4 then output zyg0;
if zyg1=2 or zyg1=4 then output zyg5;
run;

%ir_rd(data=zyg0,n=1,mark='8.twintype_som_1all',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd(data=zyg1,n=2,mark='8.twintype_som_2mon',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd(data=zyg2,n=3,mark='8.twintype_som_3diz',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd(data=zyg3,n=4,mark='8.twintype_som_4unknown',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd(data=zyg4,n=5,mark='8.twintype_dif',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd(data=zyg5,n=6,mark='8.twintype_diz_all',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);

data sub_adhr;set tab_1-tab_6;
mark=compress('cohort2'||'_'||mark);
run;
data sub_adir;
set ir1-ir6;
mark=compress('cohort2'||'_'||mark);
run;

/*follow-up by zygosity*/
%macro ir_rd_followup(data=,a=,b=,n=,mark=,var=);
data ana_1;set &data;
format xstart_cox_str YYMMDD10. xend_cox_str YYMMDD10.;
xstart_cox_str=INTNX('day',xstart_cox,&a,'s');
xend_cox_str=min (INTNX( 'day',xstart_cox,&b,'s'),xend_cox);
xcum_str=intck('day',xstart_cox_str,xend_cox_str);
if xend_cox_str=psy_date then cancer_str=1; else cancer_str=0;
if xcum_str<0 then delete;
run;

data ana_2;set ana_1;
rename cancer_str=ai_all;
rename xcum_str=xcum_n;
xcum_y=xcum_str/365.25;
person=1;
run;

proc phreg data=ana_2;
class _cc(ref='0') kon;
model xcum_n*ai_all(0)=_cc xage kon &var/ties=efron rl;
strata _setno_new ;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_&n; 
retain label HR; 
set tab1; 
length mark $32.;
mark=&mark;
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc sort data=ana_2; by _cc;run;
proc means sum data=ana_2;
var xcum_y ai_all person;
by _cc;output out=ir_all sum= ;
run;

DATA ir&n;
 SET ir_all;
 ir=ai_all/xcum_y*1000;
 risk=ai_all/person;
length mark $32.;
mark=&mark;
DROP _TYPE_ _FREQ_;
run;

data irs1;set ir&n;
perc=compress(ai_all||' ('||put(round(ir, 0.01), d5.3)||')');
run;

proc sort data=irs1;by mark descending _cc;run;
proc transpose data=irs1 out=ir_all;
var perc;
by mark;
id _cc;run;

data ir&n;set ir_all;
ir=compress(_1||' /'||_0);run;
%mend;

data follow;
set zyg1;
run;
%ir_rd_followup(data=follow,a=0,b=28,n=6,mark='3.fol1-within4weeks',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n );
%ir_rd_followup(data=follow,a=29,b=365,n=7,mark='3.fol11-5-52weeks',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd_followup(data=follow,a=366,b=3652,n=8,mark='3.fol14-2-10years',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd_followup(data=follow,a=3653,b=365300,n=9,mark='3.fol5-morethan10years',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);

data sub_adhr1;set tab_6-tab_9;
mark=compress('cohort1_mon'||'_'||mark);
run;
data sub_adir1;
set ir6-ir9;
mark=compress('cohort1_mon'||'_'||mark);
run;

data follow;
set zyg5;
run;

%ir_rd_followup(data=follow,a=0,b=28,n=6,mark='3.fol1-within4weeks',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n );
%ir_rd_followup(data=follow,a=29,b=365,n=7,mark='3.fol11-5-52weeks',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd_followup(data=follow,a=366,b=3652,n=8,mark='3.fol14-2-10years',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);
%ir_rd_followup(data=follow,a=3653,b=365300,n=9,mark='3.fol5-morethan10years',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n);

data sub_adhr2;set tab_6-tab_9;
mark=compress('cohort1_diz'||'_'||mark);
run;
data sub_adir2;
set ir6-ir9;
mark=compress('cohort1_diz'||'_'||mark);
run;

data myhome.sub_allhr2_0507;set sub_allhr1 sub_adhr sub_adhr1 sub_adhr2;
keep hr mark ProbChiSq;run;
data myhome.sub_allir2_0507;set sub_allir1 sub_adir sub_adir1 sub_adir2;
run;

ods rtf file='Z:\projects\PTSD\STR\SAS RESULTS 20190507\cohort2_sub0507.rtf';
proc print data=mt.sub_allhr2_0507 noobs;
title 'Cohort2';
run;

proc print data=mt.sub_allir2_0507 noobs;
title 'Cohort2';
run;
ods rtf close;





/*subtype of mental disorder*/
%macro subtype_n(data=,deathdate1=,deathdate2=, date=,n=,mark=,var=);
data ana_1;set &data;
format xend_sub YYMMDD10.;
if _cc=0 then xend_sub=min(&deathdate1,&deathdate2,&date,xmigrationdate,xdeathdate,'31dec2013'd);
if _cc=1 then xend_sub=min(&deathdate2,&date,xmigrationdate,xdeathdate,'31dec2013'd);
if xend_sub=&date then psy_n=1;else psy_n=0;
xcum=intck('day',xstart_cox,xend_sub);
xcum_y=xcum/365.25;
if psy_n=1 then subtype=1;else subtype=0;
drop psy_n;
run;

data ana_2;set ana_1;
rename subtype=ai_all;
rename xcum=xcum_n;
xcum_y=xcum/365.25;
person=1;
run;

proc phreg data=ana_2;
class _cc(ref='0') kon;
model xcum_n*ai_all(0)=_cc xage kon &var/ties=efron rl;
strata _setno_new ;
ods output ParameterEstimates = tab1(where=(Parameter ='_cc')); 
run;

data tab_&n; 
retain label HR; 
set tab1; 
length mark $32.;
mark=&mark;
HR=put(round(HazardRatio, 0.01), d4.2)||' ('||put(round(hrLowerCL, 0.01), d4.2)||'-'||put(round(hrUpperCL, 0.01), d4.2)||')'; 
run; 

proc sort data=ana_2; by _cc;run;
proc means sum data=ana_2;
var xcum_y ai_all person;
by _cc;output out=ir_all sum= ;
run;

DATA ir&n;
 SET ir_all;
 ir=ai_all/xcum_y*1000;
 risk=ai_all/person;
length mark $32.;
mark=&mark;
DROP _TYPE_ _FREQ_;
run;

data irs1;set ir&n;
perc=compress(ai_all||' ('||put(round(ir, 0.01), d5.3)||')');
run;

proc sort data=irs1;by mark descending _cc;run;
proc transpose data=irs1 out=ir_all;
var perc;
by mark;
id _cc;run;

data ir&n;set ir_all;
ir=compress(_1||' /'||_0);run;
%mend;

/*all period--cohort1*/
data subtype;
Set myhome.test1_n;
psy_date_group1=min(psy_date_6,psy_date_8,psy_date_9,psy_date_10,psy_date_11,psy_date_12);
run;

%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2='31dec2013'd,date=psy_date_3,n=5,mark='5.psychotic disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2='31dec2013'd,date=psy_date_4, n=1,mark='1.mood disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2='31dec2013'd,date=psy_date_51, n=3,mark='3.anxiety',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2='31dec2013'd,date=psy_date_52, n=2,mark='2.stress-related disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
/*%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2='31dec2013'd,date=psy_date_6, n=5,mark='5.eating disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)*/
%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2='31dec2013'd,date=psy_date_7, n=4,mark='4.substance misuse',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2='31dec2013'd,date=psy_date_group1, n=6,mark='6.others',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)

data subtype_twin_any_1;
set tab_1-tab_6;
mark=compress('all_cohort1'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

data subtype_twin_ir_any_1;
set ir1-ir6;
mark=compress('all_cohort1'||'_'||mark);
run;

/*the fisrt year period---cohor1*/
data subtype;set subtype;
format time_t YYMMDD10.;
time_t=INTNX('day',xstart_cox,365,'s');
run;
%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2=time_t,date=psy_date_3,n=5,mark='5.psychotic disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2=time_t,date=psy_date_4, n=1,mark='1.mood disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2=time_t,date=psy_date_51, n=3,mark='3.anxiety',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2=time_t,date=psy_date_52, n=2,mark='2.stress-related disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
/*%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2=time_t,date=psy_date_6, n=5,mark='5.eating disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)*/
%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2=time_t,date=psy_date_7, n=4,mark='4.substance misuse',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=xtwindeathdate,deathdate2=time_t,date=psy_date_group1, n=6,mark='6.others',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)

data subtype_twin_any_2;
set tab_1-tab_6;
mark=compress('firsty_cohort1'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

data subtype_twin_ir_any_2;
set ir1-ir6;
mark=compress('firsty_cohort1'||'_'||mark);
run;
data myhome.newcat_allhr;set subtype_twin_any_1-subtype_twin_any_2;run;
data myhome.newcat_allir;set subtype_twin_ir_any_1-subtype_twin_ir_any_2;run;
ods rtf file='Z:\projects\PTSD\STR\SAS RESULTS 20190507\newcat_subtype0509_cohort1.rtf';

proc print data=mt.newcat_allhr noobs;
run;

proc print data=mt.newcat_allir noobs;
run;
ods rtf close;

/*all period--cohort2*/
data subtype;
Set myhome.test_nfs;
psy_date_group1=min(psy_date_8,psy_date_9,psy_date_10,psy_date_11,psy_date_12);
run;

%subtype_n(data=subtype,deathdate2=xtwindeathdate,deathdate1=deathdate_nfs,date=psy_date_3,n=6,mark='6.psychotic disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate2=xtwindeathdate,deathdate1=deathdate_nfs,date=psy_date_4, n=1,mark='1.mood disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate2=xtwindeathdate,deathdate1=deathdate_nfs,date=psy_date_51, n=3,mark='3.anxiety',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate2=xtwindeathdate,deathdate1=deathdate_nfs,date=psy_date_52, n=2,mark='2.stress-related disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate2=xtwindeathdate,deathdate1=deathdate_nfs,date=psy_date_6, n=5,mark='5.eating disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate2=xtwindeathdate,deathdate1=deathdate_nfs,date=psy_date_7, n=4,mark='4.substance misuse',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate2=xtwindeathdate,deathdate1=deathdate_nfs,date=psy_date_group1, n=7,mark='7.others',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)

data subtype_twin_any_3;
set tab_1-tab_7;
mark=compress('all_cohort2'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

data subtype_twin_ir_any_3;
set ir1-ir7;
mark=compress('all_cohort2'||'_'||mark);
run;

/*the fisrt year period---cohor2*/
data subtype;set subtype;
format time_t YYMMDD10.;
time_t=min(xtwindeathdate,INTNX('day',xstart_cox,365,'s'));
run;
%subtype_n(data=subtype,deathdate1=deathdate_nfs,deathdate2=time_t,date=psy_date_3,n=6,mark='6.psychotic disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=deathdate_nfs,deathdate2=time_t,date=psy_date_4, n=1,mark='1.mood disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=deathdate_nfs,deathdate2=time_t,date=psy_date_51, n=3,mark='3.anxiety',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=deathdate_nfs,deathdate2=time_t,date=psy_date_52, n=2,mark='2.stress-related disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=deathdate_nfs,deathdate2=time_t,date=psy_date_6, n=5,mark='5.eating disorder',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=deathdate_nfs,deathdate2=time_t,date=psy_date_7, n=4,mark='4.substance misuse',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)
%subtype_n(data=subtype,deathdate1=deathdate_nfs,deathdate2=time_t,date=psy_date_group1, n=7,mark='7.others',var=xedu_n xrel_n xinkp_n xcci_n inf_fh_n)

data subtype_twin_any_4;
set tab_1-tab_7;
mark=compress('firsty_cohort2'||'_'||mark);
keep hr mark HazardRatio HRLowerCL HRUpperCL;
run;

data subtype_twin_ir_any_4;
set ir1-ir7;
mark=compress('firsty_cohort2'||'_'||mark);
run;


data myhome.newcat_allhr;set subtype_twin_any_1-subtype_twin_any_6;run;
data myhome.newcat_allir;set subtype_twin_ir_any_1-subtype_twin_ir_any_6;run;

ods rtf file='Z:\projects\PTSD\STR\SAS RESULTS 20190507\newcat_subtype0508.rtf';

proc print data=mt.newcat_allhr noobs;
run;

proc print data=mt.newcat_allir noobs;
run;
ods rtf close;

/*by age*/
/*export data for STATA---age analysis*/
data export;set myhome.test1_n;
keep kon _cc xedu_n xinkp_n xage xrel_n xcci_n inf_fh_n lopnr_n _setno_new xcum psy_n;
run;
proc export data=mtw.export outfile= "Z:\projects\PTSD\STR\AGE_HR_n.dta" replace; run;
