# This code plots figure 2 of manuscript "Spatio-temporal associations between deforestation and malaria incidence in Lao PDR"
# Author: Francois Rerolle
# Date: November 24th 2020 (Revised submission)

# Load packages
library(tidyverse)
library(ggplot2)


# Load the data
########## Incidence
malariaIncidence <- read_csv(file = "Source_data_file_Figure_2_Revised_Submission.csv")

# Plot
malariaIncidencePlot <- (malariaIncidence
                         %>% gather(Label, Estimate, c(Incidence_Overall, Incidence_Pf, Incidence_Pv, Test_Positivity_Overall, Test_Positivity_Pf, Test_Positivity_Pv))
                         %>% mutate(Species = ifelse(test = (Label %in% c("Incidence_Overall", "Test_Positivity_Overall")),
                                                     yes = "Overall",
                                                     no = ifelse(test = (Label %in% c("Incidence_Pf", "Test_Positivity_Pf")),
                                                                 yes = "Pf",
                                                                 no = "Pv")),
                                    Measure = ifelse(test = (Label %in% c("Incidence_Overall", "Incidence_Pf", "Incidence_Pv")),
                                                     yes = "Incidence (per 1000)",
                                                     no = "Test positivity (%)")
                         )
                         %>% ggplot(aes(x = Month_ID, y = Estimate, col = Species))
                         + geom_line()
                         + facet_grid(Measure ~ Region,
                                      scales = "free")
                         + scale_y_continuous(name = "")
                         + scale_x_continuous(name = "Time",
                                              breaks = c(4,
                                                         10,
                                                         16,
                                                         22,
                                                         28,
                                                         34,
                                                         40,
                                                         46),
                                              labels = c("Apr 2013",
                                                         "Oct 2013",
                                                         "Apr 2014",
                                                         "Oct 2014",
                                                         "Apr 2015",
                                                         "Oct 2015",
                                                         "Apr 2016",
                                                         "Oct 2016"))
                         + scale_color_manual(values=c("#000000", "#56B4E9", "#E69F00"))
                         + theme(axis.title = element_text(size = 14),
                                 axis.text = element_text(size = 11),
                                 axis.text.x = element_text(angle = 45, vjust = 0.8, size = 9),
                                 legend.title = element_text(size = 16),
                                 legend.text = element_text(size = 14),
                                 strip.text = element_text(size = 14))
)


pdf("/Manuscript/figure/malariaIncidenceTestPositivity.pdf")
malariaIncidencePlot
dev.off()

# North indent
malariaIncidencePlotNorth <- (malariaIncidence
                              %>% gather(Label, Estimate, c(Incidence_Overall, Incidence_Pf, Incidence_Pv, Test_Positivity_Overall, Test_Positivity_Pf, Test_Positivity_Pv))
                              %>% mutate(Species = ifelse(test = (Label %in% c("Incidence_Overall", "Test_Positivity_Overall")),
                                                          yes = "Overall",
                                                          no = ifelse(test = (Label %in% c("Incidence_Pf", "Test_Positivity_Pf")),
                                                                      yes = "Pf",
                                                                      no = "Pv")),
                                         Measure = ifelse(test = (Label %in% c("Incidence_Overall", "Incidence_Pf", "Incidence_Pv")),
                                                          yes = "Incidence (per 1000)",
                                                          no = "Test positivity (%)")
                              )
                              %>% filter(Measure == "Incidence (per 1000)")
                              %>% filter(Region == "North")
                              %>% filter(Month_ID >= 11)
                              %>% ggplot(aes(x = Month_ID, y = Estimate, col = Species))
                              + geom_line(size = 1.5)
                              + scale_y_continuous(name = "")
                              + scale_x_continuous(name = "",
                                                   breaks = c(4,
                                                              10,
                                                              16,
                                                              22,
                                                              28,
                                                              34,
                                                              40,
                                                              46),
                                                   labels = c("Apr 2013",
                                                              "Oct 2013",
                                                              "Apr 2014",
                                                              "Oct 2014",
                                                              "Apr 2015",
                                                              "Oct 2015",
                                                              "Apr 2016",
                                                              "Oct 2016"))
                              + scale_color_manual(values=c("#000000", "#56B4E9", "#E69F00"))
                              + theme(axis.title = element_text(size = 14),
                                      axis.text = element_text(size = 20),
                                      axis.text.y = element_text(size = 24),
                                      axis.text.x = element_text(angle = 45, vjust = 0.5),
                                      legend.title = element_text(size = 16),
                                      legend.text = element_text(size = 14),
                                      strip.text = element_text(size = 14),
                                      legend.position = "none")
)

pdf("/Users/francoisrerolle/Desktop/UCSF/Dissertation/Paper-1-Geospatial-Analysis-Forest-Incidence/Manuscript/figure/malariaIncidenceTestPositivityNorth.pdf")
malariaIncidencePlotNorth
dev.off()
