# This code plots figure 5 of manuscript "Spatio-temporal associations between deforestation and malaria incidence in Lao PDR"
# Author: Francois Rerolle
# Date: November 24th 2020 (Revised submission)

# Load packages
library(tidyverse)
library(ggplot2)
library(scales)

# Load the data
data_raw <- read_csv(file = "Source_data_file_Figure_5_And_Table_3_Revised_Submission.csv")

# Data management
data_alt <- (data_raw %>%
               mutate(Temporal_lag = ifelse(test = grepl(pattern = "1_Year", x = variable_names),
                                            yes = "1 year",
                                            no = ifelse(test = grepl(pattern = "2_Year", x = variable_names),
                                                        yes = "2 years",
                                                        no = ifelse(test = grepl(pattern = "3_Year", x = variable_names),
                                                                    yes = "3 years",
                                                                    no = ifelse(test = grepl(pattern = "4_Year", x = variable_names),
                                                                                yes = "4 years",
                                                                                no = "5 years")))),
                      Temporal_lag = factor(Temporal_lag, levels = c("1 year", "2 years", "3 years", "4 years", "5 years"))
               )
)


# Create forest plot
cbbPalette <- c("#000000", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7") # Color blind friendly palette
scales::show_col(cbbPalette)

# V1
p = ggplot(data=data_alt,
           aes(x = Region, y = IRR, ymin = IRR_ll, ymax = IRR_ul, col = Region)) +
  geom_pointrange(cex = 0.5) +
  geom_hline(yintercept = 1, linetype = 2, cex = 0.3) +
  ylab("Incidence rate ratio (95% CI)") +
  geom_errorbar( width = 0.5, cex = 0.6) +
  facet_grid(Temporal_lag ~ Threshold, switch = "y") +
  scale_color_manual(values=c("#56B4E9", "#E69F00"), guide = guide_legend(reverse=TRUE)) +
  ggtitle("Associations between malaria incidence and deforestation") +
  theme(plot.title = element_blank(),
        # plot.title = element_text(size = 14, face = "bold", hjust = 0.5),
        axis.text.x = element_text(size = 10),
        axis.ticks.y = element_blank(),
        axis.text.y = element_blank(),
        axis.title.y = element_blank(),
        axis.title = element_text(size = 12),
        legend.text = element_text(size = 10),
        legend.title = element_text(size = 12),
        legend.position = "top",
        strip.text.x = element_text(angle = 0, size = 12),
        strip.text.y = element_text(angle = 180, size = 12)) +
  coord_flip()

pdf("/Manuscript/figure/results_spatio_temporal_IRR_plot_alternative.pdf")
p
dev.off()