# This code looks runs model between malaria incidence and covariates

# Load packages
library(tidyverse)
library(mgcv)
library(parallel)
library(MASS)

# Load the data
load("Village_Year_Month_A3_Exposure_Covariates_Final_Last.RData")

### Function

model_associations_function <- function(Model_Formula_String, region){
  dataset_region <- (Village_Year_Month_A3_Exposure_Covariates_Final_Last %>%
                       filter(Region == region)
  )
  
  model.covariate  <- gam(as.formula(Model_Formula_String),
                          data = dataset_region,
                          family = "nb",
                          select = TRUE)
  
  # model.covariate  <- bam(as.formula(Model_Formula_String), # BAM instead of GAM is used for computational efficiency. 
  #                         data = dataset_region,
  #                         family = "nb",
  #                         discrete = T, # Descretizes covariates which really speeds things up
  #                         nthreads = 8, # Can parallelize some of the processing
  #                         select = TRUE)
  
  return(list(Model = model.covariate))
}

### Parallelize
number_core_to_use_Mac <- 6

number_core_to_use <- number_core_to_use_Mac

##### Modeling
### Formulas
formula_model_covariates_south_deforestation_previous_2_month <- c(
  # 1 km
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  
  # 10 km
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  
  # 30 km
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))"
  
)




formula_model_covariates_south_deforestation_previous_2_month_Pf <- c(
  # 1 km
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  
  # 10 km
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  
  # 30 km
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))"
  
)


formula_model_covariates_south_deforestation_previous_2_month_Pv <- c(
  # 1 km
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  
  # 10 km
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  
  # 30 km
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_1_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))"
  
)


formula_model_covariates_north_deforestation_previous_2_month <- c(
  # 1 km
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  
  # 10 km
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  
  # 30 km
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))"
  
)


formula_model_covariates_north_deforestation_previous_2_month_Pf <- c(
  # 1 km
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  
  # 10 km
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  
  # 30 km
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pf ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))"
  
)


formula_model_covariates_north_deforestation_previous_2_month_Pv <- c(
  # 1 km
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_1km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  
  # 10 km
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_10km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  
  # 30 km
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_1_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_1_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_2_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_2_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_3_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_3_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_4_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_4_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))",
  "Number_Positive_Pv ~ Percent_Area_Experienced_Forest_Loss_Village_Buffer_30km_In_Previous_5_Year + s(Average_Hansen_Tree_Crown_Density_Village_Buffer_30km_In_Previous_5_Year) + s(Monthly_Incidence_Rate_Previous_Month) + s(Monthly_Incidence_Rate_Previous_2_Month) + s(Temperature_Day_Monthly_Mean_Previous_2_Month) + s(Average_Temperature_Night_Monthly_Mean_Previous_0_1_2_3_Month) + s(Precipitation_Monthly_Total_Previous_2_Month) + s(TimeToNearestHF_Hours) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012) + s(Precipitation_Monthly_Total_Average_Annual_2008_2012_SD) + s(Average_Temperature_Monthly_Annual_2008_2012) + s(Average_Temperature_Monthly_Annual_2008_2012_SD) + s(Altitude) + s(Month_ID) + te(Longitude, Latitude) + s(Village_ID, bs=\"re\") + offset(log(Population_At_Risk))"
  
)


###### Models
### South
formula_model <- formula_model_covariates_south_deforestation_previous_2_month
t1 <- Sys.time()
association_models_south <- mclapply(X = as.list(formula_model),
                                     FUN = function(x){model_associations_function(Model_Formula_String = x,
                                                                                   region = "South")},
                                     mc.cores = number_core_to_use)

save(file="association_models_south_covariates_deforestation_previous_2_month.RData", association_models_south)
t2 <- Sys.time()
t2-t1

### North
formula_model <- formula_model_covariates_north_deforestation_previous_2_month
t3 <- Sys.time()
association_models_north <- mclapply(X = as.list(formula_model),
                                     FUN = function(x){model_associations_function(Model_Formula_String = x,
                                                                                   region = "North")},
                                     mc.cores = number_core_to_use)


save(file="association_models_north_covariates_deforestation_previous_2_month.RData", association_models_north) 
t4 <- Sys.time()
t4-t3

### South Pf
formula_model <- formula_model_covariates_south_deforestation_previous_2_month_Pf
association_models_south <- mclapply(X = as.list(formula_model),
                                     FUN = function(x){model_associations_function(Model_Formula_String = x,
                                                                                   region = "South")},
                                     mc.cores = number_core_to_use)

save(file="association_models_south_covariates_deforestation_previous_2_month_Pf.RData", association_models_south)


### South Pv
formula_model <- formula_model_covariates_south_deforestation_previous_2_month_Pv
association_models_south <- mclapply(X = as.list(formula_model),
                                     FUN = function(x){model_associations_function(Model_Formula_String = x,
                                                                                   region = "South")},
                                     mc.cores = number_core_to_use)

save(file="association_models_south_covariates_deforestation_previous_2_month_Pv.RData", association_models_south)
