(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[    279731,       5785]
NotebookOptionsPosition[    273490,       5685]
NotebookOutlinePosition[    273879,       5702]
CellTagsIndexPosition[    273836,       5699]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", 
  "]"}], "\[IndentingNewLine]", "\"\<finding fixed points\>\"", "\
\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"wb", " ", "nb", 
        FractionBox["1", "kb"], 
        RowBox[{"(", 
         RowBox[{"kb", "-", "nb", "-", 
          RowBox[{"a", " ", "wf", " ", "nf"}]}], ")"}]}], "\[Equal]", "0"}], 
      ",", 
      RowBox[{
       RowBox[{"wf", " ", "nf", 
        FractionBox["1", "kf"], 
        RowBox[{"(", 
         RowBox[{"kf", "-", "nf", "-", 
          RowBox[{"a", " ", "wb", " ", "nb"}]}], ")"}]}], "\[Equal]", "0"}]}],
      "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"nb", ",", "nf"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"3a0c5356-7fd2-426f-8c38-69a35cb23606"],

Cell[BoxData["\<\"finding fixed points\"\>"], "Output",
 CellChangeTimes->{3.797038837927352*^9, 3.803776824391856*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"c00c696f-7207-4562-9b08-fa979779e429"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"nb", "\[Rule]", "0"}], ",", 
     RowBox[{"nf", "\[Rule]", "kf"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"nb", "\[Rule]", 
      FractionBox[
       RowBox[{"kb", "-", 
        RowBox[{"a", " ", "kf", " ", "wf"}]}], 
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "wb", " ", "wf"}]}]]}], ",", 
     RowBox[{"nf", "\[Rule]", 
      FractionBox[
       RowBox[{"kf", "-", 
        RowBox[{"a", " ", "kb", " ", "wb"}]}], 
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "wb", " ", "wf"}]}]]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"nb", "\[Rule]", "0"}], ",", 
     RowBox[{"nf", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"nb", "\[Rule]", "kb"}], ",", 
     RowBox[{"nf", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.797038837927352*^9, 3.803776824495681*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"2b32fb06-829e-4fc8-b3b6-805504c08db0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["\"\<Jacobian matrix\>\""], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"7acbe017-a583-4458-9684-5cd25121895d"],

Cell[BoxData["\<\"Jacobian matrix\"\>"], "Output",
 CellChangeTimes->{3.797038838167472*^9, 3.8037768246750526`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"7ce5389c-f877-4229-9ca1-49b1274691a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"wb", " ", "nb", 
         FractionBox["1", "kb"], 
         RowBox[{"(", 
          RowBox[{"kb", "-", "nb", "-", 
           RowBox[{"a", " ", "wf", " ", "nf"}]}], ")"}]}], ",", "nb"}], "]"}], 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"wb", " ", "nb", 
         FractionBox["1", "kb"], 
         RowBox[{"(", 
          RowBox[{"kb", "-", "nb", "-", 
           RowBox[{"a", " ", "wf", " ", "nf"}]}], ")"}]}], ",", "nf"}], "]"}]},
     {
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"wf", " ", "nf", 
         FractionBox["1", "kf"], 
         RowBox[{"(", 
          RowBox[{"kf", "-", "nf", "-", 
           RowBox[{"a", " ", "wb", " ", "nb"}]}], ")"}]}], ",", "nb"}], "]"}], 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"wf", " ", "nf", 
         FractionBox["1", "kf"], 
         RowBox[{"(", 
          RowBox[{"kf", "-", "nf", "-", 
           RowBox[{"a", " ", "wb", " ", "nb"}]}], ")"}]}], ",", "nf"}], 
       "]"}]}
    }], "\[NoBreak]", ")"}], "]"}]], "Input",
 CellChangeTimes->{{3.642114998928423*^9, 3.6421150197166348`*^9}, {
  3.6421161778040533`*^9, 3.6421161901549788`*^9}, {3.642120333080978*^9, 
  3.6421203423928967`*^9}, {3.6421243857096443`*^9, 3.64212440295362*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"cfc807cb-dc84-455e-8f63-ff2b84b2918d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"wb", " ", 
       RowBox[{"(", 
        RowBox[{"kb", "-", 
         RowBox[{"2", " ", "nb"}], "-", 
         RowBox[{"a", " ", "nf", " ", "wf"}]}], ")"}]}], "kb"], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", " ", "nb", " ", "wb", " ", "wf"}], "kb"]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", " ", "nf", " ", "wb", " ", "wf"}], "kf"]}], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"kf", "-", 
         RowBox[{"2", " ", "nf"}], "-", 
         RowBox[{"a", " ", "nb", " ", "wb"}]}], ")"}], " ", "wf"}], "kf"]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.797038838227673*^9, 3.8037768247328587`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"59716f73-c5eb-42a2-9b45-75b783e2c808"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"fef9b995-e367-4c24-af3c-fa95843cc1e0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Eigenvalues", "[", "%", "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"nb", "\[Rule]", 
      FractionBox[
       RowBox[{"kb", "-", 
        RowBox[{"a", " ", "kf", " ", "wf"}]}], 
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "wb", " ", "wf"}]}]]}], ",", 
     RowBox[{"nf", "\[Rule]", 
      FractionBox[
       RowBox[{"kf", "-", 
        RowBox[{"a", " ", "kb", " ", "wb"}]}], 
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "wb", " ", "wf"}]}]]}]}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", "\"\<Eigenvalues of Jacobian matrix\>\""}], \
"Input",
 CellLabel->"In[7]:=",ExpressionUUID->"a1f93774-240b-49a8-91a4-2a1da2134c47"],

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "Null", "]"}]], "Output",
 CellChangeTimes->{3.7970388382411613`*^9, 3.80377682478223*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"08ecd7b5-7334-4b71-a6d7-86a1d0f948f0"],

Cell[BoxData["\<\"Eigenvalues of Jacobian matrix\"\>"], "Output",
 CellChangeTimes->{3.7970388382411613`*^9, 3.803776824784491*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"ffdf38e0-b6ae-470d-b2f9-75293f3c0635"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"6cb5f05d-5320-48bf-8028-6c191d4badcf"],

Cell[CellGroupData[{

Cell[BoxData[{"\"\<performance curves\>\"", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ff1", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"ti", "-", "topt"}], ")"}], "/", "2"}], "tva"}], ")"}], "^",
       "2"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ff2", "=", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"ti", "-", "topt"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"topt", "-", "tmax"}], ")"}]}], ")"}], "^", "2"}]}]}], 
  ";"}], "\[IndentingNewLine]", "\"\<environments\>\"", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tem", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "\[Pi]", " ", "ztv"}], ")"}], "^", 
     RowBox[{"-", "0.5"}]}], 
    RowBox[{"Exp", "[", 
     FractionBox[
      RowBox[{"-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"zm", "-", "ti"}], ")"}], "^", "2"}]}], 
      RowBox[{"2", "ztv"}]], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", "\"\<realized performances\>\"", "\
\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"ff1", "*", "tem"}], ",", 
     RowBox[{"{", 
      RowBox[{"ti", ",", "0", ",", "topt"}], "}"}]}], "]"}], "]"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"ff2", "*", "tem"}], ",", 
    RowBox[{"{", 
     RowBox[{"ti", ",", "topt", ",", "tmax"}], "}"}]}], "]"}], 
  "]"}]}], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"e605e63b-9b4d-4bdf-ba40-a7f0c922aab9"],

Cell[BoxData["\<\"performance curves\"\>"], "Output",
 CellChangeTimes->{3.7970388383106813`*^9, 3.803776824834584*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"109148b7-b456-45ae-893d-7e9e296e8a17"],

Cell[BoxData["\<\"environments\"\>"], "Output",
 CellChangeTimes->{3.7970388383106813`*^9, 3.8037768248367968`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"01eb489d-7755-4845-8b78-09ed072f7392"],

Cell[BoxData["\<\"realized performances\"\>"], "Output",
 CellChangeTimes->{3.7970388383106813`*^9, 3.803776824838629*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"7d519720-ad0e-427c-9b50-036a13e1963a"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.7071067811865475`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["tva", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"topt", "-", "zm"}], ")"}], "2"]}], 
      RowBox[{"4", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Erf", "[", 
      FractionBox[
       RowBox[{"topt", "-", "zm"}], 
       RowBox[{
        SqrtBox["ztv"], " ", 
        SqrtBox[
         RowBox[{"2", "+", 
          RowBox[{
           SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], "]"}], "-", 
     RowBox[{"Erf", "[", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "zm"}], "-", 
        RowBox[{"topt", " ", 
         SuperscriptBox["tva", "2"], " ", "ztv"}]}], 
       RowBox[{"2", " ", 
        SqrtBox["ztv"], " ", 
        SqrtBox[
         RowBox[{"2", "+", 
          RowBox[{
           SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], "]"}]}], ")"}]}], 
  SqrtBox[
   RowBox[{"2", "+", 
    RowBox[{
     SuperscriptBox["tva", "2"], " ", "ztv"}]}]]]], "Output",
 CellChangeTimes->{3.7970388383106813`*^9, 3.803776825615553*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"06ced8c1-c623-462f-86c5-3e319b03fb23"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"tmax", "-", "topt"}], ")"}], "2"], " ", 
    SuperscriptBox["ztv", "0.5`"]}]], 
  RowBox[{"0.3989422804014327`", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"topt", "-", "zm"}], ")"}], "2"], 
         RowBox[{"2", " ", "ztv"}]]}]], " ", 
      RowBox[{"(", 
       RowBox[{"topt", "-", "zm"}], ")"}], " ", "ztv"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"tmax", "-", "zm"}], ")"}], "2"], 
         RowBox[{"2", " ", "ztv"}]]}]], " ", 
      RowBox[{"(", 
       RowBox[{"tmax", "-", 
        RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}], " ", "ztv"}], "-", 
     RowBox[{
      SqrtBox[
       FractionBox["\[Pi]", "2"]], " ", 
      SqrtBox["ztv"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"tmax", "-", "zm"}], ")"}]}], " ", 
         RowBox[{"(", 
          RowBox[{"tmax", "-", 
           RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}]}], "+", "ztv"}], 
       ")"}], " ", 
      RowBox[{"Erf", "[", 
       FractionBox[
        RowBox[{"tmax", "-", "zm"}], 
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox["ztv"]}]], "]"}]}], "+", 
     RowBox[{
      SqrtBox[
       FractionBox["\[Pi]", "2"]], " ", 
      SqrtBox["ztv"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"tmax", "-", "zm"}], ")"}]}], " ", 
         RowBox[{"(", 
          RowBox[{"tmax", "-", 
           RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}]}], "+", "ztv"}], 
       ")"}], " ", 
      RowBox[{"Erf", "[", 
       FractionBox[
        RowBox[{"topt", "-", "zm"}], 
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox["ztv"]}]], "]"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.7970388383106813`*^9, 3.803776826835897*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"5905b218-909c-4875-85b5-8f740f01b72a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"topt", "=", "17"}], ";", 
  RowBox[{"tva", "=", "0.5"}], ";", 
  RowBox[{"tmax", "=", "23"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ti", "<", "topt"}], ",", "ff1", ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ti", "<", "tmax"}], ",", "ff2", ",", "0"}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"ti", ",", "1", ",", "40"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1.2"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Gray"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topt", "=", "30"}], ";", 
  RowBox[{"tva", "=", "0.2"}], ";", 
  RowBox[{"tmax", "=", "35"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ti", "<", "topt"}], ",", "ff1", ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ti", "<", "tmax"}], ",", "ff2", ",", "0"}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"ti", ",", "1", ",", "40"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1.2"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g1", ",", "g2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.64222443351097*^9, 3.642224509282836*^9}, {
  3.642224540343523*^9, 3.642224591752738*^9}, {3.6422246464376783`*^9, 
  3.642224789377116*^9}, {3.642224829738914*^9, 3.6422248875515013`*^9}, {
  3.6422257015262012`*^9, 3.642225800739739*^9}, {3.6422258531060133`*^9, 
  3.642225933086609*^9}, {3.642226038958222*^9, 3.6422260658727503`*^9}, {
  3.642227249196314*^9, 3.6422272820209208`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"a327c775-3930-4824-b11a-940d695878a8"],

Cell[BoxData[
 GraphicsBox[{{{{{}, {}, 
      TagBox[
       {GrayLevel[0.5], Thickness[Large], Opacity[1.], LineBox[CompressedData["
1:eJwVlmc41w8XxikzsvfI3utHGRnfc0pJw4qShiiRIhn1p0FkVTKTLdmjIdlS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         "]], LineBox[CompressedData["
1:eJxN0gs01dkeB3DMjBpXKCEyeZZx0hn/8xKG32/yyCMJeY6ESlLyCGWKkJEi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         "]]},
       Annotation[#, 
        "Charting`Private`Tag$5810#1"]& ], {}}, {{}, {}}, {{}, {}}}, {}}, \
{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwV0mc01o8bBnDKKpLsRPZKZmU+3+47kS0rlYiQFIWoVIiM8JNNVjKzUioy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         "]], LineBox[CompressedData["
1:eJxN0glUjVsbB/CjEp2kbsicSmQ4Tkk5Kt7nedN3KG7hNoilXEkpGsg1pFSG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         "]]},
       Annotation[#, 
        "Charting`Private`Tag$5929#1"]& ], {}}, {{}, {}}, {{}, {}}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 39.99999920408163}, {0, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.797038840639065*^9, 3.803776827105975*^9},
 CellLabel->"Out[22]=",ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"f21e20b7-f4ed-4758-b591-2140f1211ae4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"0.7071067811865475`", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["tva", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"topt", "-", "zm"}], ")"}], "2"]}], 
         RowBox[{"4", "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Erf", "[", 
         FractionBox[
          RowBox[{"topt", "-", "zm"}], 
          RowBox[{
           SqrtBox["ztv"], " ", 
           SqrtBox[
            RowBox[{"2", "+", 
             RowBox[{
              SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], "]"}], "-", 
        RowBox[{"Erf", "[", 
         FractionBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "zm"}], "-", 
           RowBox[{"topt", " ", 
            SuperscriptBox["tva", "2"], " ", "ztv"}]}], 
          RowBox[{"2", " ", 
           SqrtBox["ztv"], " ", 
           SqrtBox[
            RowBox[{"2", "+", 
             RowBox[{
              SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], "]"}]}], 
       ")"}]}], 
     SqrtBox[
      RowBox[{"2", "+", 
       RowBox[{
        SuperscriptBox["tva", "2"], " ", "ztv"}]}]]], "+", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"tmax", "-", "topt"}], ")"}], "2"], " ", 
       SuperscriptBox["ztv", "0.5`"]}]], "0.3989422804014327`", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"topt", "-", "zm"}], ")"}], "2"], 
           RowBox[{"2", " ", "ztv"}]]}]], " ", 
        RowBox[{"(", 
         RowBox[{"topt", "-", "zm"}], ")"}], " ", "ztv"}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"tmax", "-", "zm"}], ")"}], "2"], 
           RowBox[{"2", " ", "ztv"}]]}]], " ", 
        RowBox[{"(", 
         RowBox[{"tmax", "-", 
          RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}], " ", "ztv"}], "-", 
       RowBox[{
        SqrtBox[
         FractionBox["\[Pi]", "2"]], " ", 
        SqrtBox["ztv"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"tmax", "-", "zm"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{"tmax", "-", 
             RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}]}], "+", "ztv"}], 
         ")"}], " ", 
        RowBox[{"Erf", "[", 
         FractionBox[
          RowBox[{"tmax", "-", "zm"}], 
          RowBox[{
           SqrtBox["2"], " ", 
           SqrtBox["ztv"]}]], "]"}]}], "+", 
       RowBox[{
        SqrtBox[
         FractionBox["\[Pi]", "2"]], " ", 
        SqrtBox["ztv"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"tmax", "-", "zm"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{"tmax", "-", 
             RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}]}], "+", "ztv"}], 
         ")"}], " ", 
        RowBox[{"Erf", "[", 
         FractionBox[
          RowBox[{"topt", "-", "zm"}], 
          RowBox[{
           SqrtBox["2"], " ", 
           SqrtBox["ztv"]}]], "]"}]}]}], ")"}]}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"topt", "\[Rule]", " ", "toptf"}], ",", 
     RowBox[{"tmax", "\[Rule]", " ", "tmaxf"}], ",", 
     RowBox[{"tva", "\[Rule]", " ", "tvaf"}]}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", "\"\<realized performance\>\""}], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"bebd7ba0-ffb3-44b0-a71c-5de6804568bc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.015957691216057307`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"toptf", "-", "zm"}], ")"}], "2"], 
      RowBox[{"2", " ", "ztv"}]]}]], " ", 
   RowBox[{"(", 
    RowBox[{"toptf", "-", 
     RowBox[{"1.`", " ", "zm"}]}], ")"}], " ", 
   SuperscriptBox["ztv", "0.5`"]}], "+", 
  RowBox[{"0.015957691216057307`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"tmaxf", "-", "zm"}], ")"}], "2"], 
      RowBox[{"2", " ", "ztv"}]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "25.`"}], "+", "zm"}], ")"}], " ", 
   SuperscriptBox["ztv", "0.5`"]}], "-", 
  RowBox[{"0.019999999999999997`", " ", 
   RowBox[{"(", 
    RowBox[{"875.`", "\[VeryThinSpace]", "-", 
     RowBox[{"60.`", " ", "zm"}], "+", 
     SuperscriptBox["zm", "2"], "+", "ztv"}], ")"}], " ", 
   RowBox[{"Erf", "[", 
    FractionBox[
     RowBox[{"tmaxf", "-", "zm"}], 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox["ztv"]}]], "]"}]}], "+", 
  RowBox[{"0.019999999999999997`", " ", 
   RowBox[{"(", 
    RowBox[{"875.`", "\[VeryThinSpace]", "-", 
     RowBox[{"60.`", " ", "zm"}], "+", 
     SuperscriptBox["zm", "2"], "+", "ztv"}], ")"}], " ", 
   RowBox[{"Erf", "[", 
    FractionBox[
     RowBox[{"toptf", "-", "zm"}], 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox["ztv"]}]], "]"}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"0.04000000000000001`", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"toptf", "-", "zm"}], ")"}], "2"]}], 
       RowBox[{"4", "+", 
        RowBox[{"0.08000000000000002`", " ", "ztv"}]}]]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0.7071067811865475`", " ", 
       RowBox[{"Erf", "[", 
        FractionBox[
         RowBox[{"toptf", "-", "zm"}], 
         RowBox[{
          SqrtBox[
           RowBox[{"2", "+", 
            RowBox[{"0.04000000000000001`", " ", "ztv"}]}]], " ", 
          SqrtBox["ztv"]}]], "]"}]}], "-", 
      RowBox[{"0.7071067811865475`", " ", 
       RowBox[{"Erf", "[", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "1.`"}], " ", "zm"}], "-", 
          RowBox[{"0.6000000000000001`", " ", "ztv"}]}], 
         RowBox[{
          SqrtBox[
           RowBox[{"2", "+", 
            RowBox[{"0.04000000000000001`", " ", "ztv"}]}]], " ", 
          SqrtBox["ztv"]}]], "]"}]}]}], ")"}]}], 
   SqrtBox[
    RowBox[{"2", "+", 
     RowBox[{"0.04000000000000001`", " ", "ztv"}]}]]]}]], "Output",
 CellChangeTimes->{3.797038840979368*^9, 3.803776827407343*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"bd777dd1-0690-4c2f-87b4-d11cb888a8e9"],

Cell[BoxData["\<\"realized performance\"\>"], "Output",
 CellChangeTimes->{3.797038840979368*^9, 3.8037768274100313`*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"f3d77533-02e8-41dc-b08a-f8a5d09c5e5b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"\"\<beetle realized performance\>\"", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wb", "[", 
     RowBox[{"topt_", ",", "tmax_", ",", "tva_", ",", "ztv_", ",", "zm_"}], 
     "]"}], ":=", 
    RowBox[{
     RowBox[{"wb", "[", 
      RowBox[{"topt", ",", "tmax", ",", "tva", ",", "ztv", ",", "zm"}], "]"}],
      "=", 
     RowBox[{
      FractionBox[
       RowBox[{"0.7071067811865475`", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["tva", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"topt", "-", "zm"}], ")"}], "2"]}], 
           RowBox[{"4", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Erf", "[", 
           FractionBox[
            RowBox[{"topt", "-", "zm"}], 
            RowBox[{
             SqrtBox["ztv"], " ", 
             SqrtBox[
              RowBox[{"2", "+", 
               RowBox[{
                SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], "]"}], "-", 
          RowBox[{"Erf", "[", 
           FractionBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "zm"}], "-", 
             RowBox[{"topt", " ", 
              SuperscriptBox["tva", "2"], " ", "ztv"}]}], 
            RowBox[{"2", " ", 
             SqrtBox["ztv"], " ", 
             SqrtBox[
              RowBox[{"2", "+", 
               RowBox[{
                SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], "]"}]}], 
         ")"}]}], 
       SqrtBox[
        RowBox[{"2", "+", 
         RowBox[{
          SuperscriptBox["tva", "2"], " ", "ztv"}]}]]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"tmax", "-", "topt"}], ")"}], "2"], " ", 
         SuperscriptBox["ztv", "0.5`"]}]], "0.3989422804014327`", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"topt", "-", "zm"}], ")"}], "2"], 
             RowBox[{"2", " ", "ztv"}]]}]], " ", 
          RowBox[{"(", 
           RowBox[{"topt", "-", "zm"}], ")"}], " ", "ztv"}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"tmax", "-", "zm"}], ")"}], "2"], 
             RowBox[{"2", " ", "ztv"}]]}]], " ", 
          RowBox[{"(", 
           RowBox[{"tmax", "-", 
            RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}], " ", "ztv"}], "-", 
         RowBox[{
          SqrtBox[
           FractionBox["\[Pi]", "2"]], " ", 
          SqrtBox["ztv"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{"tmax", "-", "zm"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{"tmax", "-", 
               RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}]}], "+", "ztv"}],
            ")"}], " ", 
          RowBox[{"Erf", "[", 
           FractionBox[
            RowBox[{"tmax", "-", "zm"}], 
            RowBox[{
             SqrtBox["2"], " ", 
             SqrtBox["ztv"]}]], "]"}]}], "+", 
         RowBox[{
          SqrtBox[
           FractionBox["\[Pi]", "2"]], " ", 
          SqrtBox["ztv"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{"tmax", "-", "zm"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{"tmax", "-", 
               RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}]}], "+", "ztv"}],
            ")"}], " ", 
          RowBox[{"Erf", "[", 
           FractionBox[
            RowBox[{"topt", "-", "zm"}], 
            RowBox[{
             SqrtBox["2"], " ", 
             SqrtBox["ztv"]}]], "]"}]}]}], ")"}]}]}]}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\"\<blowflies realized performance\>\"", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wf", "[", 
     RowBox[{"toptf_", ",", "tmaxf_", ",", "tvaf_", ",", "ztv_", ",", "zm_"}],
      "]"}], ":=", 
    RowBox[{
     RowBox[{"wf", "[", 
      RowBox[{"toptf", ",", "tmaxf", ",", "tvaf", ",", "ztv", ",", "zm"}], 
      "]"}], "=", 
     RowBox[{
      RowBox[{
       FractionBox["1", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"tmaxf", "-", "toptf"}], ")"}], "2"], " ", 
         SuperscriptBox["ztv", "0.5`"]}]], "0.3989422804014327`", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"toptf", "-", "zm"}], ")"}], "2"], 
             RowBox[{"2", " ", "ztv"}]]}]], " ", 
          RowBox[{"(", 
           RowBox[{"toptf", "-", "zm"}], ")"}], " ", "ztv"}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"tmaxf", "-", "zm"}], ")"}], "2"], 
             RowBox[{"2", " ", "ztv"}]]}]], " ", 
          RowBox[{"(", 
           RowBox[{"tmaxf", "-", 
            RowBox[{"2", " ", "toptf"}], "+", "zm"}], ")"}], " ", "ztv"}], 
         "-", 
         RowBox[{
          SqrtBox[
           FractionBox["\[Pi]", "2"]], " ", 
          SqrtBox["ztv"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "tmaxf"}], "+", "zm"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"tmaxf", "-", 
               RowBox[{"2", " ", "toptf"}], "+", "zm"}], ")"}]}], "+", 
            "ztv"}], ")"}], " ", 
          RowBox[{"Erf", "[", 
           FractionBox[
            RowBox[{"tmaxf", "-", "zm"}], 
            RowBox[{
             SqrtBox["2"], " ", 
             SqrtBox["ztv"]}]], "]"}]}], "+", 
         RowBox[{
          SqrtBox[
           FractionBox["\[Pi]", "2"]], " ", 
          SqrtBox["ztv"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "tmaxf"}], "+", "zm"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"tmaxf", "-", 
               RowBox[{"2", " ", "toptf"}], "+", "zm"}], ")"}]}], "+", 
            "ztv"}], ")"}], " ", 
          RowBox[{"Erf", "[", 
           FractionBox[
            RowBox[{"toptf", "-", "zm"}], 
            RowBox[{
             SqrtBox["2"], " ", 
             SqrtBox["ztv"]}]], "]"}]}]}], ")"}]}], "+", 
      FractionBox[
       RowBox[{"0.7071067811865475`", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["tvaf", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"toptf", "-", "zm"}], ")"}], "2"]}], 
           RowBox[{"4", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Erf", "[", 
           FractionBox[
            RowBox[{"toptf", "-", "zm"}], 
            RowBox[{
             SqrtBox["ztv"], " ", 
             SqrtBox[
              RowBox[{"2", "+", 
               RowBox[{
                SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]}]], "]"}], "-", 
          RowBox[{"Erf", "[", 
           FractionBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "zm"}], "-", 
             RowBox[{"toptf", " ", 
              SuperscriptBox["tvaf", "2"], " ", "ztv"}]}], 
            RowBox[{"2", " ", 
             SqrtBox["ztv"], " ", 
             SqrtBox[
              RowBox[{"2", "+", 
               RowBox[{
                SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]}]], "]"}]}], 
         ")"}]}], 
       SqrtBox[
        RowBox[{"2", "+", 
         RowBox[{
          SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]]}]}]}], 
   "\[IndentingNewLine]", "\"\<Eigenvalues of Jacobian matrix\>\"", "\n", 
   RowBox[{"Clear", "[", "jac", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"jac", "[", 
      RowBox[{
      "topt_", ",", "tmax_", ",", "tva_", ",", "toptf_", ",", "tmaxf_", ",", 
       "tvaf_", ",", "ztv_", ",", "zm_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"jac", "[", 
       RowBox[{
       "topt", ",", "tmax", ",", "tva", ",", "toptf", ",", "tmaxf", ",", 
        "tvaf", ",", "ztv", ",", "zm"}], "]"}], "=", 
      RowBox[{
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", "kb", " ", "kf"}]], 
        RowBox[{"(", 
         FractionBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], " ", 
            SuperscriptBox["kb", "2"], " ", "wb", " ", "wf"}], "-", 
           RowBox[{"a", " ", 
            SuperscriptBox["kf", "2"], " ", "wb", " ", "wf"}], "+", 
           RowBox[{"kb", " ", "kf", " ", 
            RowBox[{"(", 
             RowBox[{"wb", "+", "wf"}], ")"}]}]}], 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "wb", " ", "wf"}]}]], ")"}]}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"wb", "\[Rule]", 
          RowBox[{
           FractionBox[
            RowBox[{"0.7071067811865475`", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                 SuperscriptBox["tva", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"topt", "-", "zm"}], ")"}], "2"]}], 
                RowBox[{"4", "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"topt", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["ztv"], " ", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], "]"}], 
               "-", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", "zm"}], "-", 
                  RowBox[{"topt", " ", 
                   SuperscriptBox["tva", "2"], " ", "ztv"}]}], 
                 RowBox[{"2", " ", 
                  SqrtBox["ztv"], " ", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], "]"}]}], 
              ")"}]}], 
            SqrtBox[
             RowBox[{"2", "+", 
              RowBox[{
               SuperscriptBox["tva", "2"], " ", "ztv"}]}]]], "+", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"tmax", "-", "topt"}], ")"}], "2"], " ", 
              SuperscriptBox["ztv", "0.5`"]}]], "0.3989422804014327`", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"topt", "-", "zm"}], ")"}], "2"], 
                  RowBox[{"2", " ", "ztv"}]]}]], " ", 
               RowBox[{"(", 
                RowBox[{"topt", "-", "zm"}], ")"}], " ", "ztv"}], "+", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"tmax", "-", "zm"}], ")"}], "2"], 
                  RowBox[{"2", " ", "ztv"}]]}]], " ", 
               RowBox[{"(", 
                RowBox[{"tmax", "-", 
                 RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}], " ", "ztv"}],
               "-", 
              RowBox[{
               SqrtBox[
                FractionBox["\[Pi]", "2"]], " ", 
               SqrtBox["ztv"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"tmax", "-", "zm"}], ")"}]}], " ", 
                  RowBox[{"(", 
                   RowBox[{"tmax", "-", 
                    RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}]}], "+", 
                 "ztv"}], ")"}], " ", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"tmax", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["2"], " ", 
                  SqrtBox["ztv"]}]], "]"}]}], "+", 
              RowBox[{
               SqrtBox[
                FractionBox["\[Pi]", "2"]], " ", 
               SqrtBox["ztv"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"tmax", "-", "zm"}], ")"}]}], " ", 
                  RowBox[{"(", 
                   RowBox[{"tmax", "-", 
                    RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}]}], "+", 
                 "ztv"}], ")"}], " ", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"topt", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["2"], " ", 
                  SqrtBox["ztv"]}]], "]"}]}]}], ")"}]}]}]}], ",", 
         RowBox[{"wf", "\[Rule]", " ", 
          RowBox[{
           RowBox[{
            FractionBox["1", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"tmaxf", "-", "toptf"}], ")"}], "2"], " ", 
              SuperscriptBox["ztv", "0.5`"]}]], "0.3989422804014327`", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"toptf", "-", "zm"}], ")"}], "2"], 
                  RowBox[{"2", " ", "ztv"}]]}]], " ", 
               RowBox[{"(", 
                RowBox[{"toptf", "-", "zm"}], ")"}], " ", "ztv"}], "+", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"tmaxf", "-", "zm"}], ")"}], "2"], 
                  RowBox[{"2", " ", "ztv"}]]}]], " ", 
               RowBox[{"(", 
                RowBox[{"tmaxf", "-", 
                 RowBox[{"2", " ", "toptf"}], "+", "zm"}], ")"}], " ", 
               "ztv"}], "-", 
              RowBox[{
               SqrtBox[
                FractionBox["\[Pi]", "2"]], " ", 
               SqrtBox["ztv"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tmaxf"}], "+", "zm"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"tmaxf", "-", 
                    RowBox[{"2", " ", "toptf"}], "+", "zm"}], ")"}]}], "+", 
                 "ztv"}], ")"}], " ", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"tmaxf", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["2"], " ", 
                  SqrtBox["ztv"]}]], "]"}]}], "+", 
              RowBox[{
               SqrtBox[
                FractionBox["\[Pi]", "2"]], " ", 
               SqrtBox["ztv"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tmaxf"}], "+", "zm"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"tmaxf", "-", 
                    RowBox[{"2", " ", "toptf"}], "+", "zm"}], ")"}]}], "+", 
                 "ztv"}], ")"}], " ", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"toptf", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["2"], " ", 
                  SqrtBox["ztv"]}]], "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            FractionBox["1", 
             SqrtBox[
              RowBox[{"2", "+", 
               RowBox[{
                SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]], 
            "0.7071067811865475`", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                SuperscriptBox["tvaf", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"toptf", "-", "zm"}], ")"}], "2"]}], 
               RowBox[{"4", "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Erf", "[", 
               FractionBox[
                RowBox[{"toptf", "-", "zm"}], 
                RowBox[{
                 SqrtBox["ztv"], " ", 
                 SqrtBox[
                  RowBox[{"2", "+", 
                   RowBox[{
                    SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]}]], "]"}], 
              "-", 
              RowBox[{"Erf", "[", 
               FractionBox[
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "zm"}], "-", 
                 RowBox[{"toptf", " ", 
                  SuperscriptBox["tvaf", "2"], " ", "ztv"}]}], 
                RowBox[{"2", " ", 
                 SqrtBox["ztv"], " ", 
                 SqrtBox[
                  RowBox[{"2", "+", 
                   RowBox[{
                    SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]}]], "]"}]}], 
             ")"}]}]}]}]}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   "\"\<numerial values of fixed points\>\"", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"nbb", "[", 
      RowBox[{
      "topt_", ",", "tmax_", ",", "tva_", ",", "ztv_", ",", "zm_", ",", "kb_",
        ",", "kf_", ",", "a_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"nbb", "[", 
       RowBox[{
       "topt", ",", "tmax", ",", "tva", ",", "ztv", ",", "zm", ",", "kb", ",",
         "kf", ",", "a"}], "]"}], "=", 
      RowBox[{
       FractionBox[
        RowBox[{"kb", "-", 
         RowBox[{"a", " ", "kf", " ", "wf"}]}], 
        RowBox[{"1", "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "wb", " ", "wf"}]}]], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"wb", "\[Rule]", 
          RowBox[{
           FractionBox[
            RowBox[{"0.7071067811865475`", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                 SuperscriptBox["tva", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"topt", "-", "zm"}], ")"}], "2"]}], 
                RowBox[{"4", "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"topt", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["ztv"], " ", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], "]"}], 
               "-", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", "zm"}], "-", 
                  RowBox[{"topt", " ", 
                   SuperscriptBox["tva", "2"], " ", "ztv"}]}], 
                 RowBox[{"2", " ", 
                  SqrtBox["ztv"], " ", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], "]"}]}], 
              ")"}]}], 
            SqrtBox[
             RowBox[{"2", "+", 
              RowBox[{
               SuperscriptBox["tva", "2"], " ", "ztv"}]}]]], "+", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"tmax", "-", "topt"}], ")"}], "2"], " ", 
              SuperscriptBox["ztv", "0.5`"]}]], "0.3989422804014327`", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"topt", "-", "zm"}], ")"}], "2"], 
                  RowBox[{"2", " ", "ztv"}]]}]], " ", 
               RowBox[{"(", 
                RowBox[{"topt", "-", "zm"}], ")"}], " ", "ztv"}], "+", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"tmax", "-", "zm"}], ")"}], "2"], 
                  RowBox[{"2", " ", "ztv"}]]}]], " ", 
               RowBox[{"(", 
                RowBox[{"tmax", "-", 
                 RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}], " ", "ztv"}],
               "-", 
              RowBox[{
               SqrtBox[
                FractionBox["\[Pi]", "2"]], " ", 
               SqrtBox["ztv"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"tmax", "-", "zm"}], ")"}]}], " ", 
                  RowBox[{"(", 
                   RowBox[{"tmax", "-", 
                    RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}]}], "+", 
                 "ztv"}], ")"}], " ", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"tmax", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["2"], " ", 
                  SqrtBox["ztv"]}]], "]"}]}], "+", 
              RowBox[{
               SqrtBox[
                FractionBox["\[Pi]", "2"]], " ", 
               SqrtBox["ztv"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"tmax", "-", "zm"}], ")"}]}], " ", 
                  RowBox[{"(", 
                   RowBox[{"tmax", "-", 
                    RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}]}], "+", 
                 "ztv"}], ")"}], " ", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"topt", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["2"], " ", 
                  SqrtBox["ztv"]}]], "]"}]}]}], ")"}]}]}]}], ",", 
         RowBox[{"wf", "\[Rule]", " ", 
          RowBox[{
           RowBox[{
            FractionBox["1", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"tmaxf", "-", "toptf"}], ")"}], "2"], " ", 
              SuperscriptBox["ztv", "0.5`"]}]], "0.3989422804014327`", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"toptf", "-", "zm"}], ")"}], "2"], 
                  RowBox[{"2", " ", "ztv"}]]}]], " ", 
               RowBox[{"(", 
                RowBox[{"toptf", "-", "zm"}], ")"}], " ", "ztv"}], "+", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"tmaxf", "-", "zm"}], ")"}], "2"], 
                  RowBox[{"2", " ", "ztv"}]]}]], " ", 
               RowBox[{"(", 
                RowBox[{"tmaxf", "-", 
                 RowBox[{"2", " ", "toptf"}], "+", "zm"}], ")"}], " ", 
               "ztv"}], "-", 
              RowBox[{
               SqrtBox[
                FractionBox["\[Pi]", "2"]], " ", 
               SqrtBox["ztv"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tmaxf"}], "+", "zm"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"tmaxf", "-", 
                    RowBox[{"2", " ", "toptf"}], "+", "zm"}], ")"}]}], "+", 
                 "ztv"}], ")"}], " ", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"tmaxf", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["2"], " ", 
                  SqrtBox["ztv"]}]], "]"}]}], "+", 
              RowBox[{
               SqrtBox[
                FractionBox["\[Pi]", "2"]], " ", 
               SqrtBox["ztv"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tmaxf"}], "+", "zm"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"tmaxf", "-", 
                    RowBox[{"2", " ", "toptf"}], "+", "zm"}], ")"}]}], "+", 
                 "ztv"}], ")"}], " ", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"toptf", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["2"], " ", 
                  SqrtBox["ztv"]}]], "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            FractionBox["1", 
             SqrtBox[
              RowBox[{"2", "+", 
               RowBox[{
                SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]], 
            "0.7071067811865475`", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                SuperscriptBox["tvaf", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"toptf", "-", "zm"}], ")"}], "2"]}], 
               RowBox[{"4", "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Erf", "[", 
               FractionBox[
                RowBox[{"toptf", "-", "zm"}], 
                RowBox[{
                 SqrtBox["ztv"], " ", 
                 SqrtBox[
                  RowBox[{"2", "+", 
                   RowBox[{
                    SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]}]], "]"}], 
              "-", 
              RowBox[{"Erf", "[", 
               FractionBox[
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "zm"}], "-", 
                 RowBox[{"toptf", " ", 
                  SuperscriptBox["tvaf", "2"], " ", "ztv"}]}], 
                RowBox[{"2", " ", 
                 SqrtBox["ztv"], " ", 
                 SqrtBox[
                  RowBox[{"2", "+", 
                   RowBox[{
                    SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]}]], "]"}]}], 
             ")"}]}]}]}]}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"nff", "[", 
      RowBox[{
      "toptf_", ",", "tmaxf_", ",", "tvaf_", ",", "ztv_", ",", "zm_", ",", 
       "kb_", ",", "kf_", ",", "a_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"nff", "[", 
       RowBox[{
       "toptf", ",", "tmaxf", ",", "tvaf", ",", "ztv", ",", "zm", ",", "kb", 
        ",", "kf", ",", "a"}], "]"}], "=", 
      RowBox[{
       FractionBox[
        RowBox[{"kf", "-", 
         RowBox[{"a", " ", "kb", " ", "wb"}]}], 
        RowBox[{"1", "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "wb", " ", "wf"}]}]], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"wb", "\[Rule]", 
          RowBox[{
           FractionBox[
            RowBox[{"0.7071067811865475`", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                 SuperscriptBox["tva", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"topt", "-", "zm"}], ")"}], "2"]}], 
                RowBox[{"4", "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"topt", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["ztv"], " ", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], "]"}], 
               "-", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", "zm"}], "-", 
                  RowBox[{"topt", " ", 
                   SuperscriptBox["tva", "2"], " ", "ztv"}]}], 
                 RowBox[{"2", " ", 
                  SqrtBox["ztv"], " ", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["tva", "2"], " ", "ztv"}]}]]}]], "]"}]}], 
              ")"}]}], 
            SqrtBox[
             RowBox[{"2", "+", 
              RowBox[{
               SuperscriptBox["tva", "2"], " ", "ztv"}]}]]], "+", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"tmax", "-", "topt"}], ")"}], "2"], " ", 
              SuperscriptBox["ztv", "0.5`"]}]], "0.3989422804014327`", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"topt", "-", "zm"}], ")"}], "2"], 
                  RowBox[{"2", " ", "ztv"}]]}]], " ", 
               RowBox[{"(", 
                RowBox[{"topt", "-", "zm"}], ")"}], " ", "ztv"}], "+", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"tmax", "-", "zm"}], ")"}], "2"], 
                  RowBox[{"2", " ", "ztv"}]]}]], " ", 
               RowBox[{"(", 
                RowBox[{"tmax", "-", 
                 RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}], " ", "ztv"}],
               "-", 
              RowBox[{
               SqrtBox[
                FractionBox["\[Pi]", "2"]], " ", 
               SqrtBox["ztv"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"tmax", "-", "zm"}], ")"}]}], " ", 
                  RowBox[{"(", 
                   RowBox[{"tmax", "-", 
                    RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}]}], "+", 
                 "ztv"}], ")"}], " ", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"tmax", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["2"], " ", 
                  SqrtBox["ztv"]}]], "]"}]}], "+", 
              RowBox[{
               SqrtBox[
                FractionBox["\[Pi]", "2"]], " ", 
               SqrtBox["ztv"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"tmax", "-", "zm"}], ")"}]}], " ", 
                  RowBox[{"(", 
                   RowBox[{"tmax", "-", 
                    RowBox[{"2", " ", "topt"}], "+", "zm"}], ")"}]}], "+", 
                 "ztv"}], ")"}], " ", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"topt", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["2"], " ", 
                  SqrtBox["ztv"]}]], "]"}]}]}], ")"}]}]}]}], ",", 
         RowBox[{"wf", "\[Rule]", " ", 
          RowBox[{
           RowBox[{
            FractionBox["1", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"tmaxf", "-", "toptf"}], ")"}], "2"], " ", 
              SuperscriptBox["ztv", "0.5`"]}]], "0.3989422804014327`", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"toptf", "-", "zm"}], ")"}], "2"], 
                  RowBox[{"2", " ", "ztv"}]]}]], " ", 
               RowBox[{"(", 
                RowBox[{"toptf", "-", "zm"}], ")"}], " ", "ztv"}], "+", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"tmaxf", "-", "zm"}], ")"}], "2"], 
                  RowBox[{"2", " ", "ztv"}]]}]], " ", 
               RowBox[{"(", 
                RowBox[{"tmaxf", "-", 
                 RowBox[{"2", " ", "toptf"}], "+", "zm"}], ")"}], " ", 
               "ztv"}], "-", 
              RowBox[{
               SqrtBox[
                FractionBox["\[Pi]", "2"]], " ", 
               SqrtBox["ztv"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tmaxf"}], "+", "zm"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"tmaxf", "-", 
                    RowBox[{"2", " ", "toptf"}], "+", "zm"}], ")"}]}], "+", 
                 "ztv"}], ")"}], " ", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"tmaxf", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["2"], " ", 
                  SqrtBox["ztv"]}]], "]"}]}], "+", 
              RowBox[{
               SqrtBox[
                FractionBox["\[Pi]", "2"]], " ", 
               SqrtBox["ztv"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tmaxf"}], "+", "zm"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"tmaxf", "-", 
                    RowBox[{"2", " ", "toptf"}], "+", "zm"}], ")"}]}], "+", 
                 "ztv"}], ")"}], " ", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{"toptf", "-", "zm"}], 
                 RowBox[{
                  SqrtBox["2"], " ", 
                  SqrtBox["ztv"]}]], "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            FractionBox["1", 
             SqrtBox[
              RowBox[{"2", "+", 
               RowBox[{
                SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]], 
            "0.7071067811865475`", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                SuperscriptBox["tvaf", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"toptf", "-", "zm"}], ")"}], "2"]}], 
               RowBox[{"4", "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Erf", "[", 
               FractionBox[
                RowBox[{"toptf", "-", "zm"}], 
                RowBox[{
                 SqrtBox["ztv"], " ", 
                 SqrtBox[
                  RowBox[{"2", "+", 
                   RowBox[{
                    SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]}]], "]"}], 
              "-", 
              RowBox[{"Erf", "[", 
               FractionBox[
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "zm"}], "-", 
                 RowBox[{"toptf", " ", 
                  SuperscriptBox["tvaf", "2"], " ", "ztv"}]}], 
                RowBox[{"2", " ", 
                 SqrtBox["ztv"], " ", 
                 SqrtBox[
                  RowBox[{"2", "+", 
                   RowBox[{
                    SuperscriptBox["tvaf", "2"], " ", "ztv"}]}]]}]], "]"}]}], 
             ")"}]}]}]}]}], "}"}]}]}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"e8a525b9-6498-4351-9310-7d74ceb83118"],

Cell[BoxData["\<\"beetle realized performance\"\>"], "Output",
 CellChangeTimes->{3.797038841052541*^9, 3.803776827428164*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"e66f5298-e9bf-42f9-8b9b-e95c63c97a49"],

Cell[BoxData["\<\"blowflies realized performance\"\>"], "Output",
 CellChangeTimes->{3.797038841052541*^9, 3.803776827429943*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"08177e03-2225-4c74-ac8d-91aa3380d447"],

Cell[BoxData["\<\"Eigenvalues of Jacobian matrix\"\>"], "Output",
 CellChangeTimes->{3.797038841052541*^9, 3.8037768274315023`*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"7a1ddc55-ef01-4d96-93e5-672593fdaa2a"],

Cell[BoxData["\<\"numerial values of fixed points\"\>"], "Output",
 CellChangeTimes->{3.797038841052541*^9, 3.803776827470686*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"bc5d0105-5aa2-4dc9-bbf4-cad289a74185"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"topt", "=", "17"}], ";", 
  RowBox[{"tva", "=", "0.5"}], ";", 
  RowBox[{"tmax", "=", "23"}], ";", 
  RowBox[{"toptf", "=", "30"}], ";", 
  RowBox[{"tvaf", "=", "0.2"}], ";", 
  RowBox[{"tmaxf", "=", "35"}], ";", 
  RowBox[{"zm", "=", "16"}], ";", 
  RowBox[{"ztv", "=", "10"}], ";", 
  RowBox[{"kf", "=", "130"}], ";", 
  RowBox[{"kb", "=", "100"}], ";", 
  RowBox[{"a", "=", "1.9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"wb", "[", 
    RowBox[{"topt", ",", "tmax", ",", "tva", ",", "ztv", ",", "zm"}], "]"}], 
   ",", 
   RowBox[{"wf", "[", 
    RowBox[{"toptf", ",", "tmaxf", ",", "tvaf", ",", "ztv", ",", "zm"}], 
    "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topt", "=", "17"}], ";", 
  RowBox[{"tva", "=", "0.4"}], ";", 
  RowBox[{"tmax", "=", "24"}], ";", 
  RowBox[{"toptf", "=", "30"}], ";", 
  RowBox[{"tvaf", "=", "0.3"}], ";", 
  RowBox[{"tmaxf", "=", "35"}], ";", 
  RowBox[{"zm", "=", "24"}], ";", 
  RowBox[{"ztv", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"wb", "[", 
    RowBox[{"topt", ",", "tmax", ",", "tva", ",", "ztv", ",", "zm"}], "]"}], 
   ",", 
   RowBox[{"wf", "[", 
    RowBox[{"toptf", ",", "tmaxf", ",", "tvaf", ",", "ztv", ",", "zm"}], 
    "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{"jac", "[", 
  RowBox[{
  "topt", ",", "tmax", ",", "tva", ",", "toptf", ",", "tmaxf", ",", "tvaf", 
   ",", "ztv", ",", "zm"}], "]"}]}], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"aa35193a-40ca-4cca-983d-2931a663b402"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6785150538364082`", ",", "0.17826309107038668`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7970388410682163`*^9, 3.803776827481572*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"413552a9-85fe-41c9-b079-15cdbddd9aa6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2580085529284214`", ",", "0.47355460135667593`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7970388410682163`*^9, 3.803776827483686*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"d370bea5-74a4-4a7a-b48c-efee6fe465b0"],

Cell[BoxData[
 RowBox[{"-", "0.2247196149538354`"}]], "Output",
 CellChangeTimes->{3.7970388410682163`*^9, 3.8037768274853983`*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"97009625-3247-4c27-8a7e-e7760d9463d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"zm", ",", "ztv", ",", "g1", ",", "g2", ",", "g3"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topt", "=", "16"}], ";", 
  RowBox[{"tva", "=", "0.3"}], ";", 
  RowBox[{"tmax", "=", "24"}], ";", 
  RowBox[{"tvaf", "=", "0.1"}], ";", 
  RowBox[{"toptf", "=", "25"}], ";", 
  RowBox[{"tmaxf", "=", "40"}], ";", 
  RowBox[{"ztv", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"g1", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"wb", "[", 
      RowBox[{"topt", ",", "tmax", ",", "tva", ",", "ztv", ",", "zm"}], "]"}], 
     RowBox[{"wf", "[", 
      RowBox[{"toptf", ",", "tmaxf", ",", "tvaf", ",", "ztv", ",", "zm"}], 
      "]"}]], ",", 
    RowBox[{"{", 
     RowBox[{"zm", ",", "1", ",", "25"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topt", "=", "16"}], ";", 
  RowBox[{"tva", "=", "0.3"}], ";", 
  RowBox[{"tmax", "=", "24"}], ";", 
  RowBox[{"toptf", "=", "30"}], ";", 
  RowBox[{"tvaf", "=", "0.1"}], ";", 
  RowBox[{"tmaxf", "=", "40"}], ";", 
  RowBox[{"ztv", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"g2", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"wb", "[", 
      RowBox[{"topt", ",", "tmax", ",", "tva", ",", "ztv", ",", "zm"}], "]"}], 
     RowBox[{"wf", "[", 
      RowBox[{"toptf", ",", "tmaxf", ",", "tvaf", ",", "ztv", ",", "zm"}], 
      "]"}]], ",", 
    RowBox[{"{", 
     RowBox[{"zm", ",", "1", ",", "25"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topt", "=", "16"}], ";", 
  RowBox[{"tva", "=", "0.3"}], ";", 
  RowBox[{"tmax", "=", "24"}], ";", 
  RowBox[{"toptf", "=", "35"}], ";", 
  RowBox[{"tvaf", "=", "0.1"}], ";", 
  RowBox[{"tmaxf", "=", "40"}], ";", 
  RowBox[{"ztv", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"g3", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"wb", "[", 
      RowBox[{"topt", ",", "tmax", ",", "tva", ",", "ztv", ",", "zm"}], "]"}], 
     RowBox[{"wf", "[", 
      RowBox[{"toptf", ",", "tmaxf", ",", "tvaf", ",", "ztv", ",", "zm"}], 
      "]"}]], ",", 
    RowBox[{"{", 
     RowBox[{"zm", ",", "1", ",", "25"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g1", ",", "g2", ",", "g3"}], "]"}]}], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"f2433d8c-e061-4ac8-854e-a478f06bd68b"],

Cell[BoxData[
 TemplateBox[{
  "General","munfl",
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"760.480878977333`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"",2,42,1,
   33008439701447293887,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7970388411979103`*^9, 3.8037768275609207`*^9},
 CellLabel->
  "\:8a08\:7b97\:4e2d\:ff1aIn[40]:=",ExpressionUUID->"2ffc9690-6e78-40f8-80d6-\
3af1149d039d"],

Cell[BoxData[
 TemplateBox[{
  "General","munfl",
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"760.480878977333`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"",2,42,2,
   33008439701447293887,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7970388411979103`*^9, 3.803776827607316*^9},
 CellLabel->
  "\:8a08\:7b97\:4e2d\:ff1aIn[40]:=",ExpressionUUID->"39fbb93c-0c2c-448d-9efa-\
70164ccba186"],

Cell[BoxData[
 TemplateBox[{
  "General","munfl",
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"760.4999808979594`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"",2,42,3,
   33008439701447293887,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7970388411979103`*^9, 3.803776827655466*^9},
 CellLabel->
  "\:8a08\:7b97\:4e2d\:ff1aIn[40]:=",ExpressionUUID->"c2dc3455-75ce-45f3-a581-\
edea225374e8"],

Cell[BoxData[
 TemplateBox[{
  "General","stop",
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"",2,42,4,33008439701447293887,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7970388411979103`*^9, 3.803776827660527*^9},
 CellLabel->
  "\:8a08\:7b97\:4e2d\:ff1aIn[40]:=",ExpressionUUID->"6d3391c9-0167-4249-a221-\
29374eb3a5bc"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd13k4VV0XAPCLRMYIidKgTPeea0r3VrIWiuSNekuhSFI0okESZc6QMZkj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       "]]},
     Annotation[#, "Charting`Private`Tag$5976#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 24.99999951020408}, {0, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.7970388414297132`*^9, 3.8037768277030087`*^9},
 CellLabel->"Out[42]=",ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"8a342f62-f374-403c-9f35-92610cfa9ade"],

Cell[BoxData[
 TemplateBox[{
  "General","munfl",
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"760.480878977333`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"",2,44,5,
   33008439701447293887,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7970388411979103`*^9, 3.8037768277510633`*^9},
 CellLabel->
  "\:8a08\:7b97\:4e2d\:ff1aIn[40]:=",ExpressionUUID->"94a54dfc-5534-4221-af16-\
cba2f1a82cd0"],

Cell[BoxData[
 TemplateBox[{
  "General","munfl",
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"760.480878977333`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"",2,44,6,
   33008439701447293887,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7970388411979103`*^9, 3.803776827757209*^9},
 CellLabel->
  "\:8a08\:7b97\:4e2d\:ff1aIn[40]:=",ExpressionUUID->"1dc6adcd-fb4f-4c30-a4a5-\
d801731139d0"],

Cell[BoxData[
 TemplateBox[{
  "General","munfl",
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"760.4999808979594`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"",2,44,7,
   33008439701447293887,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7970388411979103`*^9, 3.8037768278032007`*^9},
 CellLabel->
  "\:8a08\:7b97\:4e2d\:ff1aIn[40]:=",ExpressionUUID->"827c0746-5b95-46ed-9853-\
2218dec67acb"],

Cell[BoxData[
 TemplateBox[{
  "General","stop",
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"",2,44,8,33008439701447293887,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7970388411979103`*^9, 3.8037768278121653`*^9},
 CellLabel->
  "\:8a08\:7b97\:4e2d\:ff1aIn[40]:=",ExpressionUUID->"97fb1567-f6e9-4d54-899a-\
14d98a2948dc"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nk4VG0bAPCJypqlhIg3ss3MGQZpJtF9J1lL2ihSstWnTSqRUkpK2bMT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       "]]},
     Annotation[#, "Charting`Private`Tag$6043#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{1., 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{1, 25}, {0., 1.7019998440934139`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.7970388414297132`*^9, 3.803776827854458*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"dc094722-d1ef-44e1-8183-8d43ad7c1b3f"],

Cell[BoxData[
 TemplateBox[{
  "General","munfl",
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"760.480878977333`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"",2,46,9,
   33008439701447293887,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7970388411979103`*^9, 3.803776827901333*^9},
 CellLabel->
  "\:8a08\:7b97\:4e2d\:ff1aIn[40]:=",ExpressionUUID->"bc35ec00-b23d-4170-a418-\
6d5b9435a346"],

Cell[BoxData[
 TemplateBox[{
  "General","munfl",
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"760.480878977333`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"",2,46,10,
   33008439701447293887,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7970388411979103`*^9, 3.8037768279075108`*^9},
 CellLabel->
  "\:8a08\:7b97\:4e2d\:ff1aIn[40]:=",ExpressionUUID->"d8b75965-ed9c-4274-ba93-\
fdb79a18b003"],

Cell[BoxData[
 TemplateBox[{
  "General","munfl",
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"760.4999808979594`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"",2,46,11,
   33008439701447293887,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7970388411979103`*^9, 3.803776827951049*^9},
 CellLabel->
  "\:8a08\:7b97\:4e2d\:ff1aIn[40]:=",ExpressionUUID->"69fd2060-e747-4321-9744-\
b36ec891ba79"],

Cell[BoxData[
 TemplateBox[{
  "General","stop",
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"",2,46,12,33008439701447293887,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7970388411979103`*^9, 3.803776828003972*^9},
 CellLabel->
  "\:8a08\:7b97\:4e2d\:ff1aIn[40]:=",ExpressionUUID->"995511db-9a8c-42a9-aa34-\
bef295f4e14b"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nk4VF8YB/DB3GxlaSOKss3MnUG2ZvST84YsWVOppE2hsiQhlUi2UrKV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       "]]},
     Annotation[#, "Charting`Private`Tag$6106#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{1., 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{1, 25}, {0., 2.706909710935266}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.7970388414297132`*^9, 3.803776828010797*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"6b9a85cf-ff55-45e4-936e-12e6f904c829"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwd13k4VV0XAPCLRMYIidKgTPeea0r3VrIWiuSNekuhSFI0okESZc6QMZkj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        "]]},
      Annotation[#, "Charting`Private`Tag$5976#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV1nk4VG0bAPCJypqlhIg3ss3MGQZpJtF9J1lL2ihSstWnTSqRUkpK2bMT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        "]]},
      Annotation[#, "Charting`Private`Tag$6043#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV1nk4VF8YB/DB3GxlaSOKss3MnUG2ZvST84YsWVOppE2hsiQhlUi2UrKV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        "]]},
      Annotation[#, "Charting`Private`Tag$6106#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 24.99999951020408}, {0, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.7970388414297132`*^9, 3.803776828015718*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"51a3f5a2-451d-4457-b441-8ac8f16212e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"g1", ",", "g2", ",", "g3", ",", "g4", ",", "g5", ",", "ztv"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topt", "=", "30"}], ";", 
  RowBox[{"tva", "=", "0.3"}], ";", 
  RowBox[{"tmax", "=", "40"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ti", "<", "topt"}], ",", 
       RowBox[{"ff1", "/", "4"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ti", "<", "tmax"}], ",", 
         RowBox[{"ff2", "/", "4"}], ",", "0"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ti", ",", "1", ",", "45"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.28"}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topt", "=", "15"}], ";", 
  RowBox[{"tva", "=", "0.10"}], ";", 
  RowBox[{"tmax", "=", "45"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ti", "<", "topt"}], ",", 
       RowBox[{"ff1", "/", "4"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ti", "<", "tmax"}], ",", 
         RowBox[{"ff2", "/", "4"}], ",", "0"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ti", ",", "1", ",", "45"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", " ", 
      RowBox[{"{", "Orange", "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.25"}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topt", "=", "20"}], ";", 
  RowBox[{"tva", "=", "0.10"}], ";", 
  RowBox[{"tmax", "=", "45"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ti", "<", "topt"}], ",", 
       RowBox[{"ff1", "/", "4"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ti", "<", "tmax"}], ",", 
         RowBox[{"ff2", "/", "4"}], ",", "0"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ti", ",", "1", ",", "45"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", " ", 
      RowBox[{"{", "Orange", "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.25"}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topt", "=", "25"}], ";", 
  RowBox[{"tva", "=", "0.10"}], ";", 
  RowBox[{"tmax", "=", "45"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g4", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ti", "<", "topt"}], ",", 
       RowBox[{"ff1", "/", "4"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ti", "<", "tmax"}], ",", 
         RowBox[{"ff2", "/", "4"}], ",", "0"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ti", ",", "1", ",", "45"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", " ", 
      RowBox[{"{", "Orange", "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.25"}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g1", ",", "g2", ",", "g3", ",", "g4"}], 
  "]"}], "\[IndentingNewLine]", "\"\<Figure 1a\>\""}], "Input",
 CellChangeTimes->{{3.797038826957161*^9, 3.797038827667796*^9}, {
  3.8037767964185133`*^9, 3.8037768038096523`*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"791210f5-f426-4be2-bd10-505c06d44761"],

Cell[BoxData[
 GraphicsBox[{{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwV1nc0Fu4XAHArpMzsvfd8rfC+z3ONRBMZbdkyiuyyk5JIkrKyFSkjISEh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         "]], LineBox[CompressedData["
1:eJxN1As0VWkbAGBR5Eh+t6QpEiGXmSklKft9j03RnFySYoqJXFKUJPxFRKSU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         "]]},
       Annotation[#, 
        "Charting`Private`Tag$6170#1"]& ], {}}, {{}, {}}, {{}, {}}}, {}}, \
{{{{}, {}, 
      TagBox[
       {RGBColor[1, 0.5, 0], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwV0ms01XkXB/CDUaESEdLlKOfmnH9ySSL2jopEiYRuoxNClHInWc+UIlGq
saJymwbJpSb3dMYgQs/5ZRRRiopQQu5y8vyfF3vt9Vnru1/svbaW8KSDhzSD
wQik6/9ddofCCIMxDM3RmX9nptSAsXUg22rjMKw2mXfYLa0GfK06D8SfGAYt
s47xlXdr4N9thXUancOgqxarmJxfA+kWjrf1K0YgRmasI6GqBkw237JyDxyF
k1dX7wntrYETuvzU+r4JGBtXzDfXr4XXqjt3JjRLQK422S60oRb8BkWhTp7z
kHHolPGdxXXg+muyYrP7IsyebvGIN66Hhra1D5YxlfFH6nmqau8z+P4k5D73
tSoWPlU3tIxsgBf8POuH9hoYkLiiSfd8I1Q4d5bdWboS3w2VTihcaQLPTbMW
kUImzlsildMU9Rwa5MNnPDXXoKJCdmmvzX9B3zT41m/Ta3Fy8/E5k0VikBk0
m4xgaOOx041XOhTF8DJV1jFovjZe1xBdCFUWQ7D07/JeqtooPJeQVagmhoqG
R2F2etqo6aqSIb9GDJYuI87q3toY4J+wIsBIDHuDfFUKXmtjj0aSksJher5Q
GN9eykLjGOGYeY4Y2Bs+NRSKWGi1ufG2d64YXlV4zLvwlIWLWm9kXMsTg2Gd
V5R+Cwu7jTtE7x+IYeTtiVNx31jo9LbPzLNcDL7yEU5mLDYu/KwgWdsoBqHH
9ZUZ19iYuERJ1m1ADMpfVPaHJLOx/EFwjNNXMfzjn5Rkl85G5pvZgzu+iYF5
JllxJp+NHskqU/zvYui8libl2MBGTjZr8O20GFyq7vf8wuDgK1mn2MEFBHZp
1uZ7+XHwDFVuW88iEJ7y5WFLIAfzx7ZDHofAnxpLS8zPcHD67E2dKzwCs2pC
kUocB188nuvfRRHIVWGQqhwObmVaSpUYEpBdvHlY/RMHN61YbL7GkkAlo0i/
YT8Xray2efsfJtAX9cbIUMhFP+5R0VI3AkvnpE3TvLn4lxNhFB8h4CPZYxkU
ysU+VbAdcSegPjPkqJXExRaRzZj9cQKBo/ygsGYuOg92Y14IAX7vH6U8ax7O
nXBOf5FAwJOteE91Nw9VaxZGaVwlkO4ZniK1j4fMAeqiWyKBZZ/tI9uP8tBm
bZNy/3UC0n0Si9goHt4RcpQ+3STQ3u8s7ivhoUYXO+w/mQQuDir0ZLN08Kf7
lkiXIgLVVEjrdYEOctmfV3kW0/fw+1AfZaCDqXscPp4qIXD6W1mu8xYddJ8q
bzlXRuDwkIf//EM6KPbJsUusJLBh5O8fnjd0sFazN9KhlsDHsQBltgwfheiV
7vsvgZR10U1Z8nzcVfv42e4WAvZeSec5ynxktstXrH9JQPSmbIKrxUfrL+8m
vryi89WSDj7wsXbZ7pdW7QQcrl78Qy+Cj4sNXCZvvCcg13jz4F+/8XHqsUnK
3i4CVTK5qgaX+Lgg4oCMcjeBdSHPLxom81ESV8a58IGA/GEl342lfHybl1Hk
2EPvy79laDbKx3XSItG5AQJhHnmDT2b4uCqr7dHqLwTWpz3JMpcW4LbQft9y
2qnKXeqoJMCx2ECd3q/0P01rSyx0BZjwoYJoDxHQMzAqqTESoJkuq7uAdp+v
1cmt5gJ8lJVYbDRMYF+Xd/c2OwHGy8xlwQgB/fqCp9bHBdjlwLlnNEqgn1F1
tuG0AHNjbpEC2ukmzRttwgXYKmNSpj1GYHHB6L2dsQJseH6NyI0TGLhhnLAr
W4DqPA2V8gkCGeIdVqRAgPWVW3asniTgsuAAw75EgEHdHXCOdl1E5Ok9TwXY
IpE/tXWKzgur9+39KMB17/W6708TMPKPH344IMDi+pCUn7SfR7pcUvwuwNvN
PrzdMwQmbn570sigMNxA7Vk/7ctZ5c7cBRTKLH/YZvCDgFbR+ZFoRQo1oLwy
grYtWc7asorC+E0d82RnCXS/7RGlsiicv7bt+HbawQMPXGYFFNoHyGdF086Q
tbpcakphm3V3soT2hGnAKOVKoWmozNkWCYG4HebxcW4U+hi4x8n8JMB0luP0
H6OwsindT4/2ztNp++8GU2hYGPPgAu2uKJ8xqbMU7stco1RAOzh+Q8Kv0RQm
VQdtb6GdntP0z/IbFP5exNNVm6P/tyTpQOgtCmuLz3zYQLux5sj4q0wKJy38
fBxouzULrhjkUmiXMF7nS3v83SQ38SGFH0yWTJ2nfelrdfW3MgqfHyyTpNBm
zsQftK2icFVYf1sB7eL5rhP36in8Gp12oYq2jar21fmEQpuBVrkXtN+vGeJ5
tFJoe/bykU7agesraqo7KVwY9yS+j7a8efQhZg+FdxuPJYzQTttpPxn5lUIj
r9ijU7QNXTUT34xS2DvHXCSh3XqxbubFFIV+6s8mf9L+H4jPe1k=
         "]], 
        LineBox[CompressedData["
1:eJwV1Hk0llsXAHAUGbuGlMqQMkbPOyEkZ5veSH2RyFSmChHqo3wiY4NbUQqZ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         "]]},
       Annotation[#, 
        "Charting`Private`Tag$6217#1"]& ], {}}, {{}, {}}, {{}, {}}}, {}}, \
{{{{}, {}, 
      TagBox[
       {RGBColor[1, 0.5, 0], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwV0ns81HkXB3CmmkqrYhM9qZRLLhkzv+9qUZwTxVhtlFtJ9Ahr5bJlHkkp
j1ItomdJySWiy7o8o5vLNBSpUOarVGaKHkVFVKLM5tbz2z/O67ze/53zOWdp
QOSmII6KikosW3/3ac6zPqmoDEL/WsPp2Z+rwUooMnL6cRAsuMe26E1UQ5hT
59bjEYOQqnng3YVpEni0Tnx3QecgmMy7eqdyvgTy7d1zGMknaHHUdOu1koDN
6mynQNEwzFalJofjJBBhYZZ3r3cEWuuDDp+bfgPkWi4uqQ8noEC5Xt1ziRTC
39fGeAZz0XT9xRf6KbWwxT9rzsNAdcwsIN7ekbegqV2/fL6eJqrnUae/TtXB
UM2eEmO5FrrLuTs9O+uh1axUeNltAX6nmXpdZ3YDSLw7q3K/X4Snq1vLnnvd
gWDrcfu4AD2UyQ4LzU/ehSa12NHghcvwaFlRXkTlPWBWRWcnfNVHdQ1X8563
jRAtDjiuqDRE1/q2slJlE2xY2FAWEr4cI3wtw54PN4PZm8JKE6EJWp6/03t5
6D50f47SNJpihoW7RSWbHjyAgoB6L4/uFRgULfHIONsCQ/cSmyQSHopFu26m
u8vgVGaGW1YdD+N2K4fGPWWwOqiwfU8jD/3MfY4HbpZBIqfu9Q9PeShUaHzh
bZOBju24qvgTD2dodhwuD5aB7ZXdNoXGFugRhi7Be2VwLMe/JDnTAoM820qy
cmWQVpXjyLPmY0jknq1qL2WQr6t8/3Y1HxPSFRGW3TIoj994sgD5+NPUXw/7
vZZBq5DbM0/Ix6z9G64V98lAUxH57zEvPg6Yqiw0G5LBya/20kYRH6N3Xii8
z6GQbdMn2FHOR5mP5OqxZRRK8xwUutf4WHUm1ibKgIKUkxf/tJKPfVN1K7Ya
Ueho3kSdb/IxwycqyciUwuKt0jC+jI/DRQU5hQIKBfvSLk70s/P2SjVWIYWL
UstFp5cLcEjsWtyxlQKqMqs0zQRo3ZTUGbKNgnwdb0sKT4Bx4S/shv0ozKBG
J+MtBagIuJ7ECaAQ8lJb/VcHAR7TOgCzQigYc0fHrf0FuHlX8MuGKArFrrUd
zzMFOCW+dmX77xTsMySjnmcE6NRwsNg4mcIzeYVOa64Al88xWhuTQkEtQOzR
UCTAivf8Xo00CjtF+Q9KrwjQLUk6wMugsCIrQRonE2CbWdG1OXkUyl455izh
MhheU18VWk5hqsH8xT0zGazduT/71GUKPkGvz15SZ9A/IcK5/goFbu+hQoEW
g2rZ36ZpXKfg9/5WsYMBgxr8mWPp1RTm/mVT/Ys9g3eGn5+1qKfsP6utWuHI
YNfIwQXWt9m8YxXSQWcGrdryfbCB3X9iz629Gxn0i4plhHcp1HGu30vezuDQ
4AnGtpnCbnWLp+ID7HzbBtdJH1Jo3DDpLUpgUGu1/eJzj9j7nGhRWB1hsCP7
gSSxjUKzZlhn3XEGfZlmcHxCQV/nz562HAaN/mknKpVTeLxMf1gpYdDg+7X+
6v+jYBo4JJLWMjhw7lAQZR1/vm4kvp5BXYmFeVoXm5fx9tGZzQzibDOVGa8o
JJrnquoqGLzc4l3+oofCSivtuahksEoeqKP3jsK+HQ6c4VEGu5e/dLrB+lZq
5OfzkwxGfxS6ePRTcHl9Tz6LS9B6aFvLwQEK2/+IKWifRzCzz+WG9AOFCzVF
6Uk6BHum0iOOHyn097Ym2uoSvGDlaihjHQ0moYX6BE3M5M+eDlJIHlAwkQzB
mOFFhrIhCq3aXMNlKwl+CTud6DhMYb4Do/3EmuAGLbsqKev8rKQxmzUEX4mK
0899plDhuKqB60awa3S/nscIhbFdv1RUuxOs87495wZrzE2/FOZN0DThYOsS
JYX7w/0pj/wItqtNv/uKdVd+jmdeOMHYhBUHN3ylYPig0WnjLoKceqWykHWo
8rP11H8RPDotf42S9Zeff14cup+g9KqD06lRCjZ7985dFE/wPz8tntLDOr7o
PKf1EMGrthlpvDH2n8cm3lgmE3Q/oPWPGtauRqaK3lSCwuNTdFTHKWRs9Lqf
/QfBQ/s2vbFnveTSf8WqZwjeDu4cvsn6B0//mJZLBFVKnB+enaCwNz45NL6U
4InbnW6PWNeWVPqScoJ6jlH5nEkKzpy5a7IqCaZ77BP7sk41X03W3yC4Jeh5
xBHWjzeHGH6rJfi+T3uyjLWf+NbMoLsE3YTclBHWRc8GxrSbCQbY/Zmk/Y1C
37QFH5pbCDZ1qW1ZyZonWNcV95DgjE4D5SbWIt9dj/hPCOa4fwoMZ119NLeh
W07wa3vouUTWk1eaKjI72Hx+SxFns1774ssl5y6CjzM3pohZ/z5zWfZ4N0HB
jxVWday9tAan/PaWYJGPUEpZ6y+tDet+R9CfWbq5g/XgipQnXh8ItsXZffeW
dY2Vj13zJ4Jp7nnyj6yT1hpftP1CEJdCzQhrb7eROZf/Ini9ZIlkjLWBb0OM
wThB+Wygk6z7HXbEhbAO12lU/u3/A2nishw=
         "]], LineBox[CompressedData["
1:eJwV03k8ldsaB3DzEWVI6UihMmRIdVt7wM56ttjGUjl2MpRx0wkdRShScjaJ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         "]]},
       Annotation[#, 
        "Charting`Private`Tag$6264#1"]& ], {}}, {{}, {}}, {{}, {}}}, {}}, \
{{{{}, {}, 
      TagBox[
       {RGBColor[1, 0.5, 0], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwV0nk01VsbB3AZKhSiI67MUoar4pzz20n2o0TRValkjCRJyI2UsRSpLmnU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         "]], LineBox[CompressedData["
1:eJwV1Hs8VWkXB3C5DZLcOqVeSpKK3Cv7nMNadDpIN5LR6OYaMW4pUigUGul0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         "]]},
       Annotation[#, 
        "Charting`Private`Tag$6311#1"]& ], {}}, {{}, {}}, {{}, {}}}, {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->FrontEndValueCache[{{Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{Automatic, {{0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.05, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.1, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.15, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.25, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.01, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.02, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.03, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.04, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.06, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.07, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.08, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.09, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.11, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.12, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.13, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.14, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.16, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.17, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.18, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.19, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.21, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.22, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.23, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.24, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.26, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.27, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.28, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.29, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.3, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {10., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {20., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {30., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {40., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {-10., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-8., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-6., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-4., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-2., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {2., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {8., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {12., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {14., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {16., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {22., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {24., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {26., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {28., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {32., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {34., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {36., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {38., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {42., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {44., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {46., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {48., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {50., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 44.99999910204082}, {0, 0.28}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.7970388422437162`*^9, 3.80377682820687*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"d2a93daa-ec89-44c6-b156-e7949d9bab4f"],

Cell[BoxData["\<\"Figure 1a\"\>"], "Output",
 CellChangeTimes->{3.7970388422437162`*^9, 3.8037768282772713`*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"4fe2e9ee-5e45-4472-9bc7-ffb0304aa36b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"topt", "=", "30"}], ";", 
  RowBox[{"tva", "=", "0.3"}], ";", 
  RowBox[{"tmax", "=", "40"}], ";", 
  RowBox[{"tvaf", "=", "0.1"}], ";", 
  RowBox[{"toptf", "=", "15"}], ";", 
  RowBox[{"tmaxf", "=", "45"}], ";", 
  RowBox[{"ztv", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"wb", "[", 
       RowBox[{"topt", ",", "tmax", ",", "tva", ",", "ztv", ",", "zm"}], 
       "]"}], 
      RowBox[{"wf", "[", 
       RowBox[{"toptf", ",", "tmaxf", ",", "tvaf", ",", "ztv", ",", "zm"}], 
       "]"}]], ",", 
     RowBox[{"{", 
      RowBox[{"zm", ",", "20", ",", "45"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1.5"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topt", "=", "30"}], ";", 
  RowBox[{"tva", "=", "0.3"}], ";", 
  RowBox[{"tmax", "=", "40"}], ";", 
  RowBox[{"tvaf", "=", "0.1"}], ";", 
  RowBox[{"toptf", "=", "20"}], ";", 
  RowBox[{"tmaxf", "=", "45"}], ";", 
  RowBox[{"ztv", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"wb", "[", 
       RowBox[{"topt", ",", "tmax", ",", "tva", ",", "ztv", ",", "zm"}], 
       "]"}], 
      RowBox[{"wf", "[", 
       RowBox[{"toptf", ",", "tmaxf", ",", "tvaf", ",", "ztv", ",", "zm"}], 
       "]"}]], ",", 
     RowBox[{"{", 
      RowBox[{"zm", ",", "20", ",", "45"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topt", "=", "30"}], ";", 
  RowBox[{"tva", "=", "0.3"}], ";", 
  RowBox[{"tmax", "=", "40"}], ";", 
  RowBox[{"tvaf", "=", "0.1"}], ";", 
  RowBox[{"toptf", "=", "25"}], ";", 
  RowBox[{"tmaxf", "=", "45"}], ";", 
  RowBox[{"ztv", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"wb", "[", 
       RowBox[{"topt", ",", "tmax", ",", "tva", ",", "ztv", ",", "zm"}], 
       "]"}], 
      RowBox[{"wf", "[", 
       RowBox[{"toptf", ",", "tmaxf", ",", "tvaf", ",", "ztv", ",", "zm"}], 
       "]"}]], ",", 
     RowBox[{"{", 
      RowBox[{"zm", ",", "20", ",", "45"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g4", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"zm", ",", "1", ",", "45"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g1", ",", "g2", ",", "g3", ",", "g4"}], 
  "]"}], "\[IndentingNewLine]", "\"\<Figure 1b\>\""}], "Input",
 CellChangeTimes->{{3.7970388872064342`*^9, 3.797038943075533*^9}, {
  3.803776817112897*^9, 3.8037768209796467`*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"c4346684-020b-40d0-9f91-112b5ef306ab"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV1nlUjd0XB/BGJSqFlLGJDGnSPNy9r3JRXiUN8ispbxMaNKeRihDNqaTQ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        "]]},
      Annotation[#, "Charting`Private`Tag$6418#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV1nk8lOsXAPBBlpSIrktuES2UZN+bcwYNpcikRGSJUKifZClblq66su9d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        "]]},
      Annotation[#, "Charting`Private`Tag$6465#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV1nk4VG0bAPCxRUKlUiGhBROVfZ/7HssIWVKvLSEkJFTSZm/aZVciS5EK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        "]]},
      Annotation[#, "Charting`Private`Tag$6512#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQzerJ/ZGB4YM9Axh8sM/T1553/MU3OP+GqLd338W/
cH7u230VoWlsDjB+ZPxM/ospvHD+yevKG8QUhOD8T3vLV2vcEIXzL2iv8dgY
IAnn7wq/u2OusCycn2b5x6k2SQFhHlfVrzRpJTjfyLpsdtNPZTi/bH1S783t
qnC+n/SRtRm56nC+9rPF2zU9NOH8x1+KhdSYteH8hUmHwkIe6yDce7z15K5d
enB+/445bnqWBnD+8j2msjPUDeH8tY/c5sizGcH5ZhbiAg7fEfxOTqXZfx4b
I/zzZ8m5awdM4Pwe+effPDeYwvk2KQuP3+o3g/O3qUxbz55tDudvFvHqORth
AefPVSsT3GhmCedzZSR266pbwfmOqu0ybsLWcH4qi2pYzXsEn0e4qcX7ng0i
PJzDoy322sL5/9+neR6cbgfnPzhtqvO4xR7Ov5GyL1rQ0AHOb6w+OPvvCgRf
cTHDhh8SjnD+Mo675w+2IfhvWCWzrv9F8DVFJt74neME56vvyjiY8xTB55p3
d+vqaGc4/8mkvrqfJxH8evn5Byc7usD5gntf37DZiOB3zLj6e7OcK5x/kFt+
ZvlUBP9D/xIuLxY3OP+KVB+jqhOCv2Np+Y//9Qg+AG4t88Q=
        "]]},
      Annotation[#, "Charting`Private`Tag$6559#1"]& ]}, {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{20.00000051020408, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->FrontEndValueCache[{{Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{Automatic, {{0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.25, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.75, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {1., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {1.25, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {1.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.05, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.1, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.15, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.3, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.35, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.45, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.55, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.65, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.7, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.85, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.95, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.05, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.1, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.15, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.3, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.35, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.45, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}}, {Automatic, {{20., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {25., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {30., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {35., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {40., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {45., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {15., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {16., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {19., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {21., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {22., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {23., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {24., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {26., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {27., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {28., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {29., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {31., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {32., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {33., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {34., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {36., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {37., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {38., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {39., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {41., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {42., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {43., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {44., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {46., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {47., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {48., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {49., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {50., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{20.00000051020408, 44.99999948979592}, {0, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7970389160767*^9, 3.7970389442864122`*^9}, 
   3.803776828505108*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"59628465-f431-49e9-906a-1f700ec9cd21"],

Cell[BoxData["\<\"Figure 1b\"\>"], "Output",
 CellChangeTimes->{{3.7970389160767*^9, 3.7970389442864122`*^9}, 
   3.8037768285628767`*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"dc1c2758-8941-42fb-972c-8dd4c23a5713"]
}, Open  ]]
},
WindowSize->{1625, 1005},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>2. Inherited,
FrontEndVersion->"12.0 \:95dc\:65bc  Mac OS X x86 (64-bit) \
(2019\:5e744\:67088\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[422, 15, 880, 25, 229, "Input",ExpressionUUID->"3a0c5356-7fd2-426f-8c38-69a35cb23606"],
Cell[1305, 42, 197, 2, 67, "Output",ExpressionUUID->"c00c696f-7207-4562-9b08-fa979779e429"],
Cell[1505, 46, 1091, 33, 94, "Output",ExpressionUUID->"2b32fb06-829e-4fc8-b3b6-805504c08db0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2633, 84, 127, 1, 59, "Input",ExpressionUUID->"7acbe017-a583-4458-9684-5cd25121895d"],
Cell[2763, 87, 194, 2, 67, "Output",ExpressionUUID->"7ce5389c-f877-4229-9ca1-49b1274691a6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2994, 94, 1459, 38, 150, "Input",ExpressionUUID->"cfc807cb-dc84-455e-8f63-ff2b84b2918d"],
Cell[4456, 134, 908, 28, 91, "Output",ExpressionUUID->"59716f73-c5eb-42a2-9b45-75b783e2c808"]
}, Open  ]],
Cell[5379, 165, 104, 1, 59, "Input",ExpressionUUID->"fef9b995-e367-4c24-af3c-fa95843cc1e0"],
Cell[CellGroupData[{
Cell[5508, 170, 783, 22, 170, "Input",ExpressionUUID->"a1f93774-240b-49a8-91a4-2a1da2134c47"],
Cell[6294, 194, 211, 3, 67, "Output",ExpressionUUID->"08ecd7b5-7334-4b71-a6d7-86a1d0f948f0"],
Cell[6508, 199, 209, 2, 67, "Output",ExpressionUUID->"ffdf38e0-b6ae-470d-b2f9-75293f3c0635"]
}, Open  ]],
Cell[6732, 204, 104, 1, 59, "Input",ExpressionUUID->"6cb5f05d-5320-48bf-8028-6c191d4badcf"],
Cell[CellGroupData[{
Cell[6861, 209, 1696, 54, 500, "Input",ExpressionUUID->"e605e63b-9b4d-4bdf-ba40-a7f0c922aab9"],
Cell[8560, 265, 198, 2, 89, "Output",ExpressionUUID->"109148b7-b456-45ae-893d-7e9e296e8a17"],
Cell[8761, 269, 194, 2, 89, "Output",ExpressionUUID->"01eb489d-7755-4845-8b78-09ed072f7392"],
Cell[8958, 273, 201, 2, 89, "Output",ExpressionUUID->"7d519720-ad0e-427c-9b50-036a13e1963a"],
Cell[9162, 277, 1363, 43, 185, "Output",ExpressionUUID->"06ced8c1-c623-462f-86c5-3e319b03fb23"],
Cell[10528, 322, 2277, 73, 323, "Output",ExpressionUUID->"5905b218-909c-4875-85b5-8f740f01b72a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12842, 400, 2034, 54, 381, "Input",ExpressionUUID->"a327c775-3930-4824-b11a-940d695878a8"],
Cell[14879, 456, 57743, 970, 530, 23184, 403, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"f21e20b7-f4ed-4758-b591-2140f1211ae4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72659, 1431, 3996, 122, 836, "Input",ExpressionUUID->"bebd7ba0-ffb3-44b0-a71c-5de6804568bc"],
Cell[76658, 1555, 2866, 86, 300, "Output",ExpressionUUID->"bd777dd1-0690-4c2f-87b4-d11cb888a8e9"],
Cell[79527, 1643, 200, 2, 89, "Output",ExpressionUUID->"f3d77533-02e8-41dc-b08a-f8a5d09c5e5b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79764, 1650, 37993, 1023, 6451, "Input",ExpressionUUID->"e8a525b9-6498-4351-9310-7d74ceb83118"],
Cell[117760, 2675, 205, 2, 89, "Output",ExpressionUUID->"e66f5298-e9bf-42f9-8b9b-e95c63c97a49"],
Cell[117968, 2679, 208, 2, 89, "Output",ExpressionUUID->"08177e03-2225-4c74-ac8d-91aa3380d447"],
Cell[118179, 2683, 210, 2, 89, "Output",ExpressionUUID->"7a1ddc55-ef01-4d96-93e5-672593fdaa2a"],
Cell[118392, 2687, 209, 2, 89, "Output",ExpressionUUID->"bc5d0105-5aa2-4dc9-bbf4-cad289a74185"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118638, 2694, 1572, 42, 634, "Input",ExpressionUUID->"aa35193a-40ca-4cca-983d-2931a663b402"],
Cell[120213, 2738, 258, 5, 89, "Output",ExpressionUUID->"413552a9-85fe-41c9-b079-15cdbddd9aa6"],
Cell[120474, 2745, 258, 5, 89, "Output",ExpressionUUID->"d370bea5-74a4-4a7a-b48c-efee6fe465b0"],
Cell[120735, 2752, 210, 3, 89, "Output",ExpressionUUID->"97009625-3247-4c27-8a7e-e7760d9463d2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120982, 2760, 2501, 68, 625, "Input",ExpressionUUID->"f2433d8c-e061-4ac8-854e-a478f06bd68b"],
Cell[123486, 2830, 506, 11, 45, "Message",ExpressionUUID->"2ffc9690-6e78-40f8-80d6-3af1149d039d"],
Cell[123995, 2843, 504, 11, 45, "Message",ExpressionUUID->"39fbb93c-0c2c-448d-9efa-70164ccba186"],
Cell[124502, 2856, 505, 11, 45, "Message",ExpressionUUID->"c2dc3455-75ce-45f3-a581-edea225374e8"],
Cell[125010, 2869, 472, 10, 45, "Message",ExpressionUUID->"6d3391c9-0167-4249-a221-29374eb3a5bc"],
Cell[125485, 2881, 29174, 496, 530, 8129, 151, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"8a342f62-f374-403c-9f35-92610cfa9ade"],
Cell[154662, 3379, 506, 11, 45, "Message",ExpressionUUID->"94a54dfc-5534-4221-af16-cba2f1a82cd0"],
Cell[155171, 3392, 504, 11, 45, "Message",ExpressionUUID->"1dc6adcd-fb4f-4c30-a4a5-d801731139d0"],
Cell[155678, 3405, 507, 11, 45, "Message",ExpressionUUID->"827c0746-5b95-46ed-9853-2218dec67acb"],
Cell[156188, 3418, 474, 10, 45, "Message",ExpressionUUID->"97fb1567-f6e9-4d54-899a-14d98a2948dc"],
Cell[156665, 3430, 8129, 152, 499, "Output",ExpressionUUID->"dc094722-d1ef-44e1-8183-8d43ad7c1b3f"],
Cell[164797, 3584, 504, 11, 45, "Message",ExpressionUUID->"bc35ec00-b23d-4170-a418-6d5b9435a346"],
Cell[165304, 3597, 507, 11, 45, "Message",ExpressionUUID->"d8b75965-ed9c-4274-ba93-fdb79a18b003"],
Cell[165814, 3610, 506, 11, 45, "Message",ExpressionUUID->"69fd2060-e747-4321-9744-b36ec891ba79"],
Cell[166323, 3623, 473, 10, 45, "Message",ExpressionUUID->"995511db-9a8c-42a9-aa34-bef295f4e14b"],
Cell[166799, 3635, 8278, 155, 498, "Output",ExpressionUUID->"6b9a85cf-ff55-45e4-936e-12e6f904c829"],
Cell[175080, 3792, 21418, 372, 530, "Output",ExpressionUUID->"51a3f5a2-451d-4457-b441-8ac8f16212e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[196535, 4169, 4164, 117, 934, "Input",ExpressionUUID->"791210f5-f426-4be2-bd10-505c06d44761"],
Cell[200702, 4288, 41346, 759, 761, "Output",ExpressionUUID->"d2a93daa-ec89-44c6-b156-e7949d9bab4f"],
Cell[242051, 5049, 191, 2, 89, "Output",ExpressionUUID->"4fe2e9ee-5e45-4472-9bc7-ffb0304aa36b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[242279, 5056, 3229, 89, 755, "Input",ExpressionUUID->"c4346684-020b-40d0-9f91-112b5ef306ab"],
Cell[245511, 5147, 27743, 530, 772, "Output",ExpressionUUID->"59628465-f431-49e9-906a-1f700ec9cd21"],
Cell[273257, 5679, 217, 3, 124, "Output",ExpressionUUID->"dc1c2758-8941-42fb-972c-8dd4c23a5713"]
}, Open  ]]
}
]
*)

