setwd("C:/Users/stephen burgess/Dropbox/People/Gabriele Morani/April") # 
setwd("C:/Dropbox/People/Gabriele Morani/April") # Users/stephen burgess/

library(MendelianRandomization)

lipid_phenoscan = read.csv("lipid_mrcat_all_MR_Catalogue.csv", header=TRUE, stringsAsFactors=FALSE)

lipidsnp  =    lipid_phenoscan[which(lipid_phenoscan$Trait=="HDL"&
                                    lipid_phenoscan$PMID=="24097068"),"rsID"]
#lipidsnp = lipidsnp[-32]

hdlbeta   =     lipid_phenoscan[which(lipid_phenoscan$Trait=="HDL"&
                                    lipid_phenoscan$PMID=="24097068"),"Beta"]
hdlse     =     lipid_phenoscan[which(lipid_phenoscan$Trait=="HDL"&
                                    lipid_phenoscan$PMID=="24097068"),"SE"]
hdleffect =     lipid_phenoscan[which(lipid_phenoscan$Trait=="HDL"&
                                    lipid_phenoscan$PMID=="24097068"),"Effect.Allele"]
hdlp      =     lipid_phenoscan[which(lipid_phenoscan$Trait=="HDL"&
                                    lipid_phenoscan$PMID=="24097068"),"P"]

ldlbeta   =     lipid_phenoscan[which(lipid_phenoscan$Trait=="LDL"&
                                    lipid_phenoscan$PMID=="24097068"),"Beta"]
ldlse     =     lipid_phenoscan[which(lipid_phenoscan$Trait=="LDL"&
                                    lipid_phenoscan$PMID=="24097068"),"SE"]
ldleffect =     lipid_phenoscan[which(lipid_phenoscan$Trait=="LDL"&
                                    lipid_phenoscan$PMID=="24097068"),"Effect.Allele"]
ldlp      =     lipid_phenoscan[which(lipid_phenoscan$Trait=="LDL"&
                                    lipid_phenoscan$PMID=="24097068"),"P"]

tgbeta   =     lipid_phenoscan[which(lipid_phenoscan$Trait=="Triglycerides"&
                                    lipid_phenoscan$Source=="GLGC"&
                                    lipid_phenoscan$PMID=="24097068"),"Beta"]
tgse     =     lipid_phenoscan[which(lipid_phenoscan$Trait=="Triglycerides"&
                                    lipid_phenoscan$Source=="GLGC"&
                                    lipid_phenoscan$PMID=="24097068"),"SE"]
tgeffect =     lipid_phenoscan[which(lipid_phenoscan$Trait=="Triglycerides"&
                                    lipid_phenoscan$Source=="GLGC"&
                                    lipid_phenoscan$PMID=="24097068"),"Effect.Allele"]
tgp      =     lipid_phenoscan[which(lipid_phenoscan$Trait=="Triglycerides"&
                                    lipid_phenoscan$Source=="GLGC"&
                                    lipid_phenoscan$PMID=="24097068"),"P"]

tcbeta = lipid_phenoscan[which(lipid_phenoscan$Trait=="Total cholesterol"&
                                    lipid_phenoscan$Source=="GLGC"&
                                    lipid_phenoscan$PMID=="24097068"),"Beta"]
tcse     =     lipid_phenoscan[which(lipid_phenoscan$Trait=="Total cholesterol"&
                                    lipid_phenoscan$Source=="GLGC"&
                                    lipid_phenoscan$PMID=="24097068"),"SE"]
tceffect =     lipid_phenoscan[which(lipid_phenoscan$Trait=="Total cholesterol"&
                                    lipid_phenoscan$Source=="GLGC"&
                                    lipid_phenoscan$PMID=="24097068"),"Effect.Allele"]
tcp      =     lipid_phenoscan[which(lipid_phenoscan$Trait=="Total cholesterol"&
                                    lipid_phenoscan$Source=="GLGC"&
                                    lipid_phenoscan$PMID=="24097068"),"P"]


####

diseases = c("ca_all", "ca_breast", "ca_prost", "ca_lung", "ca_bowel", "ca_mel", "ca_nhl", 
 "ca_kid", "ca_headneck", "ca_brain", "ca_blad", "ca_panc", "ca_uter",
 "ca_leuk", "ca_oeso", "ca_ov", "ca_gastric", "ca_hep", "ca_myeloma", "ca_thyroid", "ca_bil", "ca_cerv", "ca_test")
headMV = c("HDL_beta", "HDL_CI_lower", "HDL_CI_upper", "LDL_beta", "LDL_CI_lower", "LDL_CI_upper", "TGD_beta", "TGD_CI_lower", "TGD_CI_upper")
hdlbetaMV = NULL; hdllowerMV = NULL; hdlupperMV = NULL
ldlbetaMV = NULL; ldllowerMV = NULL; ldlupperMV = NULL
tgbetaMV = NULL; tglowerMV = NULL; tgupperMV = NULL
# diseases = c("ca_all_nSR", "any_cancer", "ca_GI")

headUV = c("IVW_beta", "IVW_CI_lower", "IVW_CI_upper", "WME_beta", "WME_CI_lower", "WME_CI_upper", "ER_beta", "ER_CI_lower", "ER_CI_upper")
ldlbetaIVW = NULL; ldllowerIVW = NULL; ldlupperIVW = NULL
ldlbetaMED = NULL; ldllowerMED = NULL; ldlupperMED = NULL
ldlbetaEGG = NULL; ldllowerEGG = NULL; ldlupperEGG = NULL
hdlbetaIVW = NULL; hdllowerIVW = NULL; hdlupperIVW = NULL
hdlbetaMED = NULL; hdllowerMED = NULL; hdlupperMED = NULL
hdlbetaEGG = NULL; hdllowerEGG = NULL; hdlupperEGG = NULL
tgbetaIVW = NULL;  tglowerIVW = NULL;  tgupperIVW = NULL
tgbetaMED = NULL;  tglowerMED = NULL;  tgupperMED = NULL
tgbetaEGG = NULL;  tglowerEGG = NULL;  tgupperEGG = NULL
tcbetaIVW = NULL;  tclowerIVW = NULL;  tcupperIVW = NULL
events = NULL
qstat_MV = NULL; isqstat_MV = NULL
qstat_UV = NULL; isqstat_UV = NULL

for (k in 1:length(diseases)) {
outcome = read.table(paste("output_cancer/lipid_snps_CANCER_outcomes_", diseases[k], "_nSR.out", sep=""), header=TRUE, stringsAsFactors=FALSE)

events[k] = outcome$cases_total[1]

outbeta=NULL; outse=NULL; outeffect=NULL

for (j in 1:length(lipidsnp)) {
outbeta[j]   = c(outcome[which(outcome$rsid==lipidsnp[j]), "frequentist_add_beta_1"],NA)[1]
outse[j]     = c(outcome[which(outcome$rsid==lipidsnp[j]), "frequentist_add_se_1"],NA)[1]
outeffect[j] = c(outcome[which(outcome$rsid==lipidsnp[j]), "alleleB"],NA)[1]
 }
outbeta_signed = ifelse(hdleffect==outeffect, outbeta, -outbeta)

MV = mr_mvivw(mr_mvinput(cbind(ldlbeta, hdlbeta, tgbeta), cbind(ldlse, hdlse, tgse), outbeta_signed, outse))
ldlbetaMV[k] = MV$Estimate[1]; ldllowerMV[k] = MV$CILower[1]; ldlupperMV[k] = MV$CIUpper[1]; 
hdlbetaMV[k] = MV$Estimate[2]; hdllowerMV[k] = MV$CILower[2]; hdlupperMV[k] = MV$CIUpper[2]; 
tgbetaMV[k] = MV$Estimate[3];  tglowerMV[k] = MV$CILower[3];  tgupperMV[k] = MV$CIUpper[3]; 

qstat_MV[k] = MV$Heter.Stat[1]; isqstat_MV[k] = max(0, (MV$Heter.Stat[1]-length(outbeta))/MV$Heter.Stat[1])*100

TC = mr_ivw(mr_input(tcbeta, tcse, outbeta_signed, outse))
tcbetaIVW[k] = TC$Estimate; tclowerIVW[k] = TC$CILower; tcupperIVW[k] = TC$CIUpper; 

qstat_UV[k] = TC$Heter.Stat[1]; isqstat_UV[k] = max(0, (TC$Heter.Stat[1]-length(outbeta))/TC$Heter.Stat[1])*100


  betaXG = hdlbeta[which(hdlp<5e-8)]
sebetaXG = hdlse[which(hdlp<5e-8)]
  betaYG = outbeta_signed[which(hdlp<5e-8)]
sebetaYG = outse[which(hdlp<5e-8)]

ALL = mr_allmethods(mr_input(betaXG, sebetaXG, betaYG, sebetaYG), method="main")

hdlbetaIVW[k] = ALL$Values[3,2]; hdllowerIVW[k] = ALL$Values[3,4]; hdlupperIVW[k] = ALL$Values[3,5]; 
hdlbetaMED[k] = ALL$Values[2,2]; hdllowerMED[k] = ALL$Values[2,4]; hdlupperMED[k] = ALL$Values[2,5]; 
hdlbetaEGG[k] = ALL$Values[4,2]; hdllowerEGG[k] = ALL$Values[4,4]; hdlupperEGG[k] = ALL$Values[4,5]; 

  betaXG = ldlbeta[which(ldlp<5e-8)]
sebetaXG = ldlse[which(ldlp<5e-8)]
  betaYG = outbeta_signed[which(ldlp<5e-8)]
sebetaYG = outse[which(ldlp<5e-8)]

ALL = mr_allmethods(mr_input(betaXG, sebetaXG, betaYG, sebetaYG), method="main")

ldlbetaIVW[k] = ALL$Values[3,2]; ldllowerIVW[k] = ALL$Values[3,4]; ldlupperIVW[k] = ALL$Values[3,5]; 
ldlbetaMED[k] = ALL$Values[2,2]; ldllowerMED[k] = ALL$Values[2,4]; ldlupperMED[k] = ALL$Values[2,5]; 
ldlbetaEGG[k] = ALL$Values[4,2]; ldllowerEGG[k] = ALL$Values[4,4]; ldlupperEGG[k] = ALL$Values[4,5]; 


  betaXG = tgbeta[which(tgp<5e-8)]
sebetaXG = tgse[which(tgp<5e-8)]
  betaYG = outbeta_signed[which(tgp<5e-8)]
sebetaYG = outse[which(tgp<5e-8)]

ALL = mr_allmethods(mr_input(betaXG, sebetaXG, betaYG, sebetaYG), method="main")

tgbetaIVW[k] = ALL$Values[3,2]; tglowerIVW[k] = ALL$Values[3,4]; tgupperIVW[k] = ALL$Values[3,5]; 
tgbetaMED[k] = ALL$Values[2,2]; tglowerMED[k] = ALL$Values[2,4]; tgupperMED[k] = ALL$Values[2,5]; 
tgbetaEGG[k] = ALL$Values[4,2]; tglowerEGG[k] = ALL$Values[4,4]; tgupperEGG[k] = ALL$Values[4,5]; 

}

# cbind(diseases, decimals(qstat_MV,1), decimals(isqstat_MV,1), decimals(qstat_UV,1), decimals(isqstat_UV,1))

for (k in 1:length(diseases)) {
cat(out[k], decimals(qstat_MV[k],1), decimals(isqstat_MV[k],1), decimals(qstat_UV[k],1), decimals(isqstat_UV[k],1), "\n")
}

MVframe = data.frame(hdlbetaMV, hdllowerMV, hdlupperMV, ldlbetaMV, ldllowerMV, ldlupperMV, tgbetaMV, tglowerMV, tgupperMV)
colnames(MVframe) <- headMV


write.csv(MVframe, "forest_cancer/ForestPlotMV_NEW_nSR.csv", quote=FALSE, row.names=diseases) 

LDLframe = data.frame(ldlbetaIVW, ldllowerIVW, ldlupperIVW, 
                      ldlbetaMED, ldllowerMED, ldlupperMED, 
                      ldlbetaEGG, ldllowerEGG, ldlupperEGG)
colnames(LDLframe) <- headUV
#write.csv(LDLframe, "forest_cancer/ForestPlotLDL.csv", quote=FALSE, row.names=diseases) 

HDLframe = data.frame(hdlbetaIVW, hdllowerIVW, hdlupperIVW, 
                      hdlbetaMED, hdllowerMED, hdlupperMED, 
                      hdlbetaEGG, hdllowerEGG, hdlupperEGG)
colnames(HDLframe) <- headUV
#write.csv(HDLframe, "forest_cancer/ForestPlotHDL.csv", quote=FALSE, row.names=diseases) 


TGDframe = data.frame(tgbetaIVW, tglowerIVW, tgupperIVW, 
                      tgbetaMED, tglowerMED, tgupperMED, 
                      tgbetaEGG, tglowerEGG, tgupperEGG)
colnames(TGDframe) <- headUV
#write.csv(TGDframe, "forest_cancer/ForestPlotTGD.csv", quote=FALSE, row.names=diseases) 

TCframe = data.frame(tcbetaIVW, tclowerIVW, tcupperIVW)
colnames(TCframe) <- headUV[1:3]
write.csv(TCframe, "forest_cancer/ForestPlotTC_NEW_nSR.csv", quote=FALSE, row.names=diseases) 

#####################

outcome = read.table(paste("output_cancer/lipid_snps_CANCER_outcomes_any_cancer.out", sep=""), header=TRUE, stringsAsFactors=FALSE)

outcome$cases_total[1] # events

outbeta=NULL; outse=NULL; outeffect=NULL

for (j in 1:length(lipidsnp)) {
outbeta[j]   = c(outcome[which(outcome$rsid==lipidsnp[j]), "frequentist_add_beta_1"],NA)[1]
outse[j]     = c(outcome[which(outcome$rsid==lipidsnp[j]), "frequentist_add_se_1"],NA)[1]
outeffect[j] = c(outcome[which(outcome$rsid==lipidsnp[j]), "alleleB"],NA)[1]
 }
outbeta_signed = ifelse(hdleffect==outeffect, outbeta, -outbeta)

MV = mr_mvivw(mr_mvinput(cbind(ldlbeta, hdlbeta, tgbeta), cbind(ldlse, hdlse, tgse), outbeta_signed, outse))
exp(MV$Estimate); exp(MV$CILower); exp(MV$CIUpper); MV$Pvalue
TC = mr_ivw(mr_input(tcbeta, tcse, outbeta_signed, outse))
exp(TC$Estimate); exp(TC$CILower); exp(TC$CIUpper); TC$Pvalue


