setwd("C:/Users/stephenb/Dropbox (Cambridge University)/People/Gabriele Morani/April") # Users/stephen burgess/

library(MendelianRandomization)
#detach("package:TwoSampleMR")

####

#diseases = "ca_all_nSR"
diseases = c("ca_all", "ca_breast", "ca_prost", "ca_lung", "ca_bowel", "ca_mel", "ca_nhl",
 "ca_kid", "ca_headneck", "ca_brain", "ca_blad", "ca_panc", "ca_uter",
 "ca_leuk", "ca_oeso", "ca_ov", "ca_gastric", "ca_hep", "ca_myeloma", "ca_thyroid", "ca_bil", "ca_cerv", "ca_test")
npc1l1beta = NULL; npc1l1lower = NULL; npc1l1upper = NULL

npc1l1_snp   = c("rs10234070", "rs2073547", "rs217386", "rs7791240", "rs2300414")
npc1l1_betaX = c(0.9145, 1.5035, -1.1253, -1.3175, 1.0943)/38.67
npc1l1_seX   = c(0.183,  0.152,  0.118,  0.202,  0.248)/38.67
npc1l1_effect= c("T", "G", "A", "C", "A")
npc1l1_other = c("C", "A", "G", "T", "G")

npc1l1_matrix = matrix(c(1, 0.453248, -0.191911, 0.140017, 0.141758,
                         0.453248, 1, -0.379032, 0.537045, 0.301995,
                        -0.191911, -0.379032, 1, -0.245374, -0.212304,
                         0.140017, 0.537045, -0.245374, 1, 0.591343,
                         0.141758, 0.301995, -0.212304, 0.591343, 1), nrow=5, ncol=5)


for (k in 1:length(diseases)) {
outcome = read.table(paste("output_cancer/npc1l1_", diseases[k], ".out", sep=""), header=TRUE, stringsAsFactors=FALSE)

outbeta=NULL; outse=NULL; outeffect=NULL

for (j in 1:length(npc1l1_snp)) {
 outbeta[j]   = c(outcome[which(outcome$rsid==npc1l1_snp[j]), "frequentist_add_beta_1"],NA)[1]
 outse[j]     = c(outcome[which(outcome$rsid==npc1l1_snp[j]), "frequentist_add_se_1"],NA)[1]
 outeffect[j] = c(outcome[which(outcome$rsid==npc1l1_snp[j]), "alleleB"],NA)[1]
 }
outbeta_signed = ifelse(npc1l1_effect==outeffect, outbeta, -outbeta)

IVW = mr_ivw(mr_input(npc1l1_betaX, npc1l1_seX, outbeta_signed, outse, cor=npc1l1_matrix), model="fixed")
npc1l1beta[k] = IVW$Estimate; npc1l1lower[k] = IVW$CILower; npc1l1upper[k] = IVW$CIUpper

# mr_plot(mr_input(npc1l1_betaX, npc1l1_seX, outbeta_signed, outse, exposure="LDL-cholesterol", outcome="overall cancer", cor=npc1l1_matrix), interactive=FALSE, orientate=TRUE)


}

###

npc1l1_frame = data.frame(npc1l1beta, npc1l1lower, npc1l1upper)
colnames(npc1l1_frame) <- c("IVW_beta", "IVW_CI_lower", "IVW_CI_upper")

write.csv(npc1l1_frame, "forest_cancer/ForestPlotNPC1L1_NEW.csv", quote=FALSE, row.names=diseases) 



###########

for (j in 1:length(diseases)) {
 cat(decimals(exp(npc1l1_frame$IVW_beta[j]), 2), " (", decimals(exp(npc1l1_frame$IVW_CI_lower[j]), 2), "-", decimals(exp(npc1l1_frame$IVW_CI_upper[j]), 2), ")\t", sep="")
 cat("\n") }

npc1l1_p = pnorm(-abs(2*qnorm(0.975)*npc1l1_frame$IVW_beta/(npc1l1_frame$IVW_CI_upper-npc1l1_frame$IVW_CI_lower)))*2
