library(forestplot)
library(MendelianRandomization)

setwd("C:/Users/stephen burgess/Dropbox/People/Gabriele Morani/April") # Users/stephen burgess/

################## ESEMPIO PAR DI GRAFICI ################

MV_orig<-read.table("forest_cancer/ForestPlotMV_NEW_nSR.csv",header=T,sep=",")
#out<-row.names(MV)
#<-dim(MV)[1]

xticks <- c(log(0.5), log(0.6), log(0.8), log(1), log(1.2), log(1.4), log(1.6), log(2.0), log(2.5))
attr(xticks, "labels") <- c("0.5", "0.6", "0.8", "1.0", "1.2", "1.4", "1.6", "2.0", "2.5")

xticks2<- seq(from = -0.4,to = 1, by = 0.2)

MV<-MV_orig[1:23,]
nout<-dim(MV)[1]
#out<-row.names(MV)

MVHDL <- structure(list(
    mean  = c(NA,MV$HDL_beta),
    lower = c(NA,MV$HDL_CI_lower),
    upper = c(NA,MV$HDL_CI_upper), pval = c(NA, decimals(pnorm(-abs(2*qnorm(0.975)*MV$HDL_beta/(MV$HDL_CI_upper-MV$HDL_CI_lower)))*2,3))),
    .Names = c("mean", "lower", "upper", "pval"), 
    row.names = as.character(rep(NA,nout+1)),
    class = "data.frame")

MVLDL <- structure(list(
    mean  = c(NA,MV$LDL_beta),
    lower = c(NA,MV$LDL_CI_lower),
    upper = c(NA,MV$LDL_CI_upper), pval = c(NA, decimals(pnorm(-abs(2*qnorm(0.975)*MV$LDL_beta/(MV$LDL_CI_upper-MV$LDL_CI_lower)))*2,3))),
    .Names = c("mean", "lower", "upper", "pval"), 
    row.names = as.character(rep(NA,nout+1)),
    class = "data.frame")

MVTGD <- structure(list(
    mean  = c(NA,MV$TGD_beta),
    lower = c(NA,MV$TGD_CI_lower),
    upper = c(NA,MV$TGD_CI_upper), pval = c(NA, decimals(pnorm(-abs(2*qnorm(0.975)*MV$TGD_beta/(MV$TGD_CI_upper-MV$TGD_CI_lower)))*2,3))),
    .Names = c("mean", "lower", "upper", "pval"), 
    row.names = as.character(rep(NA,nout+1)),
    class = "data.frame")

out<-c("Overall", "Breast","Prostate", "Lung","Bowel","Melanoma","Non-Hodgkin's Lymphoma",
"Kidney", "Head/neck", "Brain", "Bladder","Pancreas","Uterus","Leukaemia", "Oesophagus",
 "Ovaries","Gastric","Liver","Myeloma", "Thyroid", "Biliary", "Cervix", "Testes")   



headMV = c("HDL_beta", "HDL_CI_lower", "HDL_CI_upper", "LDL_beta", "LDL_CI_lower", "LDL_CI_upper", "TGD_beta", "TGD_CI_lower", "TGD_CI_upper")

tabletext<-c("Disease",out)
tabletext2<-rep(NA,nout+1)


# Print two plots side by side using the grid
# package's layout option for viewports

pdf("forest_cancer/ForestPlotMV_NEW_nSR.pdf",  width=24)

A<-grid.newpage()
pushViewport(viewport(layout = grid.layout(1,3)))
pushViewport(viewport(layout.pos.col = 1))
  pvalue = c(NA, paste("p", ifelse(MVHDL$pval[2:(nout+1)]<0.001, "<0.001", paste("=", MVHDL$pval[2:(nout+1)], sep="")), sep=""))
  eventsTAB = c("Events", events)
  tabletextHDL = cbind(tabletext, eventsTAB, pvalue)
forestplot(tabletextHDL, 
	exp(MVHDL$mean),
	exp(MVHDL$lower),
	exp(MVHDL$upper),
	graph.pos = 3,
	fn.ci_norm = fpDrawNormalCI,
	boxsize = .15,
	lwd.ci=1,
	clip =c(0.4,2.5),
	graphwidth= unit(7,"cm"),
	hrzl_lines = list("2" = gpar(col="#444444",columns=1)),
	is.summary=c(TRUE,rep(FALSE,nout)),
	col=fpColors(box="royalblue",line="darkblue"),
	xlog=TRUE,
	zero=1,
	lwd.zero=1,
	vertices = TRUE, 
      xticks=exp(xticks),
	title="                                              HDL-Cholesterol",
	lineheight = "auto",
	grid=T,
	new_page = FALSE)
popViewport()
  pvalue = c(NA, paste("p", ifelse(MVLDL$pval[2:(nout+1)]<0.001, "<0.001", paste("=", MVLDL$pval[2:(nout+1)], sep="")), sep=""))
  tabletextLDL = cbind(tabletext2, pvalue)
pushViewport(viewport(layout.pos.col = 2))
forestplot(tabletextLDL,
	exp(MVLDL$mean),
	exp(MVLDL$lower),
	exp(MVLDL$upper),
	graph.pos = 2,
	graphwidth= unit(7,"cm"),
	fn.ci_norm = fpDrawNormalCI,
	boxsize = .15,
	lwd.ci=1,
	clip =c(0.4,2.5),
	hrzl_lines = list("2" = gpar(col="#444444",columns=1)),
	is.summary=c(TRUE,rep(FALSE,nout)),
	col=fpColors(box="firebrick",line="darkred"),
	xlog=TRUE,
	zero=1,
	lwd.zero=1,
	vertices = TRUE, 
      xticks=exp(xticks),
	title="      LDL-Cholesterol",
	lineheight = "auto",
	grid=T,
	new_page = FALSE)
popViewport()
  pvalue = c(NA, paste("p", ifelse(MVTGD$pval[2:(nout+1)]<0.001, "<0.001", paste("=", MVTGD$pval[2:(nout+1)], sep="")), sep=""))
  tabletextTGD = cbind(tabletext2, pvalue)
pushViewport(viewport(layout.pos.col = 3))
forestplot(tabletextTGD,
	exp(MVTGD$mean),
	exp(MVTGD$lower),
	exp(MVTGD$upper),
	graph.pos = 2,
	clip =c(0.4,2.5),
	graphwidth= unit(7,"cm"),
	fn.ci_norm = fpDrawNormalCI,
	boxsize = .15,
	lwd.ci=1,
	hrzl_lines = list("2" = gpar(col="#444444",columns=1)),
	is.summary=c(TRUE,rep(FALSE,nout)),
	col=fpColors(box="purple",line="purple3"),
	xlog=TRUE,
	zero=1,
	lwd.zero=1,
	vertices = TRUE, 
      xticks=exp(xticks),
	title="      Triglycerides",
	lineheight = "auto",
	grid=T,
	new_page = FALSE)
popViewport()

print(A)
dev.off()

####################

for (j in 1:nout) {
 cat(out[j], rep(" ", 40-nchar(out[j])), sep="")
 cat(decimals(exp(MV$HDL_beta[j]), 2), " (", decimals(exp(MV$HDL_CI_lower[j]), 2), "-", decimals(exp(MV$HDL_CI_upper[j]), 2), ")\t", sep="")
 cat(decimals(exp(MV$LDL_beta[j]), 2), " (", decimals(exp(MV$LDL_CI_lower[j]), 2), "-", decimals(exp(MV$LDL_CI_upper[j]), 2), ")\t", sep="")
 cat(decimals(exp(MV$TGD_beta[j]), 2), " (", decimals(exp(MV$TGD_CI_lower[j]), 2), "-", decimals(exp(MV$TGD_CI_upper[j]), 2), ")\t", sep="")
 cat("\n") }

for (j in 2:(nout+1)) {
 cat(out[j-1]); cat(rep(" ", 40-nchar(out[j-1])), sep=""); cat(MVHDL$pval[j], MVLDL$pval[j], MVTGD$pval[j], "\n") }
