pow=0.8; sig=0.05 # 80% power, 5% significance

n_total = 367703                          # total sample size (unrelated Europeans)
n_cases = seq(from=300, to=16000, by=100) # number of cases
ratio = n_cases/n_total

##########
# Smoking

rsq = c(0.150,0.146,0.137,0.117,0.012,0.01,0.009,0.004)  # r^2 for lipids
effect1 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[1]*(ratio/(1+ratio))*(1/(1+ratio))))
effect2 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[2]*(ratio/(1+ratio))*(1/(1+ratio))))
effect3 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[3]*(ratio/(1+ratio))*(1/(1+ratio))))
effect4 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[4]*(ratio/(1+ratio))*(1/(1+ratio))))
effect5 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[5]*(ratio/(1+ratio))*(1/(1+ratio))))
effect6 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[6]*(ratio/(1+ratio))*(1/(1+ratio))))
effect7 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[7]*(ratio/(1+ratio))*(1/(1+ratio))))
effect8 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[8]*(ratio/(1+ratio))*(1/(1+ratio))))

par(oma=c(0,0,0,9), xpd=FALSE)
plot(log(n_cases), log(effect1), xlim=c(5.7,10), ylim=c(log(1.02),log(1.6)), xlab="Number of events", ylab="Effect size for 80% power", xaxs="i", yaxs="i",
 xaxt="n", yaxt="n", cex.lab=1.4, mgp=c(2.8, 1, 0), type="l", bty="l", col="green3", lty=1, lwd=2)
lines(log(n_cases), log(effect2), type="l", col="firebrick", lty=2, lwd=2)
lines(log(n_cases), log(effect3), type="l", col="royalblue", lty=3, lwd=2)
lines(log(n_cases), log(effect4), type="l", col="purple", lty=4, lwd=2)
lines(log(n_cases), log(effect5), type="l", col="orange", lty=1, lwd=2)
lines(log(n_cases), log(effect6), type="l", col="orange", lty=2, lwd=2)
lines(log(n_cases), log(effect7), type="l", col="orange", lty=3, lwd=2)
lines(log(n_cases), log(effect8), type="l", col="orange", lty=4, lwd=2)

axis(2, at=c(log(1.05), log(1.1), log(1.15), log(1.2), log(1.3), log(1.4), log(1.5), log(1.6)), labels=c("1.05", "1.1", "1.15", "1.2", "1.3", "1.4", "1.5", "1.6"))
axis(1, at=c(log(300), log(500), log(1000), log(2000), log(4000), log(8000), log(16000)), labels=c("300", "500", "1000", "2000", "4000", "8000", "16000"))

par(xpd=NA)
legend(log(20000), log(1.45), legend=c("Total cholesterol", "LDL-cholesterol", "HDL-cholesterol", "Triglycerides",
  expression(italic("PCSK9")), expression(paste(italic("LDLR"), " and ", italic("APOC3"))), expression(italic("LPL")), 
  expression(italic("HMGCR"))), 
  col=c("green3", "firebrick", "royalblue", "purple", "orange", "orange", "orange", "orange"), lty=c(1,2,3,4,1,2,3,4), lwd=2)

##########
# Cancer gene spec

rsq = c(0.012,0.01,0.009,0.004, 0.002)  # r^2 for lipids
effect1 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[1]*(ratio/(1+ratio))*(1/(1+ratio))))
effect2 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[2]*(ratio/(1+ratio))*(1/(1+ratio))))
effect3 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[3]*(ratio/(1+ratio))*(1/(1+ratio))))
effect4 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[4]*(ratio/(1+ratio))*(1/(1+ratio))))
effect5 = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq[5]*(ratio/(1+ratio))*(1/(1+ratio))))

par(oma=c(0,0,0,9), xpd=FALSE)
plot(log(n_cases), log(effect1), xlim=c(6.7,10), ylim=c(log(1.2),log(2.4)), xlab="Number of events", ylab="Effect size for 80% power", xaxs="i", yaxs="i",
 xaxt="n", yaxt="n", cex.lab=1.4, mgp=c(2.8, 1, 0), type="l", bty="l", col="orange", lty=1, lwd=2)
lines(log(n_cases), log(effect2), type="l", col="orange", lty=2, lwd=2)
lines(log(n_cases), log(effect3), type="l", col="orange", lty=3, lwd=2)
lines(log(n_cases), log(effect4), type="l", col="orange", lty=4, lwd=2)
lines(log(n_cases), log(effect5), type="l", col="orange", lty=5, lwd=2)

axis(2, at=c(log(1.1), log(1.2), log(1.4), log(1.6), log(1.8), log(2.0), log(2.4)), labels=c("1.1", "1.2", "1.4", "1.6", "1.8", "2.0", "2.4"))
axis(1, at=c(log(300), log(500), log(1000), log(2000), log(4000), log(8000), log(16000)), labels=c("300", "500", "1000", "2000", "4000", "8000", "16000"))

par(xpd=NA)
legend(log(20000), log(1.95), legend=c(expression(italic("PCSK9")), expression(paste(italic("LDLR"), " and ", italic("APOC3"))), expression(italic("LPL")), 
  expression(italic("HMGCR")), expression(italic("NPC1L1"))), 
  col=c("orange", "orange", "orange", "orange", "orange"), lty=c(1,2,3,4,5), lwd=2)


##########
# Alcohol

rsq = 0.0025 # r^2 for alcohol
effect = exp((qnorm(pow)+qnorm(1-sig/2))/sqrt(n_total*rsq*(ratio/(1+ratio))*(1/(1+ratio))))


plot(log(n_cases), log(effect), xlim=c(5.98,10), ylim=c(log(1.5),log(10)), xlab="Number of events", ylab="Effect size for 80% power", xaxs="i", yaxs="i",
 xaxt="n", yaxt="n", cex.lab=1.4, mgp=c(2.8, 1, 0), type="l", bty="l")

axis(2, at=c(log(1.6), log(2.0), log(3.0), log(5.0), log(7.5), log(10.0)), labels=c("1.6", "2.0", "3.0", "5.0", "7.5", "10.0"))
axis(1, at=c(log(400), log(600), log(1000), log(2000), log(4000), log(8000), log(16000)), labels=c("400", "600", "1000", "2000", "4000", "8000", "16000"))

