#setwd("C:/Dropbox/People/Gabriele Morani/April") # Users/stephen burgess/

library(MendelianRandomization)

####

diseases = c("ca_all", "ca_breast", "ca_prost", "ca_lung", "ca_bowel", "ca_mel", "ca_nhl", 
 "ca_kid", "ca_headneck", "ca_brain", "ca_blad", "ca_panc", "ca_uter",
 "ca_leuk", "ca_oeso", "ca_ov", "ca_gastric", "ca_hep", "ca_myeloma", "ca_thyroid", "ca_bil", "ca_cerv", "ca_test")

hmgcrbeta = NULL; hmgcrlower = NULL; hmgcrupper = NULL
pcsk9beta = NULL; pcsk9lower = NULL; pcsk9upper = NULL
ldlrbeta = NULL; ldlrlower = NULL; ldlrupper = NULL
apobbeta = NULL; apoblower = NULL; apobupper = NULL

hmgcr_snp   = c("rs2006760", "rs7703051", "rs17238484", "rs12916")
hmgcr_betaX = c(0.0533, 0.0727, -0.0627, 0.0733)
hmgcr_seX   = c(0.0076, 0.0037,  0.0062, 0.0036)
hmgcr_effect= c("G", "A", "G", "C")

hmgcr_matrix = matrix(c(1, 0.418513, -0.240068, 0.398727,
                        0.418513, 1, -0.698069, 0.949860,
                       -0.240068, -0.698069, 1, -0.673118,
                        0.398727, 0.949860, -0.673118, 1), nrow=4, ncol=4)


pcsk9_snp   = c("rs2479394", "rs11206510", "rs2149041", "rs10888897", "rs7552841", "rs562556")
pcsk9_betaX = c(0.0386, -0.0831, -0.0636, 0.0640, 0.0507, -0.0368)
pcsk9_seX   = c(0.0041,  0.0050,  0.0049, 0.0066, 0.0042,  0.0044)
pcsk9_effect= c("G", "C", "C", "C", "C", "A")

pcsk9_matrix = matrix(c(1,         -0.293965, -0.2519630,  0.0770863,  0.1286580,  0.0232905,
                       -0.2939650,         1,  0.1632160, -0.2435340, -0.1180510, -0.1488780,
                       -0.2519630,  0.163216,          1, -0.2769930, -0.0730267, -0.1776170,
                        0.0770863, -0.243534, -0.2769930,          1,  0.0802385,  0.3292340,
                        0.1286580, -0.118051, -0.0730267,  0.0802385,          1, -0.2318420,
                        0.0232905, -0.148878, -0.1776170,  0.3292340, -0.2318420,  1), nrow=6, ncol=6)

ldlr_snp   = c("rs6511720", "rs688")
ldlr_betaX = c(0.2209, -0.0540)
ldlr_seX   = c(0.0061,  0.0037)
ldlr_effect= c("G", "C")

ldlr_matrix = matrix(c(1, 0.0930579,
                       0.0930579, 1), nrow=2, ncol=2)


apob_snp   = c("rs10790162", "rs603446")
#apob_betaX = c(0.076, 0.0092) # LDL
#apob_seX   = c(0.0072, 0.0037)
apob_betaX = c(0.2305, 0.0502) # TG
apob_seX   = c(0.0065, 0.0034)
apob_effect= c("A", "C")

apob_matrix = matrix(c(1, 0.241591,
                       0.241591, 1), nrow=2, ncol=2)


for (k in 1:length(diseases)) {
outcome = read.table(paste("output_cancer/lipid_snps_CANCER_outcomes_", diseases[k], ".out", sep=""), header=TRUE, stringsAsFactors=FALSE)

outbeta=NULL; outse=NULL; outeffect=NULL

for (j in 1:length(hmgcr_snp)) {
 outbeta[j]   = c(outcome[which(outcome$rsid==hmgcr_snp[j]), "frequentist_add_beta_1"],NA)[1]
 outse[j]     = c(outcome[which(outcome$rsid==hmgcr_snp[j]), "frequentist_add_se_1"],NA)[1]
 outeffect[j] = c(outcome[which(outcome$rsid==hmgcr_snp[j]), "alleleB"],NA)[1]
 }
outbeta_signed = ifelse(hmgcr_effect==outeffect, outbeta, -outbeta)

IVW = mr_ivw(mr_input(hmgcr_betaX, hmgcr_seX, outbeta_signed, outse, cor=hmgcr_matrix), model="fixed")
hmgcrbeta[k] = IVW$Estimate; hmgcrlower[k] = IVW$CILower; hmgcrupper[k] = IVW$CIUpper


outbeta=NULL; outse=NULL; outeffect=NULL

for (j in 1:length(pcsk9_snp)) {
 outbeta[j]   = c(outcome[which(outcome$rsid==pcsk9_snp[j]), "frequentist_add_beta_1"],NA)[1]
 outse[j]     = c(outcome[which(outcome$rsid==pcsk9_snp[j]), "frequentist_add_se_1"],NA)[1]
 outeffect[j] = c(outcome[which(outcome$rsid==pcsk9_snp[j]), "alleleB"],NA)[1]
 }
outbeta_signed = ifelse(pcsk9_effect==outeffect, outbeta, -outbeta)

IVW = mr_ivw(mr_input(pcsk9_betaX, pcsk9_seX, outbeta_signed, outse, cor=pcsk9_matrix), model="fixed")
pcsk9beta[k] = IVW$Estimate; pcsk9lower[k] = IVW$CILower; pcsk9upper[k] = IVW$CIUpper

# mr_plot(mr_input(pcsk9_betaX, pcsk9_seX, outbeta_signed, outse, cor=pcsk9_matrix), orientate=TRUE, interactive=FALSE)

outbeta=NULL; outse=NULL; outeffect=NULL

for (j in 1:length(ldlr_snp)) {
 outbeta[j]   = c(outcome[which(outcome$rsid==ldlr_snp[j]), "frequentist_add_beta_1"],NA)[1]
 outse[j]     = c(outcome[which(outcome$rsid==ldlr_snp[j]), "frequentist_add_se_1"],NA)[1]
 outeffect[j] = c(outcome[which(outcome$rsid==ldlr_snp[j]), "alleleB"],NA)[1]
 }
outbeta_signed = ifelse(ldlr_effect==outeffect, outbeta, -outbeta)

IVW = mr_ivw(mr_input(ldlr_betaX, ldlr_seX, outbeta_signed, outse, cor=ldlr_matrix))
ldlrbeta[k] = IVW$Estimate; ldlrlower[k] = IVW$CILower; ldlrupper[k] = IVW$CIUpper


outbeta=NULL; outse=NULL; outeffect=NULL

for (j in 1:length(apob_snp)) {
 outbeta[j]   = c(outcome[which(outcome$rsid==apob_snp[j]), "frequentist_add_beta_1"],NA)[1]
 outse[j]     = c(outcome[which(outcome$rsid==apob_snp[j]), "frequentist_add_se_1"],NA)[1]
 outeffect[j] = c(outcome[which(outcome$rsid==apob_snp[j]), "alleleB"],NA)[1]
 }
outbeta_signed = ifelse(apob_effect==outeffect, outbeta, -outbeta)

IVW = mr_ivw(mr_input(apob_betaX, apob_seX, outbeta_signed, outse, cor=apob_matrix))
apobbeta[k] = IVW$Estimate; apoblower[k] = IVW$CILower; apobupper[k] = IVW$CIUpper


}

###

hmgcr_frame = data.frame(hmgcrbeta, hmgcrlower, hmgcrupper)
colnames(hmgcr_frame) <- c("IVW_beta", "IVW_CI_lower", "IVW_CI_upper")

#write.csv(hmgcr_frame, "forest_cancer/ForestPlotHMGCR.csv", quote=FALSE, row.names=diseases) 


pcsk9_frame = data.frame(pcsk9beta, pcsk9lower, pcsk9upper)
colnames(pcsk9_frame) <- c("IVW_beta", "IVW_CI_lower", "IVW_CI_upper")

write.csv(pcsk9_frame, "forest_cancer/ForestPlotPCSK9_NEW.csv", quote=FALSE, row.names=diseases) 


ldlr_frame = data.frame(ldlrbeta, ldlrlower, ldlrupper)
colnames(ldlr_frame) <- c("IVW_beta", "IVW_CI_lower", "IVW_CI_upper")

write.csv(ldlr_frame, "forest_cancer/ForestPlotLDLR_NEW.csv", quote=FALSE, row.names=diseases) 


apob_frame = data.frame(apobbeta, apoblower, apobupper)
colnames(apob_frame) <- c("IVW_beta", "IVW_CI_lower", "IVW_CI_upper")

write.csv(apob_frame, "forest_cancer/ForestPlotAPOC3_NEW.csv", quote=FALSE, row.names=diseases) 


###########

for (j in 1:length(diseases)) {
 cat(decimals(exp(hmgcr_frame$IVW_beta[j]), 2), " (", decimals(exp(hmgcr_frame$IVW_CI_lower[j]), 2), "-", decimals(exp(hmgcr_frame$IVW_CI_upper[j]), 2), ")\t", sep="")
 cat(decimals(exp(pcsk9_frame$IVW_beta[j]), 2), " (", decimals(exp(pcsk9_frame$IVW_CI_lower[j]), 2), "-", decimals(exp(pcsk9_frame$IVW_CI_upper[j]), 2), ")\t", sep="")
 cat(decimals(exp(ldlr_frame$IVW_beta[j]), 2), " (", decimals(exp(ldlr_frame$IVW_CI_lower[j]), 2), "-", decimals(exp(ldlr_frame$IVW_CI_upper[j]), 2), ")\t", sep="")
 cat(decimals(exp(apob_frame$IVW_beta[j]), 2), " (", decimals(exp(apob_frame$IVW_CI_lower[j]), 2), "-", decimals(exp(apob_frame$IVW_CI_upper[j]), 2), ")\t", sep="")
 cat("\n") }

hmgcr_p = pnorm(-abs(2*qnorm(0.975)*hmgcr_frame$IVW_beta/(hmgcr_frame$IVW_CI_upper-hmgcr_frame$IVW_CI_lower)))*2
pcsk9_p = pnorm(-abs(2*qnorm(0.975)*pcsk9_frame$IVW_beta/(pcsk9_frame$IVW_CI_upper-pcsk9_frame$IVW_CI_lower)))*2
ldlr_p = pnorm(-abs(2*qnorm(0.975)*ldlr_frame$IVW_beta/(ldlr_frame$IVW_CI_upper-ldlr_frame$IVW_CI_lower)))*2
apob_p = pnorm(-abs(2*qnorm(0.975)*apob_frame$IVW_beta/(apob_frame$IVW_CI_upper-apob_frame$IVW_CI_lower)))*2


for (j in 1:length(diseases)) {
 cat(diseases[j], hmgcr_p[j]<0.05, pcsk9_p[j]<0.05, ldlr_p[j]<0.05, apob_p[j]<0.05, "\n") }


