setwd("C:/Users/stephen burgess/Dropbox/People/Gabriele Morani/April") # Users/stephen burgess/

library(MendelianRandomization)
#detach("package:TwoSampleMR")

####

#diseases = "ca_all_nSR"
diseases = c("ca_all", "ca_breast", "ca_prost", "ca_lung", "ca_bowel", "ca_mel", "ca_nhl", 
 "ca_kid", "ca_headneck", "ca_brain", "ca_blad", "ca_panc", "ca_uter",
 "ca_leuk", "ca_oeso", "ca_ov", "ca_gastric", "ca_hep", "ca_myeloma", "ca_thyroid", "ca_bil", "ca_cerv", "ca_test")
hmgcrbeta = NULL; hmgcrlower = NULL; hmgcrupper = NULL
lplbeta = NULL; lpllower = NULL; lplupper = NULL

hmgcr_snp   = c("rs2006760", "rs2303152", "rs17238484", "rs12916", "rs10066707", "rs5909")
hmgcr_betaX = c(0.0533, -0.0423, -0.0627, 0.0733, 0.0497, 0.0617)
hmgcr_seX   = c(0.0076, 0.0064,  0.0062, 0.0036, 0.0054, 0.0088)
hmgcr_effect= c("G", "G", "G", "C", "A", "A")

hmgcr_matrix = matrix(c(1,         -0.519909, -0.240068,  0.398727,  0.47935,  0.447819,
                        -0.519909,  1,         0.640277, -0.436171, -0.283095, 0.12608,
                        -0.240068,  0.640277,  1,        -0.673118, -0.539508, 0.226624,
                         0.398727, -0.436171, -0.673118,  1,        0.499216,  0.364091,
                         0.479350, -0.283095, -0.539508,  0.499216, 1,         0.212708,
                         0.447819,  0.12608,   0.226624,  0.364091, 0.212708,  1), nrow=6, ncol=6)

lpl_snp   = c("rs1801177", "rs268", "rs301", "rs326", "rs328")
lpl_betaX = c(0.1635, -0.2797, -0.1089, 0.0869, 0.167)
lpl_seX   = c(0.0231,  0.0345,  0.0039, 0.005, 0.0058) # assoc with TG


lpl_effect= c("A", "A", "C", "A", "C")

lpl_matrix = matrix(c(        1,  0.0253519, -0.119806,   0.0651701,  0.051882,
                      0.0253519,  1,          0.0501773, -0.0934448, -0.0900977,
                     -0.119806,   0.0501773,  1,         -0.569455,  -0.457965,
                      0.0651701, -0.0934448, -0.569455,   1,          0.528113, 
                      0.051882,  -0.0900977, -0.457965,   0.528113,   1), nrow=5, ncol=5)


for (k in 1:length(diseases)) {
outcome = read.table(paste("output_cancer/lipid_snps_CANCER_outcomes_", diseases[k], ".out", sep=""), header=TRUE, stringsAsFactors=FALSE)

outbeta=NULL; outse=NULL; outeffect=NULL

for (j in 1:length(hmgcr_snp)) {
 outbeta[j]   = c(outcome[which(outcome$rsid==hmgcr_snp[j]), "frequentist_add_beta_1"],NA)[1]
 outse[j]     = c(outcome[which(outcome$rsid==hmgcr_snp[j]), "frequentist_add_se_1"],NA)[1]
 outeffect[j] = c(outcome[which(outcome$rsid==hmgcr_snp[j]), "alleleB"],NA)[1]
 }
outbeta_signed = ifelse(hmgcr_effect==outeffect, outbeta, -outbeta)

IVW = mr_ivw(mr_input(hmgcr_betaX, hmgcr_seX, outbeta_signed, outse, cor=hmgcr_matrix), model="fixed")
hmgcrbeta[k] = IVW$Estimate; hmgcrlower[k] = IVW$CILower; hmgcrupper[k] = IVW$CIUpper

# mr_plot(mr_input(hmgcr_betaX, hmgcr_seX, outbeta_signed, outse, exposure="LDL-cholesterol", outcome="overall cancer", cor=hmgcr_matrix), interactive=FALSE, orientate=TRUE)
outbeta=NULL; outse=NULL; outeffect=NULL

for (j in 1:length(lpl_snp)) {
 outbeta[j]   = c(outcome[which(outcome$rsid==lpl_snp[j]), "frequentist_add_beta_1"],NA)[1]
 outse[j]     = c(outcome[which(outcome$rsid==lpl_snp[j]), "frequentist_add_se_1"],NA)[1]
 outeffect[j] = c(outcome[which(outcome$rsid==lpl_snp[j]), "alleleB"],NA)[1]
 }
outbeta_signed = ifelse(lpl_effect==outeffect, outbeta, -outbeta)

IVW = mr_ivw(mr_input(lpl_betaX, lpl_seX, outbeta_signed, outse, cor=lpl_matrix), model="fixed")
lplbeta[k] = IVW$Estimate; lpllower[k] = IVW$CILower; lplupper[k] = IVW$CIUpper


}

###

hmgcr_frame = data.frame(hmgcrbeta, hmgcrlower, hmgcrupper)
colnames(hmgcr_frame) <- c("IVW_beta", "IVW_CI_lower", "IVW_CI_upper")

write.csv(hmgcr_frame, "forest_cancer/ForestPlotHMGCR2_NEW.csv", quote=FALSE, row.names=diseases) 


lpl_frame = data.frame(lplbeta, lpllower, lplupper)
colnames(lpl_frame) <- c("IVW_beta", "IVW_CI_lower", "IVW_CI_upper")

write.csv(lpl_frame, "forest_cancer/ForestPlotLPL_NEW.csv", quote=FALSE, row.names=diseases) 


###########

for (j in 1:length(diseases)) {
 cat(decimals(exp(hmgcr_frame$IVW_beta[j]), 2), " (", decimals(exp(hmgcr_frame$IVW_CI_lower[j]), 2), "-", decimals(exp(hmgcr_frame$IVW_CI_upper[j]), 2), ")\t", sep="")
 cat(decimals(exp(lpl_frame$IVW_beta[j]), 2), " (", decimals(exp(lpl_frame$IVW_CI_lower[j]), 2), "-", decimals(exp(lpl_frame$IVW_CI_upper[j]), 2), ")\t", sep="")
 cat("\n") }

hmgcr_p = pnorm(-abs(2*qnorm(0.975)*hmgcr_frame$IVW_beta/(hmgcr_frame$IVW_CI_upper-hmgcr_frame$IVW_CI_lower)))*2
