rm(list=ls())

library(forestplot)
#library(MendelianRandomization)

setwd("C:/Dropbox/People/Gabriele Morani/April") # Users/stephen burgess/

################## ESEMPIO PAR DI GRAFICI ################

HDL<-read.table("forest_cancer/ForestPlotTC.csv",header=T, sep=",") #%# change
#out<-row.names(HDL)

xticks <- c(log(0.5), log(0.6), log(0.8), log(1), log(1.2), log(1.4), log(1.6), log(2.0), log(2.5))
attr(xticks, "labels") <- c("0.5", "0.6", "0.8", "1.0", "1.2", "1.4", "1.6", "2.0", "2.5")

xticks2<- seq(from = -0.4,to = 1, by = 0.2)

HDL<-HDL[1:31,] #!#
nout<-dim(HDL)[1]
#out<-row.names(HDL)

IVWHDL <- structure(list(
    mean  = c(NA,HDL$IVW_beta),
    lower = c(NA,HDL$IVW_CI_lower),
    upper = c(NA,HDL$IVW_CI_upper),  pval = c(NA, decimals(pnorm(-abs(2*qnorm(0.975)*HDL$IVW_beta/(HDL$IVW_CI_upper-HDL$IVW_CI_lower)))*2,3))),
    .Names = c("mean", "lower", "upper", "pval"), 
    row.names = as.character(rep(NA,nout+1)),
    class = "data.frame") #

out<-c("Breast","Prostate", "Lung","- squamous", "- adenocarcinoma", "- non-small cell", "Bowel",
"Melanoma", "Non-Hodgkins Lymphoma", "- diffuse large B-cell lymphoma", "- follicular lymphoma",
"Kidney", "Head/neck", "- oral", "- laryngeal and hypopharyngeal", "Brain",
"Bladder","Pancreas","Uterus","Leukaemia", "- acute myloid", "- chronic lymphocytic",
"Oesophagus", "Ovaries","Gastric","Liver","Myeloma", "Thyroid", "Biliary", "Cervix", "Testes")   


tabletext<-c("Disease",out)
tabletext2<-rep(NA,nout+1)

# Print two plots side by side using the grid
# package's layout option for viewports

###### CON IL PRINT PROBLEMA DI DIMENSIONI (sistemato con width)

pdf("forest_cancer/ForestPlotTC.pdf", width=25) #%# change HDL/LDL/TG

A<-grid.newpage()
  pvalue = c(NA, paste("p", ifelse(IVWHDL$pval[2:(nout+1)]<0.001, "<0.001", paste("=", IVWHDL$pval[2:(nout+1)], sep="")), sep=""))
  tabletextHDL = cbind(tabletext, pvalue)
forestplot(tabletextHDL, 
	exp(IVWHDL$mean),
	exp(IVWHDL$lower),
	exp(IVWHDL$upper),
	graph.pos = 2,
	fn.ci_norm = fpDrawNormalCI,
	boxsize = .15,
	lwd.ci=1,
	clip =c(0.4,2.5),
	graphwidth= unit(7,"cm"),
	hrzl_lines = list("2" = gpar(col="#444444",columns=1)),
	is.summary=c(TRUE,rep(FALSE,nout)),
	col=fpColors(box="royalblue",line="darkblue"),
	xlog=TRUE,
	zero=1,
	lwd.zero=1,
	vertices = TRUE, 
      xticks=exp(xticks),
	lineheight = "auto",
	grid=T,
	new_page = FALSE)
popViewport()

print(A)
dev.off()


#####################

for (j in 1:nout) {
 cat(out[j], rep(" ", 40-nchar(out[j])), sep="")
 cat(decimals(exp(HDL$IVW_beta[j]), 2), " (", decimals(exp(HDL$IVW_CI_lower[j]), 2), "-", decimals(exp(HDL$IVW_CI_upper[j]), 2), ")\t", sep="")
 cat("\n") }

IVWp = pnorm(-abs(2*qnorm(0.975)*HDL$IVW_beta/(HDL$IVW_CI_upper-HDL$IVW_CI_lower)))*2
WMEp = pnorm(-abs(2*qnorm(0.975)*HDL$WME_beta/(HDL$WME_CI_upper-HDL$WME_CI_lower)))*2
ERp = pnorm(-abs(2*qnorm(0.975)*HDL$ER_beta/(HDL$ER_CI_upper-HDL$ER_CI_lower)))*2


for (j in 1:nout) {
 cat(out[j], IVWp[j]<0.05, WMEp[j]<0.05, ERp[j]<0.05, "\n") }

for (j in 1:nout) {
  cat(out[j]); cat(rep(" ", 40-nchar(out[j])), sep=""); cat(decimals(IVWp[j],3), decimals(WMEp[j],3), decimals(ERp[j],3), "\n") }

