%% Data Viewer


load('RawData.mat');


%% Figure 3C: Relative distributions of significant responses


% RD = RawData.CellType_Approach;
RD = RawData.CellType_Eating;
% RD = RawData.CellType_Removal;


figure(1);

subplot(2,1,1); hold on;
plot( RD.X, RD.Yresampled_Increase, 'Color', [ .7 .7 .7 ] );
plot( RD.X, RD.Ymain_Increase, 'Color', 'r', 'LineWidth', 2 );
xlim( [ RD.X(1) RD.X(end) ] );
ylabel('Probability');
title( { 'Relative distributions of significant responses, odor-guided go/no-go task'; 'Increase' } );

subplot(2,1,2); hold on;
plot( RD.X, RD.Yresampled_Decrease, 'Color', [ .7 .7 .7 ] );
plot( RD.X, RD.Ymain_Decrease, 'Color', 'b', 'LineWidth', 2 );
xlim( [ RD.X(1) RD.X(end) ] );
xlabel('Time (sec)');
title('Decrease');


%%

