%% Data Viewer


load('RawData.mat');


%% Figure 5B: Decoding accuracy


figure(1);

subplot(1,2,1); hold on;
plot( RawData.fromOdorValveOn.X, RawData.fromOdorValveOn.Yshuffled, 'Color', [ .7 .7 .7 ] );
plot( RawData.fromOdorValveOn.X, RawData.fromOdorValveOn.Ymain, 'Color', 'k', 'LineWidth', 2 );
xlim( [ RawData.fromOdorValveOn.X(1) RawData.fromOdorValveOn.X(end) ] );
ylim( [ 0 100 ] );
xlabel('Time - odor onset (sec)');
ylabel('% Decoding accuracy');
title('Odor decoding accuracy in the odor-guided go/no-go task');

subplot(1,2,2); hold on;
plot( RawData.fromOdorPortExit.X, RawData.fromOdorPortExit.Yshuffled, 'Color', [ .7 .7 .7 ] );
plot( RawData.fromOdorPortExit.X, RawData.fromOdorPortExit.Ymain, 'Color', 'k', 'LineWidth', 2 );
xlim( [ RawData.fromOdorPortExit.X(1) RawData.fromOdorPortExit.X(end) ] );
ylim( [ 0 100 ] );
xlabel('Time - odor port exit (sec)');


%%

