clearvars;close all;clc
% get the directory with all the GED results (we put everything into the same folder but you may have setup the analyses differently)
dataDir = 'E:\Arizona\HPS\LFP_Analysis\result_final\eLife_revisionResults';
% get the component maps from the modality independent decompositions. 
fileID1 = '*1.mat'; %pick the results from modality independent analyses
[allMaps1, allidx1] = compCounter(dataDir,fileID1);
% get the component maps from the modality specific decompositions. 
fileID2 = '*2.mat'; %pick the results from modality specific analyses
[vcomps, tcomps, acomps, totcomps, vmaps, tmaps, amaps, totmaps, vidx, tidx, aidx, totidx] = compCounter(dataDir,fileID2);

%% do session-by-session correlations and flip sign where maps are negatively correlated
%initialize some variables
vmaps1 = [];
tmaps1 = [];
amaps1 = [];

vAll_AllMap = [];
tAll_AllMap = [];
aAll_AllMap = [];

%set up some counters
v = 0;
t = 0;
a = 0;

%loop through all the sessions
for sessi = 1:41
    
    % check to see if a component was extracted from both analysis methods
    %%% all vs visual
    if ~isempty(find(allidx == sessi,1)) && ~isempty(find(vidx == sessi,1))
        v = v + 1;
        [all_v_corrs_r(v,:,:), all_v_corrs_p(v,:,:)] = corrcoef(allMaps(find(allidx == sessi,1),:),vmaps(find(vidx == sessi,1),:));
        if all_v_corrs_r(v,1,2) < 0
            vmaps1 = horzcat(vmaps1,-vmaps(find(vidx == sessi,1),:));
        else
            vmaps1 = horzcat(vmaps1,vmaps(find(vidx == sessi,1),:));
        end
        vAll_AllMap = horzcat(vAll_AllMap,allMaps(find(allidx == sessi,1),:));
    end
    %%% all vs tactile
    if ~isempty(find(allidx == sessi,1)) && ~isempty(find(tidx == sessi,1))
        t = t + 1;
        [all_t_corrs_r(t,:,:), all_t_corrs_p(t,:,:)] = corrcoef(allMaps(find(allidx == sessi,1),:),tmaps(find(tidx == sessi,1),:));
        if all_t_corrs_r(t,1,2) < 0
            tmaps1 = horzcat(tmaps1,-tmaps(find(tidx == sessi,1),:));
        else
            tmaps1 = horzcat(tmaps1,tmaps(find(tidx == sessi,1),:));
        end
        tAll_AllMap = horzcat(tAll_AllMap,allMaps(find(allidx == sessi,1),:));
    end
    %%% all vs aud
    if ~isempty(find(allidx == sessi,1)) && ~isempty(find(aidx == sessi,1))
        a = a + 1;
        [all_a_corrs_r(a,:,:), all_a_corrs_p(a,:,:)] = corrcoef(allMaps(find(allidx == sessi,1),:),amaps(find(aidx == sessi,1),:));
        if all_a_corrs_r(a,1,2) < 0
            amaps1 = horzcat(amaps1,-amaps(find(aidx == sessi,1),:));
        else
            amaps1 = horzcat(amaps1,amaps(find(aidx == sessi,1),:));
        end
        aAll_AllMap = horzcat(aAll_AllMap,allMaps(find(allidx == sessi,1),:));
    end
end
%% Figure 5 scatter plots
figure(1);clf
subplot(131)
[r,p] = corrcoef(reshape(vmaps1,1,[]),vAll_AllMap)
plot(vAll_AllMap,reshape(vmaps1,1,[]),'r.','markersize',6)
hold on
line([-1 1],[0 0],'color','k','linestyle','--')
line([0 0],[-1 1],'color','k','linestyle','--')
xlim([-1 1])
ylim([-1 1])
title({'All vs Vis' ['r = ' num2str(round(r(1,2),2))]})
xlabel('Contact weights (All)')
ylabel('Contact weights (Vis)')
axis square

subplot(132)
[r,p] = corrcoef(reshape(tmaps1,1,[]),tAll_AllMap)
plot(tAll_AllMap,reshape(tmaps1,1,[]),'g.','markersize',6)
hold on
line([-1 1],[0 0],'color','k','linestyle','--')
line([0 0],[-1 1],'color','k','linestyle','--')
xlim([-1 1])
ylim([-1 1])
title({'All vs Tac' ['r = ' num2str(round(r(1,2),2))]})
xlabel('Contact weights (All)')
ylabel('Contact weights (Tac)')
axis square

subplot(133)
[r,p] = corrcoef(reshape(amaps1,1,[]),aAll_AllMap)
plot(aAll_AllMap,reshape(amaps1,1,[]),'b.','markersize',6)
hold on
line([-1 1],[0 0],'color','k','linestyle','--')
line([0 0],[-1 1],'color','k','linestyle','--')
xlim([-1 1])
ylim([-1 1])
title({'All vs Aud' ['r = ' num2str(round(r(1,2),2))]})
xlabel('Contact weights (All)')
ylabel('Contact weights (Aud)')
 axis square
 
 set(gcf,'position',[50 50 1200 600])
%% save figure
print(gcf,'D:\HPS_LFP_eLife\Figures\componentMapCorrelationWeights_alltri_v_mods_v2','-dpdf','-bestfit')