% Modality power comparisons
%{
Compare the changes in power for each modality relative to the other modalities using cluster mass tests. These tests are based off of those used in Maris and
Oostenveld 2007. The use the sum of the t-statistic within a cluster of significant bins (i.e., bins which pass an initial significance threshold and are
located within on cell in any 2-dimensional direction.

This code was only run for modality independent analyses. No adaption was made for modality specific analyses

you will need the following for this code
-trial by trial time-frequency data that is baseline normalized
-frequency space you analyzed
-time window you analyzed
-number of significant components for each session
%}


%% Load the data

clearvars;close all;clc

%set to true if you want to save these results for later use
saveDiffPlots = false;
saveData = false;

% Get directory with results mat files 
dataDir = 'E:\Arizona\HPS\LFP_Analysis\results';
cd(dataDir)
fDir = dir('*.mat');
fList = {fDir(:).name};

times2plot = -1500:20:1500; %the paper took data from -1500 to +1500 relative to stimulus onset in 20 ms steps
times2plotidx = dsearchn(times2plot',[-800 1200]'); % these indexes set the xlim of the plot
stimStartBin = dsearchn(times2plot',0); % index of the time point for stimulus on
stimEndBin = dsearchn(times2plot',1000); % index of the time point for stimulus off
frexi = 1:80; %number of frequencies used, (will the be length of the frex variable from the earlier code)

% p-value
pval = 0.01;

% convert p-value to Z value
% if you don't have the stats toolbox, set zval=1.6449;
zval = abs(norminv(pval));

% number of permutations
n_permutes = 1000; %1000 used in the paper


%Loop through all sessions in the folder
for sessi = 1:length(fList)
    %Go to data directory again
    cd(dataDir)
    load(fList{sessi})
    
    %%% statistics via permutation testing
    % initialize null hypothesis maps
    permmaps = zeros(n_permutes,stimEndBin-stimStartBin,size(frex,2));
    
    %Loop through components for this session
    for compi = 1:GED_results.ncomps
        %%% divide TF into modalities
        clear modTfV modTfVB modTfT modTfTB modTfA modTfAB diffmap tf3d permmaps mean_h0 std_h0 modDiffMap sigDiffMaps
        % note that tfDiffTri was a potential product from SourceCodeFile1
        modTfV(:,:,:) = GED_results.tfDiffTri(compi, stimStartBin:stimEndBin,EEG.trialtype == 1, :); %TF power for during visual stimulus delivery
        modTfT(:,:,:) = GED_results.tfDiffTri(compi, stimStartBin:stimEndBin,EEG.trialtype == 2, :); %TF power for during tactile stimulus delivery
        modTfA(:,:,:) = GED_results.tfDiffTri(compi, stimStartBin:stimEndBin,EEG.trialtype == 3, :); %TF power for during auditory stimulus delivery
        
        %%% create difference maps comparing each modality to the others 
        %looping through each comparison individually right now
        figure(1),clf
        figure(2),clf
        for i = 1:3 %loop through the 3 modalities
            clear zmap zmap1 zmap2 zmap3 tf3d ntrials diffmap permmaps mean_h0 std_h0
          
            %generate baseline maps
            if i == 1
                for basesi = 1:size(modTfV,2)
                    baseStart = randi(75,1); %set a random start time of the baseline window
                    modTfVB(:,basesi,:) = squeeze(mean(GED_results.tfDiffTri(compi, baseStart : baseStart+size(modTfV,1)-1, :,:),3)); %create a matrix from the baseline time
                end
                tf3d = cat(2, modTfV, modTfVB); %put together the baseline and the stimulus TF matrices
                ntrials = size(modTfV,2);
                diffmap = squeeze(mean(modTfV(:,:,:),2 )) - squeeze(mean(modTfVB(:,:,:),2 )); %get the difference between the baseline and stimulus delivery window
            elseif i == 2
                for basesi = 1:size(modTfT,2)
                    baseStart = randi(75,1); %set a random start time of the baseline window
                    modTfTB(:,basesi,:) = squeeze(mean(GED_results.tfDiffTri(compi, baseStart : baseStart+size(modTfT,1)-1, :, :),3));%create a matrix from the baseline time
                end
                tf3d = cat(2, modTfT, modTfTB);%put together the baseline and the stimulus TF matrices
                ntrials = size(modTfT,2);
                diffmap = squeeze(mean(modTfT(:,:,:),2 )) - squeeze(mean(modTfTB(:,:,:),2 ));%get the difference between the baseline and stimulus delivery window
                
            elseif i == 3
                for basesi = 1:size(modTfA,2)
                    baseStart = randi(75,1);%set a random start time of the baseline window
                    modTfAB(:,basesi,:) = squeeze(mean(GED_results.tfDiffTri(compi, baseStart : baseStart+size(modTfA,1)-1, :,:),3));%create a matrix from the baseline time
                end
                tf3d = cat(2, modTfA, modTfAB);%put together the baseline and the stimulus TF matrices
                ntrials = size(modTfA,2);
                diffmap = squeeze(mean(modTfA(:,:,:),2 )) - squeeze(mean(modTfAB(:,:,:),2 ));%get the difference between the baseline and stimulus delivery window
                
            end
            
            % generate maps under the null hypothesis
            for permi = 1:n_permutes
               
                fprintf(['perm # ' num2str(permi) '\r'])
                
                % randomize trials, which also randomly assigns trials to channels
                randorder = randperm(size(tf3d,2));
                temp_tf3d = tf3d(:,randorder,:);
                
                % compute the "difference" map
                permmaps(permi,:,:) = squeeze( mean(temp_tf3d(:,1:ntrials,:),2) - mean(temp_tf3d(:,ntrials+1:end,:),2) );
                
            end

            %%% compute z- and p-values based on normalized distance to H0 distributions (per pixel)
            
            % compute mean and standard deviation maps
            mean_h0 = squeeze(mean(permmaps));
            std_h0  = squeeze(std(permmaps));
            
            % now threshold real data...
            % first Z-score
            zmap = (diffmap-mean_h0) ./ std_h0;

            % threshold image at p-value, by setting subthreshold values to 0
            zmap(abs(zmap)<zval) = 0;
            
            zmap2 = zmap; % zmap is going to get masked for the cluster size test, zmap2 will get masked for the cluster mass test
            
            %%%  Create a distribution of cluster sizes expected under the null hypothesis.
            % initialize matrices for cluster-based correction
            max_cluster_sizes = zeros(1,n_permutes);
            max_cluster_values = zeros(1,n_permutes);
            
            % loop through permutations
            for permi = 1:n_permutes
                clear totZ threshimg
                % take each permutation map, and transform to Z
                threshimg = squeeze(permmaps(permi,:,:));
                threshimg = (threshimg-mean_h0)./std_h0;
                
                % threshold image at p-value
                threshimg(abs(threshimg)<zval) = 0;
                
                
                % find clusters (need image processing toolbox for this!)
                islands = bwconncomp(threshimg);
                if numel(islands.PixelIdxList)>0
                    
                    % count sizes of clusters
                    tempclustsizes = cellfun(@length,islands.PixelIdxList);
                    for zi = 1:islands.NumObjects
                        totZ(zi) = sum(threshimg(islands.PixelIdxList{1,zi}));
                    end
                    
                    max_cluster_values(permi) = max(abs(totZ));
                    
                    % store size of biggest cluster
                    max_cluster_sizes(permi) = max(tempclustsizes);
                end
            end
                        
            % find cluster threshold (need image processing toolbox for this!)
            % based on p-value and null hypothesis distribution
            cluster_thresh = prctile(max_cluster_sizes,100-(100*pval));
            cluster_thresh_z = prctile(max_cluster_values,100-(100*pval));
            
            
            % now find clusters in the real thresholded zmap
            % if they are "too small" set them to zero
            islands = bwconncomp(zmap);
            for ii = 1:islands.NumObjects
                % if real clusters are too small, remove them by setting to zero!
                if numel(islands.PixelIdxList{ii}==ii) < cluster_thresh
                    zmap(islands.PixelIdxList{ii})=0;
                end
                
                
                if abs(sum(zmap2(islands.PixelIdxList{ii}))) < cluster_thresh_z
                    zmap2(islands.PixelIdxList{ii})=0;
                end
            end
            
            %%% Plot the results from the cluster size test (basically counts the number of significant bins in a cluster)
                
            %This limit generally works for most TF plots but makes a few look weird. Still, it is good to have a standard scale bar
            clim1 = [-6 6];
            figure(1)
            hold on
            subplot(1,3,i)
             
            imagesc(squeeze(mean(GED_results.tfDiffTri(compi,times2plotidx(1):times2plotidx(2),EEG.trialtype == i,:),3)))
            hold on
            zmap1(1:stimStartBin-times2plotidx(1)-1,1:80) = 0;
            zmap1(stimStartBin-times2plotidx(1):stimStartBin-times2plotidx(1)+49,1:80) = zmap;
            contour(frexi,[1:stimStartBin-times2plotidx(1)+49],logical(zmap1),2,'linecolor','k');

            set(gca,'clim',clim1,'xlim',xlim,'ydir','reverse','XAxisLocation','top')
            camroll(90)
            
            line([0 81], [stimStartBin-times2plotidx(1)-0.5 stimStartBin-times2plotidx(1)-0.5],'color','k','linew',2)
            line([0 81], [stimStartBin-times2plotidx(1)+49 stimStartBin-times2plotidx(1)+49],'color','k','linew',2)
                
            xticks(1:10:80)
            xticklabels(round([frex(1:10:end), 100],1))
            
            yticks(.5:20:times2plotidx(2)-times2plotidx(1)+0.5)
            yticklabels([-0.8:0.400:1.2])
            ylabel('Time (s)'), xlabel('Frequency (Hz)')
            colorcet('D1A') %I used a color scale that has no perceptual boundaries (Peter Kovesi. Good Colour Maps: How to Design Them.)

            hold off
            
            if i == 1
                title('Vis')
            elseif i == 2
                title('Tac')
            else
                title('Aud')
            end
            
            
            %%% plot the results from the cluster mass test (sums the test statistic for the clusters of significant bins, this was used in the paper although both methods return similar results)
            % these plots were used in figure 4
            clim1 = [-6 6];
            figure(2)
            hold on
            subplot(1,3,i)
             
            imagesc(squeeze(mean(GED_results.tfDiffTri(compi,times2plotidx(1):times2plotidx(2),EEG.trialtype == i,:),3)))
            hold on
            zmap3(1:stimStartBin-times2plotidx(1)-1,1:80) = 0;
            zmap3(stimStartBin-times2plotidx(1):stimStartBin-times2plotidx(1)+49,1:80) = zmap2;
            contour(frexi,[1:stimStartBin-times2plotidx(1)+49],logical(zmap3),2,'linecolor','k');

            set(gca,'clim',clim1,'xlim',xlim,'ydir','reverse','XAxisLocation','top')
            camroll(90)
            
            line([0 81], [stimStartBin-times2plotidx(1)-0.5 stimStartBin-times2plotidx(1)-0.5],'color','k','linew',2)
            line([0 81], [stimStartBin-times2plotidx(1)+49 stimStartBin-times2plotidx(1)+49],'color','k','linew',2)
                
            xticks(1:10:80)
            xticklabels(round([frex(1:10:end), 100],1))
            
            yticks(.5:20:times2plotidx(2)-times2plotidx(1)+0.5)
            yticklabels([-0.8:0.400:1.2])
            ylabel('Time (s)'), xlabel('Frequency (Hz)')
            colorcet('D1A') %I used a color scale that has no perceptual boundaries (Peter Kovesi. Good Colour Maps: How to Design Them.)

            hold off
            
            if i == 1
                title('Vis')
            elseif i == 2
                title('tac')
            else
                title('Aud')
            end
            
            modDiffMap{i} = diffmap; %the difference map
            sigDiffMap_size{i} = zmap; %the z-value map used for the cluster size test
            sigDiffMaps_mass{i} = zmap2; %the z-value map used for the cluster mass test
            
        end
            
        % save the plots if wanted
        if saveDiffPlots == true
            figure(1)
            set(gcf,'position',[2200 200 1200 400])
            cd D:\HPS\LFP_Analysis\TF_plots\Stats\TFPlotsStats_size_p001
            print([fList{sessi}(1:end-9) 'comp' num2str(compi) '_size_pval001'],gcf,'-dpng')
        end
        
        if saveDiffPlots == true
            figure(2)
            set(gcf,'position',[2200 200 1200 400])
            cd D:\HPS\LFP_Analysis\TF_plots\Stats\TFPlotsStats_mass_p001
            print([fList{sessi}(1:end-9) 'comp' num2str(compi) '_mass_pval001'],gcf,'-dpng')
        end
        
        
        if saveData == true
            cd D:\HPS\LFP_Analysis\TF_plots\Stats\TFBaseDiffStats_p001
            save([fList{sessi}(1:end-9) 'comp' num2str(compi) '_diffMapVals_pval001'],'modDiffMap','sigDiffMap_size','sigDiffMaps_mass','zval','times2plot','stimStartBin','stimEndBin')
        end
    end
end


%% get population numbers
% go through to find out how many component time series showed significant changes in activity during stimulus delivery relative to baseline

cleanup
cd D:\HPS\LFP_Analysis\TF_plots\Stats\TFBaseDiffStats_p001
mFiles = dir('*.mat');
mList = extractfield(mFiles,'name')';

frex = logspace(log10(1),log10(100),80);
% p-value
pval = 0.01;

% convert p-value to Z value
% if you don't have the stats toolbox, set zval=1.6449;
zval = abs(norminv(pval));

totalNumberOfComponents = 116;
%{
 we ran the initial analyses once and stuck with the results for the remainder of the project. this initial run yielded 116 significant components. Due to the
 permutation based significance thresholding, it is possible that subsequent analyses will yield slightly different results. However, subsequent runs of the
 initial analyses (data not shown in the manuscript) all extracted very similar components in terms of total number of qualitative features.
%}
freqSig = zeros(totalNumberOfComponents,3,80); %significant for any frequency (regardless if there was enhanced or suppressed power during stimulus delivery)
freqValues = zeros(totalNumberOfComponents,3,80); %the actual z-values for each map
freqValuesPos = zeros(totalNumberOfComponents,3,80); %increases in power
freqValuesNeg = zeros(totalNumberOfComponents,3,80); %decreases in power

%loop through the components
for compi = 1:length(mFiles)
    clear sigDiffMaps modDiffMap
    load(mList{compi})
    
    %Loop through modalities
    for modi = 1:3
        
        % get significant bins for this modality
        modDiff(compi,modi) = max(max(sigDiffMaps_mass{1,modi}))>0;
        freqSig(compi,modi,:) = max(abs(sigDiffMaps_mass{modi}))>0;
        freqValues(compi,modi,:) = max(abs(sigDiffMaps_mass{modi}));
        
        for freqi = 1:80 %loop through the frequencies tested
            
            %if the value was not significant set it to nan (makes taking averages later easier)
            if freqValues(compi,modi,freqi) == 0
               freqValues(compi,modi,freqi) = nan; 
            end
            
            %Check if the significant bins were increases or decreases in power
            if max(sigDiffMaps_mass{modi}(:,freqi)) >=  max(abs(min(sigDiffMaps_mass{modi}(:,freqi))))
                freqValuesPos(compi,modi,freqi) = max(sigDiffMaps_mass{modi}(:,freqi));
            elseif max(sigDiffMaps_mass{modi}(:,freqi)) <  max(abs(min(sigDiffMaps_mass{modi}(:,freqi))))
                freqValuesNeg(compi,modi,freqi) = min(sigDiffMaps_mass{modi}(:,freqi));
            end
            % if the change wasn't positive, set the values in the freqValuesPos to nan (makes averaging later easier)
            if freqValuesPos(compi,modi,freqi) == 0
                freqValuesPos(compi,modi,freqi) = nan;
            end
            % if the change wasn't negative, set the values in the freqValuesNeg to nan (makes averaging later easier)
            if freqValuesNeg(compi,modi,freqi) == 0
                freqValuesNeg(compi,modi,freqi) = nan;
            end
        end
    end
end

% get the total number of components with significant changes
for i = 1:length(modDiff)
    compSig(i) = sum(modDiff(i,:))>0;
end
totSigComps = sum(compSig);
percentTotSigComps = totSigComps/length(compSig);

%get the difference between the number of visual and tactile responses
percentDiffVT = length(find(modDiff(:,1) == 1))/size(modDiff,1)
%get the difference between the number of visual and auditory responses
percentDiffVA = length(find(modDiff(:,2) == 1))/size(modDiff,1)
%get the difference between the number of tactile and auditory responses
percentDiffTA = length(find(modDiff(:,3) == 1))/size(modDiff,1)


% comparison of number of significant responses
[vtResp,hvt,statsv] = ranksum(modDiff(:,1),modDiff(:,2)) %visual vs tactile
[vaResp,hva,statst] = ranksum(modDiff(:,1),modDiff(:,3)) %visual vs auditory
[taResp,hta,statsa] = ranksum(modDiff(:,2),modDiff(:,3)) %tactile vs auditory


%% plot results 
% Counts of sig freqs across comps
sf1 = squeeze(sum(freqSig,1));

figure;
plot(sf1(1,:),'r')
hold on;
plot(sf1(2,:),'g')
plot(sf1(3,:),'b')

xticks(1:10:80) 
xticklabels(round(frex(1:10:end),1))
xlabel('freq')
ylabel('# of comps')
title('Number of components with diffs at freqs')
legend('Vis-Tac','Vis-Aud','Tac-Aud')

%Average max zval across freqs and comps
sf_mean = squeeze(nanmean(freqValues,1));
sf_sd = squeeze(nanstd(freqValues,1));

for i = 1:size(sf_sd,1)
    for ii = 1:size(sf_sd,2)
        sf_sem(i,ii) = sf_sd(i,ii)/length(find(~isnan(freqValues(:,i,ii))));
    end
end

%compare across all frequencies
[hvt, pvt, statsvt] = ttest(sf_mean(1,:),sf_mean(2,:))
[hva, pva, statsva] = ttest(sf_mean(1,:),sf_mean(3,:))
[hta, pta, statsta] = ttest(sf_mean(2,:),sf_mean(3,:))

%split into low and high frequencies
[hvt, pvt, statsvt] = ttest(sf_mean(1,41:end),sf_mean(2,41:end))
[hva, pva, statsva] = ttest(sf_mean(1,41:end),sf_mean(3,41:end))
[hta, pta, statsta] = ttest(sf_mean(2,41:end),sf_mean(3,41:end))

%Compare values at each frequency
for ii = 1:size(freqValues,3)
    
    [pvalFreqsVT(ii), sigDiffFreqVT(ii)] = ranksum(squeeze(abs(freqValues(:,1,ii))),squeeze(abs(freqValues(:,2,ii))),'alpha',0.01);
    [pvalFreqsVA(ii), sigDiffFreqVA(ii)] = ranksum(squeeze(abs(freqValues(:,1,ii))),squeeze(abs(freqValues(:,3,ii))),'alpha',0.01);
    [pvalFreqsTA(ii), sigDiffFreqTA(ii)] = ranksum(squeeze(abs(freqValues(:,2,ii))),squeeze(abs(freqValues(:,3,ii))),'alpha',0.01);
       
end

figure; %(used for figure 4g)
hold on;
%plot the average (+/- 3 standard error of the mean) z-values for the visual response 
plot(sf_mean(1,:),'r')
plot(sf_mean(1,:)+(sf_sem(1,:)*3),'r--')
plot(sf_mean(1,:)-(sf_sem(1,:)*3),'r--')

%plot the average (+/- 3 standard error of the mean) z-values for the tactile response
plot(sf_mean(2,:),'g')
plot(sf_mean(2,:)+(sf_sem(2,:)*3),'g--')
plot(sf_mean(2,:)-(sf_sem(2,:)*3),'g--')

%plot the average (+/- 3 standard error of the mean) z-values for the auditory response
plot(sf_mean(3,:),'b')
plot(sf_mean(3,:)+(sf_sem(3,:)*3),'b--')
plot(sf_mean(3,:)-(sf_sem(3,:)*3),'b--')

% plot stars of the places where there is a siginificant difference between...
plot((sigDiffFreqVT*9.5)-1,'k*','color',[.8 .8 0]) % the visual and tactile z-values
plot((sigDiffFreqVA*10)-1,'m*') % the visual and auditory z-values
plot((sigDiffFreqTA*10.5)-1,'c*') % the tactile and auditory z-values

xticks(1:10:80)
xticklabels(round(frex(1:10:end),1))
xlim([1 80])
ylim([0 11])
xlabel('freq','fontsize',12)
ylabel('Average zval','fontsize',12)
title('Average zvals at freqs','fontsize',12)

line([xlim],[zval zval],'color','k','linestyle','--')
set(gcf,'position',[100 200 1000 600 ])

cd D:\HPS\LFP_Analysis\TF_plots\Stats\PopStats
print(gcf,'RespZvalsMod','-dpdf','-bestfit')

%% do pairwise comparisons of which response was higher between each modality pair when a component responded to both modalities
sf_meanPos = squeeze(nanmean(freqValuesPos,1));
sf_meanNeg = squeeze(abs(nanmean(freqValuesNeg,1)));

mSize1 = 10; %marker sizes for symbols in positive plot
mSize2 = 8; %marker sizes for symbols in negative plot

figure %this was used for figure 4 h-j. results were broken out into individual plots for the final version of the manuscript.
plot(sf_meanPos(1,:),'k-s','Color', [0 146 146]/255,'linew',2,'MarkerSize',mSize1 )
hold on;
plot(sf_meanPos(2,:),'k-s','Color', [182 109 255]/255,'linew',2,'MarkerSize',mSize1 )
plot(sf_meanPos(3,:),'b-s','Color', [219 209 0]/255,'linew',2,'MarkerSize',mSize1 )

plot(sf_meanNeg(1,:),'k-.o','Color', [0 146 146]/255,'linew',2,'MarkerSize',mSize2 )
plot(sf_meanNeg(2,:),'k-.o','Color', [182 109 255]/255,'linew',2,'MarkerSize',mSize2 )
plot(sf_meanNeg(3,:),'b-.o','Color', [219 209 0]/255,'linew',2,'MarkerSize',mSize2 )

set(gcf,'position',[2000 200 1800 800])

line([0 80],[zval zval],'color','k','linestyle','--')
legend({'Vis>Tac','Vis>Aud','Tac>Aud','Vis<Tac','Vis<Aud','Tac<Aud'},'location','best')


xlabel('freq')
ylabel('Average zval')
title('Average zvals at freqs')
ylim([0 10])
xticks(0:10:80)
xticklabels(round([frex(1:10:end), 100],1))


%stats
pVal = 0.01/3;
[ht1, pt1, statst1] = ttest(sf_meanPos(1,:),sf_meanNeg(1,:),'alpha',pVal)
[ht2, pt2, statst2] = ttest(sf_meanPos(1,1:40),sf_meanNeg(1,1:40),'alpha',pVal)
[ht3, pt3, statst3] = ttest(sf_meanPos(1,40:end),sf_meanNeg(1,40:end),'alpha',pVal)

