function [vcomps, tcomps, acomps, totcomps, vmaps, tmaps, amaps, totmaps, vidx, tidx, aidx, totidx] = compCounter(dataDir,fileID)
%{
This function reads the data files that contain the component maps and returns:
 -number of components for each modality
 -the maps from the significant components for each modality
 -an index of what session each component was from (so that comparisons between modality specific components in each session can be made
%}

cd(dataDir)
flist = dir(fileID);
flist = {flist.name};

totcomps = 0;
vcomps = 0;
tcomps = 0;
acomps = 0;

v = 0;
t = 0;
a = 0;
tot = 0;

for si = 1:length(flist)
    clearvars -except dataDir flist si totcomps vcomps tcomps acomps vmaps tmaps amaps totmaps v t a tot allMaps vidx tidx aidx totidx
    cd(dataDir)
    
    load(flist{si})
    for modi = 1:size(GED_results,2)
        if isempty(GED_results(modi).ncomps) || GED_results(modi).ncomps== 0
        else
            if modi == 1 % Visual
                
                vcomps = vcomps + GED_results(modi).ncomps; % count the significant components
                for ci = 1:GED_results(modi).ncomps
                    if length(GED_results(modi).maps(:,ci)) ~= 16 % skip broken channels
                        
                    else
                        v = v + 1; % visual component index
                        vmaps(v,:) = GED_results(modi).maps(:,ci); %maps from significant visual components
                        vidx(v) = si; % session index
                    end
                end
                
            elseif modi == 2 % Tactile
                tcomps = tcomps + GED_results(modi).ncomps; % count the significant components
                for ci = 1:GED_results(modi).ncomps
                    if length(GED_results(modi).maps(:,ci)) ~= 16 % skip broken channels
                        
                    else
                        t = t + 1; % tactile component index
                        tmaps(t,:) = GED_results(modi).maps(:,ci); %maps from significant tactile components
                        tidx(t) = si; % session index
                    end
                end
            elseif modi == 3 % Auditory
                acomps = acomps + GED_results(modi).ncomps;
                for ci = 1:GED_results(modi).ncomps
                    if length(GED_results(modi).maps(:,ci)) ~= 16 % skip broken channels
                        
                    else
                        a = a + 1; % auditory component index
                        amaps(a,:) = GED_results(modi).maps(:,ci); %maps from significant auditory components
                        aidx(a) = si; % session index
                    end
                end
            end
            % put all components together regardless of modality
            totcomps = totcomps + GED_results(modi).ncomps; %total components
            for ci = 1:GED_results(modi).ncomps
                if length(GED_results(modi).maps(:,ci)) ~= 16
                    
                else
                    tot = tot + 1; % all component index
                    totmaps(tot,:) = GED_results(modi).maps(:,ci); %maps from all significant modality specific components
                    totidx(tot) = si; % session index
                end
            end
        end
    end
    disp(si)
end

