# Requirements

Let `python` reference python 3. The following packages are used in this project:

* numpy            1.19.1   
* pandas           1.1.0    
* tifffile         2020.8.13
* matplotlib       3.3.1    
* scikit-image     0.17.2   
* scipy            1.5.2    
* numba            0.50.1...

# Procedure

Analysis was performed in the following order:
1. Aquire images as outlined in paper methods. With dark images and flat field correction images.
2. Run `python image_correction.py`.
  * Ensure filename paths are listed correctly
  * This requires dark images and flat field correction images.
  * Corrects for inhomogeneous TIRF field
3. Perform detections with TrackMate (FIJI). After detections are complete, and *before* tracking spots save the .xml to the `data` folder.
  * Ensure proper filenames used in `components.py`
4. Run `python components.py`
  * Fit distributions and plot various histograms

The project data was organized as depicted below with the scripts above being run from within the `src` folder:

```
├── 20200304-CaMKII_data
│   ├── activated-CaMKII
│   │   ├── act-alpha001xy01c1.tif
│   │   ├── ...
│   ├── activated-WT-photobleach
│   │   ├── activated-alpha-photobleach
│   │   │   ├── act-photobleacht001c1.tif
│   │   │   ├── ...
│   │   └── activated-alpha-photobleach-2
│   │       ├── act-photobleach001t001c1.tif
│   │       ├── ...
│   ├── Dark-images
│   │   ├── dark-images-2t001c1.tif
│   │   ├── ...
│   ├── Field_iliumination_control-1
│   │   ├── field control-2t001c1.tif
│   │   ├── ...
│   ├── Field_illumination_control-3
│   │   ├── field control-3t001c1.tif
│   │   ├── ...
│   ├── Field_illumination_control-4
│   │   ├── field control-4t001c1.tif
│   │   ├── ...
│   ├── Monomer-control
│   │   ├── Hckxy01c1.tif
│   │   ├── ...
│   └── unactivated-CaMKII
│       ├── unact-alpha001xy01c1.tif
│       ├── ...
├── 20200316-CaMKII repeats
│   ├── Activated-FA
│   │   ├── Act-FA001xy01c1.tif
│   │   ├── ...
│   ├── Activated-FA-KMDN
│   │   ├── Act-fa-KMDN001xy01c1.tif
│   │   ├── ...
│   ├── Activated-WT-1
│   │   ├── Act-WT-1001xy01c1.tif
│   │   ├── ...
│   ├── Activated-WT-2
│   │   ├── Act-WT-2001xy01c1.tif
│   │   ├── ...
│   ├── Activated-WT-KMDN
│   │   ├── Act-WT-KMDN001xy01c1.tif
│   │   ├── ...
│   ├── Dark-images
│   │   ├── dark-images-2t001c1.tif
│   │   ├── ...
│   ├── Field-control-1
│   │   ├── filed-control-1t001c1.tif
│   │   ├── ...
│   ├── Field-control-2
│   │   ├── filed-control-2t001c1.tif
│   │   ├── ...
│   ├── Unactivated-FA
│   │   ├── Unact-FAxy01c1.tif
│   │   ├── ...
│   ├── unactivated-fa-kmdn
│   │   ├── unact-fa-kmdnxy01c1.tif
│   │   ├── ...
│   ├── Unactivated-KMDN
│   │   ├── Unact-KMDNxy01c1.tif
│   │   ├── ...
│   ├── Unactivated-WT-1
│   │   ├── unact-WT-1xy01c1.tif
│   │   ├── ...
│   ├── Unactivated-WT-2
│   │   ├── unact-WT-2xy01c1.tif
│   │   ├── ...
├── data
│   ├── Activated FA 1.csv
│   ├── Activated FA 1.tif
│   ├── Activated FA 2.csv
│   ├── Activated FA 2.tif
│   ├── ...
├── FA_repeats
│   ├── Activated FA_repeat1
│   │   ├── fa-actxy01c1.tif
│   │   ├── ...
│   ├── Activated FA_repeat2
│   │   ├── Activated-dmsoxy01c1.tif
│   │   ├── ...
│   ├── Unactivated FA_repeat1
│   │   ├── fa-unact001xy01c1.tif
│   │   ├── ...
│   └── Unactivated FA_repeat2
│       ├── Unactivated-dmsoxy01c1.tif
│       ├── ...
├── figs
│   ├── all_data.pdf
│   ├── all dimer2fit.pdf
│   ├── ...
├── src
│   ├── components.py
│   ├── convolve.py
│   ├── image_correction.py
│   ├── README.md
│   ├── stepfilled.py
```

