import numpy as np
import scipy.integrate
import pylab as plt
import scipy
from scipy.optimize import fsolve

x_scale = 0.03

arr_vals = np.genfromtxt('output_tot.txt',names=True)

p=1

RhoA_tot = 1
Rac1_tot = 1
d = 1
r = 1

aDIARho = 5.05262777784701
aROCKRho = 22.7795262260532
vDIAa = 19.245564584573
vDIAi = 10.5262082701539
kDIAi = 0.015798636660221
vROCKa = 0.246976754035422
vROCKi = 9.58183118139453
kROCKi = 0.039523799086162
vRhoGEF = 0.49018638286558
kRhoGEF = 0.359065099959095
vRhoGAP = 0.77074138707867
kRhoGAP = 0.021752011564497
vRacGEF = 0.111756890996207
kRacGEF = 0.027451057971568
vRacGAP = 0.549460823224983
kRacGAP = 0.010865961761014
kDIAa = 2
kROCKa = 2
vPAKa = 0.0186
kPAKa = 0.288
vPAKi = 0.089
kPAKi = 0.16
aRhoDIA = 100
kRhoDIA = 3
aRacDIA = 7.8
kRacDIA = 0.055
aRacROCK = 10
kRacROCK = 0.05
kDIARho = 0.04
kROCKRho = 1.3
aRhoRac = 0.025
kRhoRac = 0.03
aRhoPAK = 0.025
kRhoPAK = 0.012
aPAKRac = 6.7
kPAKRac = 0.65
aRacPAK = 1
kRacPAK = 0.1



def alphaRhoDIA(c):
    rho,dia,rock,rac,pak = c
    return ((1.0 + aRhoDIA*dia/kRhoDIA) / (1.0 + dia/kRhoDIA))

def alphaRhoPAK(c):
    rho,dia,rock,rac,pak = c
    return ((1.0 + aRhoPAK*pak/kRhoPAK) / (1.0 + pak/kRhoPAK))

def alphaDIARho(c):
    rho,dia,rock,rac,pak = c
    return ((1.0 + aDIARho*rho/kDIARho) / (1.0 + rho/kDIARho))

def alphaROCKRho(c):
    rho,dia,rock,rac,pak = c
    return ((1.0 + aROCKRho*rho/kROCKRho) / (1.0 + rho/kROCKRho))

def alphaRacDIA(c):
    rho,dia,rock,rac,pak = c
    return ((1.0 + aRacDIA*dia/kRacDIA) / (1.0 + dia/kRacDIA))

def alphaRacPAK(c):
    rho,dia,rock,rac,pak = c
    return ((1.0 + aRacPAK*pak/kRacPAK) / (1.0 + pak/kRacPAK))

def alphaRacROCK(c):
    rho,dia,rock,rac,pak = c
    return ((1.0 + aRacROCK*rock/kRacROCK) / (1.0 + rock/kRacROCK))

def alphaPAKRac(c):
    rho,dia,rock,rac,pak = c
    return ((1.0 + aPAKRac*rac/kPAKRac) / (1.0 + rac/kPAKRac))

#def alphaRhoRac(c):
#    rho,dia,rock,rac,pak = c
#    return ((1.0 + aRhoRac*rac/kRhoRac) / (1.0 + rac/kRhoRac))



def rhoEq(c):
    rho,dia,rock,rac,pak = c
    return vRhoGEF*alphaRhoDIA(c)*alphaRhoPAK(c)*((RhoA_tot-rho)/kRhoGEF)/(1.0+((RhoA_tot-rho)/kRhoGEF)) - vRhoGAP*(rho/kRhoGAP)/(1.0+(rho/kRhoGAP))
    #return vRhoGEF*alphaRhoDIA(c)*alphaRhoRac(c)*((1.0-rho)/kRhoGEF)/(1.0+((1.0-rho)/kRhoGEF)) - vRhoGAP*(rho/kRhoGAP)/(1.0+(rho/kRhoGAP))

def diaEq(c):
    rho,dia,rock,rac,pak = c
    return vDIAa*alphaDIARho(c)*((d-dia)/kDIAa)/(1.0+((d-dia)/kDIAa)) - vDIAi*(dia/kDIAi)/(1.0+(dia/kDIAi))

def rockEq(c):
    rho,dia,rock,rac,pak = c
    return vROCKa*alphaROCKRho(c)*((r-rock)/kROCKa)/(1.0+((r-rock)/kROCKa)) - vROCKi*(rock/kROCKi)/(1.0+(rock/kROCKi))

def racEq(c):
    rho,dia,rock,rac,pak = c
    return vRacGEF*alphaRacDIA(c)*alphaRacPAK(c)*((Rac1_tot-rac)/kRacGEF)/(1.0+((Rac1_tot-rac)/kRacGEF)) - vRacGAP*alphaRacROCK(c)*(rac/kRacGAP)/(1.0+(rac/kRacGAP))
    #return vRacGEF*alphaRacDIA(c)*((1.0-rac)/kRacGEF)/(1.0+((1.0-rac)/kRacGEF)) - vRacGAP*alphaRacROCK(c)*(rac/kRacGAP)/(1.0+(rac/kRacGAP))

def pakEq(c):
    rho,dia,rock,rac,pak = c
    return vPAKa*alphaPAKRac(c)*((p-pak)/kPAKa)/(1.0+((p-pak)/kPAKa)) - vPAKi*(pak/kPAKi)/(1.0+(pak/kPAKi))


def quasiStatEqs(allVars,rho,rac):
    dia, rock, pak = allVars
    c = [rho,dia,rock,rac,pak]
    return (diaEq(c),rockEq(c),pakEq(c))


def f(c,t):
    return [rhoEq(c),diaEq(c),rockEq(c),racEq(c),pakEq(c)]


maxnum = 200
maxnum2 = 20

maxRho = RhoA_tot
maxRac = Rac1_tot
    

rhoVals = np.linspace(0,x_scale*RhoA_tot,num=maxnum)
racVals = np.linspace(0,Rac1_tot,num=maxnum)

diaVals = np.zeros((maxnum,maxnum))
rockVals = np.zeros((maxnum,maxnum))
pakVals = np.zeros((maxnum,maxnum))

RhoEqVals = np.zeros((maxnum,maxnum))
RacEqVals = np.zeros((maxnum,maxnum))




rhoVals2 = np.linspace(0,x_scale*RhoA_tot,num=maxnum2)
racVals2 = np.linspace(0,Rac1_tot,num=maxnum2)

diaVals2 = np.zeros((maxnum2,maxnum2))
rockVals2 = np.zeros((maxnum2,maxnum2))
pakVals2 = np.zeros((maxnum2,maxnum2))

RhoEqVals2 = np.zeros((maxnum2,maxnum2))
RacEqVals2 = np.zeros((maxnum2,maxnum2))



    
for n in np.arange(len(arr_vals)):
    #RhoA_tot    = arr_vals[n]['RhoA_tot']
    #Rac1_tot    = arr_vals[n]['Rac1_tot']
        
    #aDIARho = arr_vals[n]['aDIARho']
    #aROCKRho = arr_vals[n]['aROCKRho']
    #kRacROCK = arr_vals[n]['kRacROCK']

    #vDIAa = arr_vals[n]['vDIAa']
    #kDIAa = arr_vals[n]['kDIAa']
    #vDIAi = arr_vals[n]['vDIAi']
    #kDIAi = arr_vals[n]['kDIAi']
    #vROCKa = arr_vals[n]['vROCKa']
    #kROCKa = arr_vals[n]['kROCKa']
    #vROCKi = arr_vals[n]['vROCKi']
    #kROCKi = arr_vals[n]['kROCKi']

    #vRhoGEF = arr_vals[n]['vRhoGEF']
    #kRhoGEF = arr_vals[n]['kRhoGEF']
    #vRhoGAP = arr_vals[n]['vRhoGAP']
    #kRhoGAP = arr_vals[n]['kRhoGAP']
    #vRacGEF = arr_vals[n]['vRacGEF']
    #kRacGEF = arr_vals[n]['kRacGEF']
    #vRacGAP = arr_vals[n]['vRacGAP']
    #kRacGAP = arr_vals[n]['kRacGAP']

    #aRacDIA = arr_vals[n]['aRacDIA']
    #kRacDIA = arr_vals[n]['kRacDIA']
    #aRacROCK = arr_vals[n]['aRacROCK']
    #kRacROCK = arr_vals[n]['kRacROCK']

    #aRhoPAK = arr_vals[n]['aRhoPAK']
    #kRhoPAK = arr_vals[n]['kRhoPAK']
    #aPAKRac = arr_vals[n]['aPAKRac']
    #kPAKRac = arr_vals[n]['kPAKRac']
    #vPAKa = arr_vals[n]['vPAKa']
    #kPAKa = arr_vals[n]['kPAKa']
    #vPAKi = arr_vals[n]['vPAKi']
    #kPAKi = arr_vals[n]['kPAKi']

    d = arr_vals[n]['d']
    r = arr_vals[n]['r']
    #aRhoPAK = arr_vals[n]['aRhoPAK']

    for i in np.arange(maxnum):
        diaPrev = 0
        rockPrev = 0
        pakPrev = 0
        for j in np.arange(maxnum):
            diaVals[i][j], rockVals[i][j], pakVals[i][j] = fsolve(quasiStatEqs,(diaPrev,rockPrev,pakPrev),args=(rhoVals[j],racVals[i]))
	    diaPrev = diaVals[i][j]
	    rockPrev = rockVals[i][j]
	    pakPrev = pakVals[i][j]
            RhoEqVals[i][j] = rhoEq([rhoVals[j],diaVals[i][j],rockVals[i][j],racVals[i],pakVals[i][j]])
            RacEqVals[i][j] = racEq([rhoVals[j],diaVals[i][j],rockVals[i][j],racVals[i],pakVals[i][j]])
    
    
    for i in np.arange(maxnum2):
        diaPrev = 0
        rockPrev = 0
        pakPrev = 0
        for j in np.arange(maxnum2):
            diaVals2[i][j], rockVals2[i][j], pakVals2[i][j] = fsolve(quasiStatEqs,(diaPrev,rockPrev,pakPrev),args=(rhoVals2[j],racVals2[i]))
	    diaPrev = diaVals2[i][j]
	    rockPrev = rockVals2[i][j]
	    pakPrev = pakVals2[i][j]
            RhoEqVals2[i][j] = rhoEq([rhoVals2[j],diaVals2[i][j],rockVals2[i][j],racVals2[i],pakVals2[i][j]])
            RacEqVals2[i][j] = racEq([rhoVals2[j],diaVals2[i][j],rockVals2[i][j],racVals2[i],pakVals2[i][j]])
    
    c0_Rac = [0,0,0,Rac1_tot,p]
    ts = np.linspace(0, 1000, num=10000)
    cons_Rac = scipy.integrate.odeint(f,c0_Rac,ts)

    fontSuptitle = {'family' : 'Arial', 'weight' : 'bold', 'size' : 22} 
    fontTitle = {'family' : 'Arial', 'weight' : 'bold', 'size' : 20} 
    fontLabel = {'family' : 'Arial', 'weight' : 'bold', 'size' : 18} 
    fontAxes =  {'family' : 'Arial', 'weight' : 'bold', 'size' : 16} 
    plt.rc('font', **fontAxes)

    
    plt.figure(figsize=(3,4))
    plt.plot(cons_Rac[500:,0],cons_Rac[500:,3],color='green',linewidth=2,zorder=0)
    plt.quiver(rhoVals2, racVals2, RhoEqVals2, RacEqVals2,zorder=5)
    plt.contour(rhoVals,racVals,RhoEqVals,levels=[0],linewidths=3,colors='red',zorder=10)
    plt.contour(rhoVals,racVals,RacEqVals,levels=[0],linewidths=3,colors='blue',zorder=10)
    #plt.xlabel('Normalized [RhoA-GTP]',**fontLabel)
    #plt.ylabel('Normalized [Rac1-GTP]',**fontLabel)
    plt.legend()
    plt.xlim(0,x_scale)
    plt.savefig('nullclines_' + str(n) + '_l.png',bbox_inches='tight')
    

