import os,numpy,pylab,scipy.interpolate

Npoints=500

fontTitle = {'family' : 'Arial', 'weight' : 'bold', 'size' : 20} 
fontLabel = {'family' : 'Arial', 'weight' : 'bold', 'size' : 20} 
fontAxes =  {'family' : 'Arial', 'weight' : 'bold', 'size' : 20} 
pylab.rc('font', **fontAxes)

figx = 9
figy = 8

pylab.figure(figsize=(figx,figy))

scan_zip = numpy.loadtxt('output_numbers.txt')

#ppERK_arr = numpy.asarray(zip(*ppERK_zip))

DIA1l = []
ROCKl = []
grupl = []
for pnt in scan_zip:
    DIA1l.append(pnt[1])
    ROCKl.append(pnt[2])
    grupl.append(pnt[0])

DIA1 = numpy.asarray(DIA1l)
ROCK = numpy.asarray(ROCKl)
grup = numpy.asarray(grupl)

minDIA1 = 0.0
maxDIA1 = max(DIA1)
minROCK = 0.0
maxROCK = max(ROCK)

"""
DIA1_concentrations = numpy.linspace(minDIA1,maxDIA1,Npoints)
ROCK_concentrations = numpy.linspace(minROCK,maxROCK,Npoints)
rbf = scipy.interpolate.Rbf(DIA1, ROCK, grup, function='linear')
grup_vals = rbf(DIA1_concentrations, ROCK_concentrations)
"""

DIA1il = numpy.linspace(minDIA1,maxDIA1,Npoints)
ROCKil = numpy.linspace(minROCK,maxROCK,Npoints)
DIA1i, ROCKi = numpy.meshgrid(DIA1il,ROCKil)
grupi = scipy.interpolate.griddata((DIA1,ROCK),grup,(DIA1i,ROCKi),method='linear')


#pylab.imshow(grupi, vmin=grup.min(), vmax=grup.max(), origin='lower', extent=[DIA1.min(), DIA1.max(), ROCK.min(), ROCK.max()])
#CS = pylab.contourf(DIA1i,ROCKi,grupi,levels=[1.,2.,4.,5.,6.,7.],linewidths=[3])
#CS = pylab.contourf(DIA1i,ROCKi,grupi)
"""
fmt={}
strs = ['IC805','IC50','IC20']
for l, s in zip(CS.levels, strs):
    fmt[l] = s

control = ppERKi[0][0]

manual_locations = [(0.4, 0.2), (0.5, 0.4)]
pylab.clabel(CS,CS.levels[::2],fmt=fmt,inline=True,fontsize=20,manual=manual_locations)
pylab.contourf(inh1i/IC50a,inh2i/IC50b,ppERKi/control, 12)
"""
pylab.scatter(DIA1, ROCK, c=grup)
pylab.xlabel(r'd',**fontLabel)
pylab.ylabel(r'r',**fontLabel)
pylab.xlim(0,2.2)
pylab.ylim(0,4)
#pylab.xscale("log")
#pylab.yscale("log")
pylab.colorbar().set_label(label = 'type of regime',size=20,weight='bold')
pylab.savefig('2D_scan.png')
#pylab.show()



