function [PReject, FPR, RR] = DataPeeking(...  
          alpha1, alpha2, power2, baserate, n, d, twosample)
% Scenario: Multiple Data Peeking
% Input variables
%  alpha1
%  alpha2
%  power2
%  baserate
%  n: Vector with sample size (i.e. group size) at each peek
%  d: Effect size 
%  twosamples = true (false = onesample)

% Output variables
%  PReject 
%  FPR
%  RR

%Numerical example for input:
%     alpha1    = 0.005;
%     alpha2    = 0.05;
%     power2    = 0.90;
%     baserate  = 0.60;
%     n         = [10, 15, 20, 25, 30, 35, 40, 45]; %k = 8
%     d         = 0.2;
%     twosample = true;

if twosample
    sigma = sqrt(2);
else %One sample z-test
    sigma = 1;
end
 
PowerInflation = Peeking(alpha1,d,sigma,n);
AlphaInflation = Peeking(alpha1,0,sigma,n);

PReject = PowerInflation;
FPR = FalsePositiveRate(baserate,AlphaInflation,PowerInflation);
RR = ReplicationRate(baserate,AlphaInflation,alpha2,PowerInflation,power2);
end  


function [P,cov] = Peeking(alpha,d,sigma,n)

k=length(n);
mu=ones(1,k)*d/sigma.*sqrt(n);
cov=eye(k);

%calculate covariance matrix (which actually is a correlation matrix,
% since z-values are the DVs)
for i=1:k
    for j=i+1:k
        cov(i,j) = n(i)/sqrt(n(j)*n(i));
        cov(j,i) = cov(i,j);
    end
end

c=ones(1,k)*norminv(1-alpha);
P=1-mvncdf(c,mu,cov);

end

function [FPR] = FalsePositiveRate(baserate,alpha1,power1)
FPR=(1-baserate).*alpha1./((1-baserate).*alpha1+baserate.*power1);
end

function [RR] = ReplicationRate(baserate,alpha1,alpha2,power1,power2)
RR = (baserate.*power1*power2 + (1-baserate).*alpha1*alpha2)./(baserate.*power1 + (1-baserate).*alpha1);
end

