% Demo script for Ulrich & Miller
clear all

%% Common parameters for all examples:

alpha1 = 0.05;
alpha2 = 0.05;
power2 = 0.8;
d = 0.2;
n = 20;
twosample = true;

%% ****************** Selective Reporting of Significant Studies

k = 4;  % studies

%% Example PReject value from figure 3:
baserate = 1;
%Note that this probability does not depend on the baserate even this call
%computes these values.
[PReject, FPR, RR] = SelectiveReportingOfSignificantStudies(...
          alpha1, alpha2, power2, baserate, k, d, n, twosample)
% PReject =      0.49179
% FPR    =     0    
% RR   =      0.8

%% Example FPR and RR values from figures 4 & 5:
baserate = 0.4;
[PReject, FPR, RR] = SelectiveReportingOfSignificantStudies(...
          alpha1, alpha2, power2, baserate, k, d, n, twosample)
% PReject =      0.49179   % NEWROLF: See comment in function; note this does not depend on base rate
% FPR    =     0.36134
% RR   =      0.529

%% ****************** Failing to Report all Dependent Measures

k = 4;  % dependent measures
r = 0.2;

%% Example PReject value from figure 6:
baserate = 1;
[PReject, FPR, RR] = FailingToReportAllDVs(...
          alpha1, alpha2, power2, baserate, k, d, r, n, twosample)
% PReject =      0.44305
% FPR =      0
% RR =      0.8

%% Example FPR and RR values from figures 7 & 8:
baserate = 0.4;
[PReject, FPR, RR] = FailingToReportAllDVs(...
          alpha1, alpha2, power2, baserate, k, d, r, n, twosample)
% PReject =      0.44305
% FPR =      0.36774
% RR =      0.52419


%% ****************** Data Peeking

n = 10:5:25;  % k = 4 peeks

%% Example PReject value from figure 9:
baserate = 1;
[PReject, FPR, RR] = DataPeeking(...
          alpha1, alpha2, power2, baserate, n, d, twosample)
% PReject =      0.26572
% FPR    =     0
% RR   =      0.8

%% Example RR values from figures 10:
baserate = 0.4;
[PReject, FPR, RR] = DataPeeking(...
          alpha1, alpha2, power2, baserate, n, d, twosample)
% PReject =      0.26572
% FPR    =     0.37389
% RR   =      0.51958

%% ****************** Selective Outlier Removal
clear all %A reset is needed here
pOutlier = 0.05;
sdOutlier = 10;
k = 3;
cThresholds = [3, 2.5, 2.0]; %thresholds for Z-values
nIterations = 10000;

%common parameters for the next two examples
alpha1 = 0.05;
alpha2 = 0.05;
power2 = 0.8;
d = 0.2;
n = 20;
twosample = true;

%% Example PReject value from figure 11:

baserate = 1;

[PReject, FPR, RR] = OutlierRejection(...  
          alpha1, alpha2, power2, baserate, k, d, n, twosample, pOutlier, sdOutlier, cThresholds, nIterations)

%% Example FPR and RR values from figures 12 & 13:

baserate = 0.4;

[PReject, FPR, RR] = OutlierRejection(...  
          alpha1, alpha2, power2, baserate, k, d, n, twosample, pOutlier, sdOutlier, cThresholds, nIterations)


