function [PReject, FPR, RR] = FailingToReportAllDVs(...
          alpha1, alpha2, power2, baserate, k, d, r, n, twosample)

% Scenario: Failing to Report all DVs
% Input variables
%  alpha1
%  alpha2
%  power2
%  baserate
%  k: Number of dependent variables  
%  d: Effect size 
%  r: Correlation among dependent variables
%  n: Group size
%  twoamples = true (false = one sample)

% Output variables
%  PReject 
%  FPR
%  RR

%Numerical example for Input:
% NEWROLF: I commented the following lines:
%     alpha1    = 0.05;
%     alpha2    = 0.05;
%     power2    = 0.90;
%     baserate  = 0.30;
%     k         = 8;
%     d         = 0.0;
%     r         = 0.2;
%     n         = 20;
%     twosample = true;

if twosample
    sigma = sqrt(2);
else %One sample z-test
    sigma = 1;
end
 
% Construct Cov-Matrix for PowerInflation
c=ones(1,k)*norminv(1-alpha1);
cov = ones(k)*r; for i=1:k, cov(i,i) = 1; end
muP=ones(1,k)*d/sigma*sqrt(n);
PowerInflation = 1-mvncdf(c,muP,cov);

% Set vector mu to zero for AlphaInflation
muA=zeros(1,k);
AlphaInflation = 1-mvncdf(c,muA,cov);

FPR = FalsePositiveRate(baserate,AlphaInflation,PowerInflation);
RR = ReplicationRate(baserate,AlphaInflation,alpha2,PowerInflation,power2);
PReject = PowerInflation;
end  % NEWROLF: I added this--otherwise my old MATLAB complains about the file

function [FPR] = FalsePositiveRate(baserate,alpha1,power1)
FPR=(1-baserate).*alpha1./((1-baserate).*alpha1+baserate.*power1);
end

function [RR] = ReplicationRate(baserate,alpha1,alpha2,power1,power2)
RR = (baserate.*power1*power2 + (1-baserate).*alpha1*alpha2)./(baserate.*power1 + (1-baserate).*alpha1);
end

