function [PReject, FPR, RR] = SelectiveReportingOfSignificantStudies(...
          alpha1, alpha2, power2, baserate, k, d, n, twosample) 

% Scenario: Selective Reporting of Significant Results
% Input variables
%  alpha1
%  alpha2
%  power2
%  baserate
%  k: Maximum number of conducted studies  
%  d: effect size 
%  n: group size
%  Two samples = true (false = One sample)

% Output variables
%  PReject 
%  FPR
%  RR

%Numerical example for Input:
%     alpha1    = 0.05;
%     alpha2    = 0.05;
%     power2    = 0.90;
%     baserate  = 0.30;
%     k         = 4;
%     d         = 0.2;
%     n         = 20;
%     twosample = true;

if twosample 
    sigma = sqrt(2);
else % One sample z-test
    sigma = 1;
end

c=norminv(1-alpha1,0,sigma*sqrt(n));
beta1=normcdf(c,n*d,sigma*sqrt(n));

InflatedPower = 1-beta1^k;
AlphaInflation = 1-(1-alpha1)^k;

FPR = FalsePositiveRate(baserate,AlphaInflation,InflatedPower);
RR = ReplicationRate(baserate,AlphaInflation,alpha2,InflatedPower,power2);
PReject = InflatedPower;  
end  

function [FPR] = FalsePositiveRate(baserate,alpha1,power1)
FPR=(1-baserate).*alpha1./((1-baserate).*alpha1+baserate.*power1);
end

function [RR] = ReplicationRate(baserate,alpha1,alpha2,power1,power2)
RR = (baserate.*power1*power2 + (1-baserate).*alpha1*alpha2)./(baserate.*power1 + (1-baserate).*alpha1);
end

