% figure1.m reproduces Figure 1D,F using:
% - trial_averaged_scores: a matrix of reconstruction performance scores
% (correlation) for 150 images in each of the 15 recordings
% - variations_across_trials: a matrix of variation in performance scores
% across trials for 150 images in each of the 15 recordings 
% - RF_size: a vector of average parasol RF size (radius, in microns) for each recording

clear
load('figure1.mat');
figure;

n_exps = size(trial_averaged_scores,1);

% calculate trial averaged scores
n = zeros(n_exps, 20);
for i= 1:n_exps
    [n(i,:),edges] = histcounts(trial_averaged_scores(i,:), 0:0.05:1); % score distribution for each experiment
end
[total_n,~] = histcounts(trial_averaged_scores(:),edges); % score distribution across all experiments

% FIGURE 1D: Reconstruction performance
subplot(1,3,1)
[n_tot,edges] = histcounts(trial_averaged_scores(:), 0:0.05:1);
centers = (edges(2:end) + edges(1:(end-1)))/2;
fill([centers centers(end) centers(1)], [n_tot/(150*15) 0 0], 0.8*[1 1 1], 'LineWidth', 1.1, 'EdgeColor', 'k', 'FaceAlpha', 0);

% FIGURE 1F: Reconstruction performance for each experiment, 
% ordered by RF size
subplot(1,3,2)
[~,score_order] = sort(RF_size, 'descend');
hold on
for i = 15:-1:1
    fill([centers centers(end) centers(1)], [n(score_order(i),:)/(300) 0 0]+i*(0.05), 0.8*[1 1 1], 'LineWidth', 1.1, 'EdgeColor', 'k', 'FaceAlpha', 0.7);
end
axis off

% FIGURE 1F: RF size vs. performance
subplot(1,3,3)
plot(RF_size, mean(trial_averaged_scores,2), '.')
ylim([0.65 0.85])

% Calculations
mean_scores = mean(trial_averaged_scores(:));
std_scores = std(trial_averaged_scores(:));
fprintf('Reconstruction performance across the set of test images: %0.3g +/- %0.3g\n', mean_scores, std_scores);
fprintf('Trial-to-trial variation: %0.3g\n', mean(variations_across_trials(:)));
fprintf('RF size vs performance correlation: %0.1g\n',corr(RF_size, mean(trial_averaged_scores,2)));


