% figure3.m reproduces Figure 3D,E using the data in figure3.mat, which contains:
%  - slices: the profiles of the average ON and OFF parasol cell filters
%  for all 15 experiments in 4 conditions:  single cell, nearest neighbors,
%  same type, all cells, as well as the profiles of the average ON and OFF
%  parasol cell RFs 
% - widths: the widths of the filters and RFs (full width
%  at half maximum) for the same 5 conditions as slices

clear
load('figure3.mat')
default_colors = get(gca,'ColorOrder'); close all
figure; 

% FIGURE 3D - filter widths
% normalize the widths by the RF width
normalized_widths = [squeeze(widths(:,1,1:3)./repmat(widths(:,1,5),[1,1,3,1]));squeeze(widths(:,2,1:3)./repmat(widths(:,2,5),[1,1,3,1]))]';
% plot the normalized widths
subplot(2,1,1); hold on
plot([0, 4], [1, 1], 'Color', 0.2*[1 1 1], 'LineWidth', 1); hold on
plot(normalized_widths,'.-', 'Color', [0 0 0 0.2], 'MarkerSize', 10); xlim([0.5, 3.5])

% calculate the mean and standard distribution of the normalized widths
mean_widths = mean(normalized_widths');
std_widths = std(normalized_widths');
fprintf('Single cell filter width: %0.2g +/- %0.2g\n', mean_widths(1), std_widths(1));
fprintf('Single cell + Nearest neighbors filter width: %0.2g +/- %0.2g\n', mean_widths(2), std_widths(2));
fprintf('Single cell + same type filter width: %0.2g +/- %0.2g\n', mean_widths(3), std_widths(3));

% FIGURE 3E - filter profiles

% calculate the profiles in the horizontal and diagonal directions, 
% on the same scale, and calculate the mean and spread
locs = -3.5:0.1:3.5; % distance to plot, in RF widths
slice_matrix = zeros(2, 15, length(locs));
count = 0;
for i = 1:15
    for CT = 1:2
        count = count+1;       
        % horizontal
        slice_matrix(1,count,:) = interp1((-80:80)*(1./widths(i,CT,5,1)), squeeze(slices{i,CT}(4,1,:)), locs);
        % diagonal
        slice_matrix(2,count,:) = interp1(sqrt(2)*(-80:80)*(1./widths(i,CT,5,1)), squeeze(slices{i,CT}(4,2,:)), locs);
    end
end
% calculate mean and spread
mns = squeeze(mean(slice_matrix, 2))';
stds = squeeze(std(slice_matrix, [], 2))';

% plot
subplot(2,1,2); hold on
for i = 1:2
    hold on
    plot(locs, mns(:,i), 'Color', default_colors(i,:))
    fill([locs, -locs], [mns(:,i)+stds(:,i); flip(mns(:,i)-stds(:,i))], default_colors(i,:), 'FaceAlpha', 0.2, 'LineStyle', 'none') %,'EdgeColor',colorz(i,:))%
    plot([-5, 5], [0 0], 'k', 'LineWidth', 1)
    xlim([-3, 3]); ylim([-0.5, 1.5])
end