% figure4.m reproduces Figure 4C,D,E using figure4.mat, which contains:
% - coverage: coverage values for ON and OFF parasol cells in 12
% experiments for the RF, filter, and expanded RF
% - rf_reconstruction_scores: the reconstruction performance for the full
% and RF reconstructions for ON and OFF parasol cells across 8 recordings
% with 300 images each.
% - rf_reconstruction_power: the power spectra for RF reconstructions for
% ON and OFF parasol cells across 8 experiments
% - full_reconstruction_power: the power spectra for full reconstructions
% for ON and OFF parasol cells across 8 experiments
% - frequencies: the frequency values associated with the above power
% spectra, in cycles/mm

clear
load('figure4.mat')
default_colors = get(gca,'ColorOrder'); close all
figure;

% FIGURE 4C - FILTER VS. RF COVERAGE
subplot(1,3,1)
for cell_type = 1:2
    hold on
    plot(squeeze(coverage(cell_type,:,1:2))', '.-', 'MarkerSize', 10, 'Color', [0 0 0 0.2] )
end
xlim([0.5, 2.5])
ylim([0.4 0.9])
% calculate and print averages
RF_cov = coverage(:,:,1); 
fprintf('RF coverage: %0.2g +/- %0.2g\n', mean(RF_cov(:)), std(RF_cov(:)));
filt_cov = coverage(:,:,2); 
fprintf('Filter coverage: %0.2g +/- %0.2g\n', mean(filt_cov(:)), std(filt_cov(:)));
RFexpanded_cov = coverage(:,:,3); 
fprintf('Expanded RF coverage: %0.2g +/- %0.2g\n', mean(RFexpanded_cov(:)), std(RFexpanded_cov(:)));

% FIGURE 4D - FULL VS. STA RECONSTRUCTION SCORES
subplot(1,3,2); hold on
plot(rf_reconstruction_scores(:,1), rf_reconstruction_scores(:,2), '.k');
hold on; plot([0,1], [0,1])
xlim([0 1]); ylim([0,1]); axis square
% calculate and print score change
score_diff = rf_reconstruction_scores(:,2) - rf_reconstruction_scores(:,1);
fprintf('Change in reconstruction performance when using RFs instead of filters: %0.2g +/- %0.2g\n', mean(score_diff), std(score_diff));
fprintf('Percentage change: %0.2g\n', mean(score_diff./rf_reconstruction_scores(:,1)));

% FIGURE 4E - FULL VS. STA RECONSTRUCTION POWER SPECTRA
subplot(1,3,3); hold on
% image power
fill([frequencies flip(frequencies)], [image_power 0*image_power], [1 1 1]*0.8, 'LineStyle', 'none'); hold on
% full reconstruction power
temp = cat(1, squeeze(full_reconstruction_power(:,1,:)), squeeze(full_reconstruction_power(:,2,:)));
fill([frequencies flip(frequencies)], [mean(temp)+std(temp), flip(mean(temp)-std(temp))], default_colors(1,:), 'LineStyle', 'none', 'FaceAlpha', 0.3)
plot(frequencies, mean(temp), 'Color', [default_colors(1,:) 1]); hold on
% RF reconstruction power
temp = cat(1, squeeze(rf_reconstruction_power(:,1,:)), squeeze(rf_reconstruction_power(:,2,:)));
fill([frequencies flip(frequencies)], [mean(temp)+std(temp), flip(mean(temp)-std(temp))], default_colors(2,:), 'LineStyle', 'none', 'FaceAlpha', 0.3)
plot(frequencies, mean(temp), 'Color', [default_colors(2,:) 1]); hold on
plot([0 10], [0,0], 'k')
ylim([0 1]); xlim([0 10])