% figure5.m reproduces Figure 5B using figure5.mat, which contains the
% magnitudes and widths of the parasol and midget cell reconstruction
% filters, normalized by the single cell reconstruction filter, in matrices
% with dimensions (# experiments x ON vs. OFF x # conditions), where the
% different conditions have different other cell types included

clear
load('figure5.mat')
default_colors = get(gca,'ColorOrder'); close all
figure;

for CT = 1:2

subplot(4,2,1+(CT-1)*2)
hold on
ylim([0 1.5])
errorbar(squeeze(mean(parasol_magnitudes(:,CT,:))), squeeze(std(parasol_magnitudes(:,CT,:))), '.', 'LineWidth', 2, 'MarkerSize', 20)
plot([0 6], [1 1], '--k')

subplot(4,2,2+(CT-1)*2)
hold on
errorbar(squeeze(mean(parasol_widths(:,CT,:))), squeeze(std(parasol_widths(:,CT,:))), '.', 'LineWidth', 2, 'MarkerSize', 20)
ylim([0 1.5])
plot([0 6], [1 1], '--k')

end

for CT = 1:2

subplot(4,2,1+(CT-1)*2+4)
hold on
ylim([0 1.5])
errorbar(squeeze(mean(midget_magnitudes(:,CT,:))), squeeze(std(midget_magnitudes(:,CT,:))), '.', 'LineWidth', 2, 'MarkerSize', 20)
plot([0 6], [1 1], '--k')

subplot(4,2,2+(CT-1)*2+4)
hold on
errorbar(squeeze(mean(midget_widths(:,CT,:))), squeeze(std(midget_widths(:,CT,:))), '.', 'LineWidth', 2, 'MarkerSize', 20)
ylim([0 1.5])
plot([0 6], [1 1], '--k')

end