% figure7.m reproduces Figure 7C,D,E using figure7.mat, which contains:
% - midget_scores: a matrix of reconstruction performance scores
% (correlation) for 150 images from 7 recordings in 3 conditions (parasol,
% parasol+midget, midget)
% - both: the power spectrum of the images reconstructed from parasol and
% midget cell responses across 3 recordings
% - par: the power spectrum of the images reconstructed from parasol cell
% responses across 3 recordings
% - mid: the power spectrum of the images reconstructed from parasol cell
% responses across 3 recordings - par_RF_freq: the power spectrum of the
% parasol cell RFs across 3 recordings
% - mid_RF_freq: the power spectrum of the midget cell RFs across 3
% recordings
% - frequencies: the frequencies (in cycles/mm) for the above spectra
% - model_scores: a matrix of the reconstruction performance scores for 7
% recordings, using spikes aggregated over increasingly long windows (from
% 10 ms to 200 ms in 10ms intervals), for reconstructions from parasol and
% midget cell responses

clear
load('figure7.mat');
default_colors = get(gca,'ColorOrder'); close all
figure;

% FIGURE 7C - PARASOL VS MIDGET CELL RECONSTRUCTION PERFORMANCE
subplot(3,3,1)
plot(midget_scores(:,1), midget_scores(:,3), '.k'); xlim([0,1]); ylim([0,1]); axis square
subplot(3,3,4)
plot(midget_scores(:,1), midget_scores(:,2), '.k'); xlim([0,1]); ylim([0,1]); axis square
subplot(3,3,7)
plot(midget_scores(:,3), midget_scores(:,2), '.k'); xlim([0,1]); ylim([0,1]); axis square
fprintf('parasol+midget cells: %0.2g +/- %0.2g\n', mean(midget_scores(:,2)), std(midget_scores(:,2)));
fprintf('parasol cells: %0.2g +/- %0.2g\n', mean(midget_scores(:,1)), std(midget_scores(:,1)));
fprintf('midget cells: %0.2g +/- %0.2g\n', mean(midget_scores(:,3)), std(midget_scores(:,3)));

% FIGURE 7D - PARASOL VS MIDGET POWER SPECTRA
subplot(3,3,2); hold on
plot(frequencies', (both'), 'LineWidth', 2, 'Color', [0 0 0])
plot(frequencies', (par'), 'LineWidth', 2, 'Color', default_colors(1,:))
plot(frequencies', (mid'), 'LineWidth', 2, 'Color', default_colors(2,:))
ylabel('Fraction of Power in Original Images')
xlim([0 10])
title('PS of Reconstructed Images')
xlabel('cyles/mm')

subplot(3,3,3); hold on
plot(frequencies, parasol_RF_freq, 'LineWidth', 2,  'Color', default_colors(1,:))
plot(frequencies, midget_RF_freq, 'LineWidth', 2,  'Color', default_colors(2,:))
ylabel('Power')
xlim([0 10])
title('PS of RFs')
xlabel('cyles/mm')

% FIGURE 7E - PARASOL VS MIDGET TIMING
subplot(3,3,5); hold on
par_mean = zeros(1, 20);
mid_mean = zeros(1, 20);
for i = 1:7
    par = squeeze(model_scores(i,:,1)); [~,par_speed(i)] = find((par/max(par)-0.95)>0, 1);
    mid = squeeze(model_scores(i,:,2)); [~,mid_speed(i)] = find((mid/max(mid)-0.95)>0, 1);
    plot(10:10:200, par/max(par), 'Color', [default_colors(1,:) 0.5], 'LineWidth', 0.5)
    plot(10:10:200, mid/max(mid), 'Color', [default_colors(2,:) 0.5], 'LineWidth', 0.5)
    par_mean = par_mean + par/max(par);
    mid_mean = mid_mean + mid/max(mid);
end
hold on; plot([0, 200], [0.95, 0.95],':', 'Color', [0 0 0 1], 'LineWidth', 1)
hold on; plot([0, 200], [0 0], 'Color', [0 0 0 1], 'LineWidth', 1)
hold on; plot([0, 200], [1 1], 'Color', [0 0 0 1], 'LineWidth', 1)
plot(10:10:200, par_mean/7, 'Color', default_colors(1,:))
plot(10:10:200, mid_mean/7, 'Color', default_colors(2,:))
ylim([-0.1 1.1])
xlim([0 150])

subplot(3,3,6); hold on
plot([par_speed; mid_speed]*10, 'Color', [0 0 0 0.5]); hold on
plot([par_speed; mid_speed]*10, '.k')
xlim([0.5 2.5]); ylim([50 150])

fprintf('Parasol cell speed: %0.3g +/- %0.3g\n', mean(par_speed*10), std(par_speed*10));
fprintf('Midget cell speed: %0.3g +/- %0.3g\n', mean(mid_speed*10), std(mid_speed*10));
