% figure9.m reproduces Figure 9B,C,D using figure9.mat, which includes:
% 	- change_in_linearity: the difference in the mean squared error of a
% 	linear model when using a static, nonlinear transform as compared to
% 	the raw, untransformed responses, across 2225 parasol cells from 15
% 	recordings
% 	- NL_improvement: the change in reconstruction performance across 300
% 	images from each of 15 recordings, for reconstructions from the
% 	responses of ON+OFF, ON, and OFF parsol cells
%   - interaction_term_improvement: a matrix of the changes in
%   reconstruction performance when including interaction terms for 300
%   images from each of 3 recordings, when including different subsets of
%   interaction terms (ON-ON, OFF-OFF, ON-OFF, and all).

clear
load('figure9.mat');
figure;

% FIGURE 9BC - STATIC NONLINEAR TRANSFORMATION

subplot(1,3,1)
histogram(change_in_linearity); hold on
plot([0 0], [0 350], 'k')
xlim([-10 5]); ylim([0 350])

subplot(1,3,2)
x = [1,2,3];
mns = mean(NL_improvement);
stds = std(NL_improvement);
x_tmp = repmat(x, [size(NL_improvement, 1), 1]);
plot(x_tmp+0.1*randn(size(x_tmp)), NL_improvement, '.k', 'Color', 0.5*[1 1 1], 'MarkerSize', 3)
hold on
plot([x; x], [mns+stds; mns-stds], 'k')
plot( x, mns, 'k.', 'MarkerSize', 30)
plot([0 9], [0 0], 'k', 'LineWidth', 0.5)
xlim([0 4]); ylim([-0.2 0.2])

fprintf('Nonlinear transformation: mean - %0.2g,%0.2g,%0.2g \n', mean(NL_improvement))
fprintf('Nonlinear transformation: std - %0.2g,%0.2g,%0.2g \n', std(NL_improvement))

% FIGURE 9D - INTERACTION TERMS
subplot(1,3,3)
x = 1:4;
x_tmp = repmat(x, [size(interaction_term_improvement, 1), 1]);
plot(x_tmp+0.1*randn(size(x_tmp)), interaction_term_improvement, '.k', 'Color', 0.5*[1 1 1], 'MarkerSize', 3)
mns = mean(interaction_term_improvement);
stds = std(interaction_term_improvement);
hold on
plot([x; x], [mns+stds; mns-stds], 'k')
plot( x, mns, 'k.', 'MarkerSize', 30)
plot([0 11], [0 0], 'k', 'LineWidth', 0.5)
xlim([0 5]); ylim([-0.1 0.1])

fprintf('Including nonlinear interations: mean: %0.2g,%0.2g,%0.2g,%0.2g \n', mean(interaction_term_improvement))
fprintf('Including nonlinear interations: std: %0.2g,%0.2g,%0.2g,%0.2g \n', std(interaction_term_improvement))
