% figure2.m reproduces Figure 2A using figure2.mat
% figure2.mat: Contains the distribution of correlation between 
% reconstructed images from different recordings, 
% across 150 images and 66 pairs of recordings.

clear
load('figure2.mat')

% calculate mean and standard deviation
mean_scores = mean(across_recordings_scores(:));
std_scores = std(across_recordings_scores(:));
fprintf('Reconstruction performance across recordings: %0.3g +/- %0.3g\n', mean_scores, std_scores);

% plot the distribution
figure;
histogram(across_recordings_scores(:))
xlim([0.5 1])