% figure10.m reproduces Figure 10C using figure10.mat, which includes:
% 	- all_scores: reconstruction performance using recorded or simulated
% 	spikes across 150 images from each of 15 recordings
% 	- filter_similarity: correlation between reconstruction filters fit
% 	using simulated or recorded spikes for 2225 cells from 15 recordings
% 	- image_similarity: correlation between images reconstructed from
% 	simulated or recorded spikes, across 150 images from each of 15
% 	recordings

clear
load('figure10.mat');
figure

subplot(3,1,1); histogram(filter_similarity, 0.4:0.05:1)
subplot(3,1,2); histogram(image_similarity, 0.4:0.05:1)
subplot(3,1,3); plot(all_scores(1,:), all_scores(2,:), 'k.');
hold on; plot([0,1], [0,1], 'k')
axis square
fprintf('Recorded vs. simulated filter similarity %0.2g +/- %0.2g\n', mean(filter_similarity), std(filter_similarity));
fprintf('Recorded vs. simulated image similarity: %0.2g +/- %0.2g\n', mean(image_similarity(:)), std(image_similarity(:)));
fprintf('Performance from simulated spikes: %0.2g +/- %0.2g\n', mean(all_scores(1,:)), std(all_scores(1,:)));
fprintf('Performance from recorded spikes: %0.2g +/- %0.2g\n', mean(all_scores(2,:)), std(all_scores(2,:)));
