% figure8.m reproduces Figure 8 using the following matfiles:
% figure8.mat, which includes shuffling_change, a matrix of the
% change in reconstruction performance across 150 images for each of 3
% recordings and 3 scenarios, and trial_to_trial_var, the variation in
% reconstruction performance across trials for the same 3 recordings and
% scenarios

clear
load('figure8.mat');
figure

a = 0.5; b = 1; % these are just for spacing the bars in the plot
% plot trial to trial variation
bar([(1:3)*a (1:3)*a+3*a+b (1:3)*a+6*a+2*b], trial_to_trial_var, 'FaceColor', [0 0 0]+0.9, 'LineStyle', 'none'); hold on
% plot change in performance with shuffling
boxplot(shuffling_change', 'PlotStyle','compact', 'MedianStyle', 'line', 'OutlierSize', 5, 'Symbol', '.', 'Jitter', 0, 'Positions', [(1:3)*a (1:3)*a+3*a+b (1:3)*a+6*a+2*b], 'Colors', 'k', 'Widths', 0.4)
hold on; plot([a-2*b, 9*a+4*b], [0,0],'k', 'LineWidth', 0.5)
xlim([a-b, 9*a+3*b])

% calculate average changes in the 3 scenarios desribed in the text
tmp = shuffling_change(1:3,:);
fprintf('1 x 150ms: %0.2g +/- %0.2g\n', mean(tmp(:)), std(tmp(:)));
tmp = shuffling_change(4:6,:);
fprintf('15 x 10ms: %0.2g +/- %0.2g\n', mean(tmp(:)), std(tmp(:)));
tmp = shuffling_change(7:9,:);
fprintf('1 x 10ms: %0.2g +/- %0.2g\n', mean(tmp(:)), std(tmp(:)));
