% figure6.m reproduces Figure 6C,D using figure6.mat, which contains:
% - parasol_scores: a matrix of reconstruction performance scores
% (correlation) for each of the 15 recordings. Each cell contains a matrix
% with dimensions (condition x image x trial), where conditions refers to
% which parasol cells' responses were included in the reconstruction
% (ON+OFF, ON, or OFF).
% - estimated_pixel: average estimated pixel values across 10 bins, 15
% recordings and 3 conditions (ON+OFF, ON, OFF)
% - true_pixel: true pixel values across 10 bins and 15 recordings

clear
load('figure6.mat');
default_colors = get(gca,'ColorOrder'); close all
figure

% Figures 6C - ON VS OFF SCORES
trial_averaged_scores = zeros(3, 150, 15);
for i= 1:15
    trial_averaged_scores(:, :, i) = mean(parasol_scores{i}, 3);
end
subplot(3,2,1)
plot(trial_averaged_scores(3,:), trial_averaged_scores(2,:), '.k'); xlim([0,1]); ylim([0,1]); axis square
subplot(3,2,3)
plot(trial_averaged_scores(2,:), trial_averaged_scores(1,:), '.k'); xlim([0,1]); ylim([0,1]); axis square
subplot(3,2,5)
plot(trial_averaged_scores(3,:), trial_averaged_scores(1,:), '.k'); xlim([0,1]); ylim([0,1]); axis square

fprintf('ON+OFF parasol cells: %0.2g +/- %0.2g\n', mean(trial_averaged_scores(1,:)), std(trial_averaged_scores(1,:)));
fprintf('ON parasol cells: %0.2g +/- %0.2g\n', mean(trial_averaged_scores(2,:)), std(trial_averaged_scores(2,:)));
fprintf('OFF parasol cells: %0.2g +/- %0.2g\n', mean(trial_averaged_scores(3,:)), std(trial_averaged_scores(3,:)));

% FIGURE 6D - ON vs OFF CONTRAST RANGES
default_colors(2:3,:) = default_colors(1:2,:);
default_colors(1,:) = [0 0 0];
for i=1:3
    subplot(3,2,[2 4])
    hold on;
    for exp = 1:15
        plot(true_pixel(exp,:), squeeze(estimated_pixel(exp,:, i))', 'Color', [0.5+0.5*default_colors(i,:) 0.5], 'LineWidth', 1)
    end
    plot(squeeze(mean(true_pixel,1)), squeeze(mean(estimated_pixel(1:15,:,i),1) )', 'Color', default_colors(i,:), 'LineWidth', 2)
    ylim([0 255]); xlim([0 255])
    subplot(3,2,6)
    hold on;
    plot(squeeze(mean(true_pixel(:,2:end),1)), diff(squeeze(mean(estimated_pixel(:,:,i),1) )')./diff(squeeze(mean(true_pixel,1)))', 'Color', default_colors(i,:), 'LineWidth', 2)
    ylim([0 1.2]); xlim([0 255])
end
ylabel('Estimated Pixel Intensity')
xlabel('True Pixel Intensity')
