import numpy as np
import sys
import matplotlib.pyplot as plt
import seaborn as sns

# USAGE *py [Figure_2-Source_Data_File_*] [fig identifyier]
# use source data files to reproduce the density plot at the bottom of panels A and B in Figure 2

data = np.loadtxt(sys.argv[1], delimiter='\t')

# PLOT
# set font sizes
s=8
m=10
l=12
#plt.rcParams.update({'font.size': 10})
plt.rc('font', size=s)
plt.rc('axes', titlesize=s)
plt.rc('axes', labelsize=s)
plt.rc('legend', fontsize=s)
plt.rc('xtick', labelsize=s)
plt.rc('ytick', labelsize=s)

# PLOT 2DHistogram as density
# 2D histogram "on the fly" with matplotlib.pyplot

#pip
ax = plt.subplot(111)
ax.hist2d(data[:,0],data[:,1], bins=150, range=[[0,90],[0,90]], cmap='Purples', normed='True', alpha=0.95)
sns.set_style("white")
sns.kdeplot(data[:,2],data[:,3],cmap="Greys")
plt.xlabel('x')
plt.ylabel('y')
ax.figure.savefig('Figure_2'+sys.argv[3]+'.png')
plt.draw()
