import numpy as np
import sys
import matplotlib.pyplot as plt
import seaborn as sns

# USAGE *py [Figure_2-Figure_Supplement-Source_Data_File_1] [fig name header]

data = np.loadtxt(sys.argv[1], delimiter='\t')

# PLOT
# set font sizes
s=8
m=10
l=12
#plt.rcParams.update({'font.size': 10})
plt.rc('font', size=s)
plt.rc('axes', titlesize=s)
plt.rc('axes', labelsize=s)
plt.rc('legend', fontsize=s)
plt.rc('xtick', labelsize=s)
plt.rc('ytick', labelsize=s)

fig, (ax1, ax2, ax3) = plt.subplots(1,3, figsize=(6,2), sharey='all')

# arrange:
# SM_raft_binding - SM_raft_opposite
# CHL_raft_binding - CHL_raft_opposite

ax1.hist2d(data[:,0],data[:,1], bins=150, range=[[0,90],[0,90]], cmap='Greens', density='True', alpha=0.95)
sns.set_style("white")
sns.kdeplot(data[:,2],data[:,3],cmap="Greys", ax=ax1)
ax1.set_ylabel('y')
ax1.set_xlabel('x')

ax2.hist2d(data[:,4],data[:,5], bins=150, range=[[0,90],[0,90]], cmap='Greens', density='True', alpha=0.95)
sns.kdeplot(data[:,6],data[:,7],cmap="Greys", ax=ax2)
ax2.set_xlabel('x')

ax3.hist2d(data[:,8],data[:,9], bins=150, range=[[0,90],[0,90]], cmap='Greens', density='True', alpha=0.95)
sns.kdeplot(data[:,10],data[:,11],cmap="Greys", ax=ax3)
ax3.set_xlabel('x')

fig.tight_layout()
plt.savefig('Figure_2-Figure_Supplement-2.png')
