import numpy as np
import sys
import matplotlib.pyplot as plt
import seaborn as sns

# USAGE *py [Figure_5-Figure_Supplement_1-Source_Data_File_1.txt]

pipt = np.loadtxt(sys.argv[1], delimiter='\t')
pipm = np.loadtxt(sys.argv[2], delimiter='\t')
piprt = np.loadtxt(sys.argv[3], delimiter='\t')
piprm = np.loadtxt(sys.argv[4], delimiter='\t') 
itp = np.loadtxt(sys.argv[5], delimiter='\t')
imp = np.loadtxt(sys.argv[6], delimiter='\t')
rtp = np.loadtxt(sys.argv[7], delimiter='\t')
rmp = np.loadtxt(sys.argv[8], delimiter='\t')

# PLOT

# set font sizes
s=8
m=10
l=12
#plt.rcParams.update({'font.size': 10})
plt.rc('font', size=s)
plt.rc('axes', titlesize=s)
plt.rc('axes', labelsize=s)
plt.rc('legend', fontsize=s)
plt.rc('xtick', labelsize=s)
plt.rc('ytick', labelsize=s)

fig, ((ax1, ax2), (ax3, ax4)) = plt.subplots(2,2, figsize=(4.5,4.5), sharex='all', sharey='all')

# arrange:
# PIP_in_trimer - PIP_raft_trimer
# PIP_in_monomer - PIP_raft_monomer

ax1.hist2d(pipt[:,0],pipt[:,1], bins=150, range=[[0,170],[0,170]], cmap='Purples', density='True', alpha=0.95)
sns.set_style("white")
sns.kdeplot(itp[:,0],itp[:,1],cmap="Greys", ax=ax1)
ax1.set_ylabel('y')

ax2.hist2d(piprt[:,0],piprt[:,1], bins=150, range=[[0,170],[0,170]], cmap='Purples', density='True', alpha=0.95)
sns.kdeplot(rtp[:,0],rtp[:,1],cmap="Greys", ax=ax2)

ax3.hist2d(pipm[:,0],pipm[:,1], bins=150, range=[[0,170],[0,170]], cmap='Purples', density='True', alpha=0.95)
sns.kdeplot(imp[:,0],imp[:,1],cmap="Greys", ax=ax3)
ax3.set_xlabel('x')
ax3.set_ylabel('y')

ax4.hist2d(piprm[:,0],piprm[:,1], bins=150, range=[[0,170],[0,170]], cmap='Purples', density='True', alpha=0.95)
sns.kdeplot(rmp[:,0],rmp[:,1],cmap="Greys", ax=ax4)
ax4.set_xlabel('x')

fig.tight_layout()
plt.savefig('Figure_5-Figure_Supplement_1.png')
