import numpy as np
import sys
import matplotlib.pyplot as plt
import seaborn as sns

# USAGE *py [Figure_5-Figure_Supplement_2-Source_Data_File_1.txt]

data = np.loadtxt(sys.argv[1], delimiter='\t')

# PLOT
# set font sizes
s=8
m=10
l=12
#plt.rcParams.update({'font.size': 10})
plt.rc('font', size=s)
plt.rc('axes', titlesize=s)
plt.rc('axes', labelsize=s)
plt.rc('legend', fontsize=s)
plt.rc('xtick', labelsize=s)
plt.rc('ytick', labelsize=s)

fig, ((ax1, ax2), (ax3, ax4)) = plt.subplots(2,2, figsize=(4.5,4.5), sharex='all', sharey='all')

# arrangenment:
# SM_raft_binding - SM_raft_opposite
# CHL_raft_binding - CHL_raft_opposite

# binding leaflet
ax1.hist2d(data[:,2],data[:,3], bins=150, range=[[0,170],[0,170]], cmap='Blues', density='True', alpha=0.95)
sns.set_style("white")
sns.kdeplot(data[:,8],data[:,9],cmap="Greys", ax=ax1)
ax1.set_ylabel('y')

ax2.hist2d(data[:,6],data[:,7], bins=150, range=[[0,170],[0,170]], cmap='Blues', density='True', alpha=0.95)
sns.kdeplot(data[:,8],data[:,9],cmap="Greys", ax=ax2)

# opposite leaflet
ax3.hist2d(data[:,0],data[:,1], bins=150, range=[[0,170],[0,170]], cmap='Oranges', density='True', alpha=0.95)
sns.kdeplot(data[:,8],data[:,9],cmap="Greys", ax=ax3)
ax3.set_xlabel('x')
ax3.set_ylabel('y')

ax4.hist2d(data[:,4],data[:,5], bins=150, range=[[0,170],[0,170]], cmap='Oranges', density='True', alpha=0.95)
sns.kdeplot(data[:,8],data[:,9],cmap="Greys", ax=ax4)
ax4.set_xlabel('x')

fig.tight_layout()
plt.savefig('Figure_5-Figure_Supplement_2.png')
