import numpy as np
import sys
import matplotlib as mp
import matplotlib.pyplot as plt
import pandas as pd

# USAGE *py [Figure_7-Souce_Data_File_*.txt] [sim time]
# generates plots for individual planels in Figure 7 & Figure 7 - Figure Supplement 1
# outputs two image files

# load data
data = np.loadtxt(sys.argv[1]+'.dat', delimiter='\t')

# get moving avg for time series
dt = pd.DataFrame({'t1': data[:,0], 't2': data[:,1]})
m1=dt.t1.rolling(25, center=True).mean()
m2=dt.t2.rolling(25, center=True).mean()
ma1=np.array(m1)
ma2=np.array(m2)

# set font sizes
s=8
m=10
l=12
#plt.rcParams.update({'font.size': 10})
plt.rc('font', size=s)
plt.rc('axes', titlesize=s)
plt.rc('axes', labelsize=s)
plt.rc('legend', fontsize=s)
plt.rc('xtick', labelsize=s)
plt.rc('ytick', labelsize=s)

# plot individual histograms (overlay) AND 2D hist using SEABORN

fig, ((ax1, ax2)) = plt.subplots(2,1, figsize=(3,2), sharex=True)
x1=np.linspace(0,int(sys.argv[2]),num=len(data))
x2=np.linspace(0,int(sys.argv[2]),num=len(ma2))

# time series
ax1.plot(x1,data[:,0],'k-', lw=1, alpha=0.3)
ax2.plot(x1,data[:,1],'r-', lw=1, alpha=0.3)
ax1.plot(x2, ma1,'k-', lw=1)
ax2.plot(x2, ma2,'r-', lw=1)
ax1.set_ylabel(r'1st tIC')
ax2.set_ylabel(r'2nd tIC')
ax2.set_xlabel('time (ns)')
ax1.set_ylim(-2.5,2.5)
ax2.set_ylim(-2.5,2.5)
ax1.set_yticks([-2,0,2])
ax2.set_yticks([-2,0,2])

fig.tight_layout()
plt.savefig('figure_7.png')
#close plot
plt.clf()
plt.cla()
plt.close()

# Thermal plot
fig = plt.figure(figsize=(3.5,2.5))
x=data[:,0]
y=data[:,1]
plt.grid(False)
plt.hist2d(x, y, bins=100, cmap='hot_r', norm=mp.colors.LogNorm())
plt.xlabel('1st tIC')
plt.ylabel('2nd tIC')
plt.xlim(-2.5,2.5)
plt.ylim(-2.5,2.5)
formatter = mp.ticker.LogFormatter(10, labelOnlyBase=False)
cbar=plt.colorbar(format=formatter)

fig.tight_layout()
plt.savefig('figure7_heatmap.png')
