% Code by Jian-geng Chiou, Sep., 2015.

tic

clear all
close all

global a
global b
global c
global d
global n

%% Load Parameters
Parameters

dt2 = 0.0001;
dx = L/N;

% Laplacian operator
e              = ones(N,1); 
Laplacian      = spdiags([e, -2*e, e], -1:1, N, N);
Laplacian(1,N) = 1;                     % periodic boundary conditions
Laplacian(N,1) = 1;

Diff_u  = Laplacian*Du/dx^2;
Diff_v  = Laplacian*Dv/dx^2;      % (dt2 not fixed yet)

%% Storage Files

u_tc = zeros((interval + 1), N);
v_tc = zeros((interval + 1), N);
ui_tc = zeros((interval + 1), N);

%% Initial pre-defined condition

% homogeneous steady state
%[T,Y] = ode45(@HSS, [0 100], [P P]);
%u0 = Y(1, end);
%v0 = Y(2, end);

% Use custom initial state
if loadstate == 1
    load('initial_state_1D.mat')
% Add sin wave to uniform state (but maintain the same total amount)
elseif spikes ~= 0
    u = (ones(1,N)-cos(2*spikes*pi*(1:N)./N)*0.1);
    v = ones(1,N);
    ui = zeros(1,N);
% Use random noise to u
else
    u = ((rand(1,N)*2))*P;
    v = ones(1,N)*P;
    ui = zeros(1,N);
end

%% Initialize

% print initial condidtion into file

u_tc(1,:) = u;
v_tc(1,:) = v;
ui_tc(1,:) = ui;

% print progress scale bar
fprintf('Total simulation time: %d seconds\n\n', interval);
fprintf('0            25          50           75         100 (percent) \n');
fprintf('|------------|-----------|------------|-----------|\n');
         
%%

% Initialize
progress = 1;   % Used to calculate progress scale bar
curr_t = 0;     % current time (s)     
react_t = 0;    % current time within each second (s)
loop_state = 0; % 1: last step in each second
SS = 0;

% loop through each second
while curr_t < interval
        
        % change peak size at the time of choice
        if break_time ~= 0
            if curr_t > break_time
        
                u(1:N/2) = u(1:N/2)*p1_multiplier;
                u(N/2+1:N) = u(N/2+1:N)*p2_multiplier;
                ui(1:N/2) = ui(1:N/2)*p1_multiplier;
                ui(N/2+1:N) = ui(N/2+1:N)*p2_multiplier;
                v(1:N/2) = v(1:N/2)*p1_multiplier;
                v(N/2+1:N) = v(N/2+1:N)*p2_multiplier;
                
                break_time = 0;
            end
        end

        % change peak size at the time of choice
        if break_time_2 ~= 0
            if curr_t > break_time
        
                u(1:N/2) = u(1:N/2)*p1_multiplier;
                u(N/2+1:N) = u(N/2+1:N)*p2_multiplier;
                ui(1:N/2) = ui(1:N/2)*p1_multiplier;
                ui(N/2+1:N) = ui(N/2+1:N)*p2_multiplier;
                v(1:N/2) = v(1:N/2)*p1_multiplier;
                v(N/2+1:N) = v(N/2+1:N)*p2_multiplier;
                
                break_time = 0;
            end
        end

        % Reaction
        
        u_next = u + dt2*(a*u.^2.*v - b*u - c*u.^n);
        v_next = v + dt2*(- a*u.^2.*v + b*u + d*ui);
        ui_next = ui + dt2*(c*u.^n - d*ui);
        
        Reac = (a*u.^2.*v - b*u - c*u.^n);
        
        % proceed half a time step and calculate reaction again
        u_next2 = u + dt2/2*(a*u.^2.*v - b*u - c*u.^n);
        v_next2 = v + dt2/2*(- a*u.^2.*v + b*u + d*ui);
        
        Reac_next2 = (a*u_next2.^2.*v_next2 - b*u_next2 - c*u_next2.^n);
        
        % compare previous two processes and calculate error
        error_reac = abs((Reac_next2 - Reac)./Reac_next2);
        error = max(error_reac);
        
        
        % if error is within the tolerated range, move on
        if error < error_tolerated || SS ==1 || loop_state == 1
            
            % diffuse
            Hop_v  = speye(N) - Diff_v*dt2;
            Hop_u  = speye(N) - Diff_u*dt2;

            u_next = u_next/Hop_u;
            v_next = v_next/Hop_v;
            ui_next = ui_next/Hop_v;
%            v_next = mean(v_next)*ones(1,N);
%            ui_next = mean(ui_next)*ones(1,N);

            % check if system is at steady state
            error_ss_u = abs((u_next - u)./u_next);
            error_ss_v = abs((v_next - v)./v_next);
            error_ss_ui = abs((ui_next - ui)./ui_next);
        
            error_ss = max(error_ss_u + error_ss_v + error_ss_ui);
            
            % if at steady state, skip error checking next step
            if error_ss < error_tolerated_ss
                SS = 1;
            else
                SS = 0;
            end
            
            % update
            u = u_next;
            v = v_next;
            ui = ui_next;
            
            % adding the step on
            
            react_t = react_t + dt2;
            curr_t = curr_t + dt2;
            % setting new stepsize for nest step
            dt2 = 1.01*dt2;
            
            % if end of second
            if loop_state == 1
                % store data every second
                u_tc(int16(curr_t) + 1, :) = u;
                v_tc(int16(curr_t) + 1, :) = v;
                ui_tc(int16(curr_t) + 1, :) = ui;
                
                % reset 
                loop_state = 0;
                react_t = 0;
            end
            
            % print indicator if simulation reached a certain perca
            if curr_t >= interval/50*progress
                fprintf('*');
                progress = progress +1;
            end

        % or else, decrease step size
        else
            dt2 = dt2/1.01;         
            if dt2 < 0.0000000000000001
                display('dt going below 10-7 sec!!!!');
            end
        end
        % Check if we are reaching end of second
        if react_t + dt2 > 1
            dt2 = 1 - react_t;
            loop_state = 1;
            if break_compete
                if u(3*N/4)- min(u) < 0.001
                    break
                end
            end
        end
end

time_whole = toc

output_mat = strcat(output_basename, '.mat');
save(output_mat);



%% Make movie for 1-D

outmovie2 = figure('Position',[300 300 600 400]);
set(gcf,'color','w');
UU = u_tc;
VV = v_tc;
WW = ui_tc;
xx = (1:N)*dx ;
movie_name = strcat(output_basename , '.avi');
Movie = VideoWriter(movie_name);
Movie.FrameRate = 10;  
open(Movie);


cmax = max(UU(end,:))*1.4;
cmin = 0;

for frame = 1:10:interval + 1
    
    minutes = int2str(floor((frame-1)/60)); seconds = rem((frame-1), 60);

    if seconds < 10
        seconds = strcat('0', int2str(seconds));
    else
        seconds = int2str(rem(frame-1, 60));
    end
    timestamp = strcat(minutes, ':', seconds);
    %timestamp = strcat('t = ',int2str(frame-1));
    
    plot(xx, VV(frame,:)+WW(frame,:), 'LineWidth', 2);hold on;
    plot(xx, UU(frame,:), 'LineWidth', 2);
    plot(xx, WW(frame,:), 'LineWidth', 2);hold off;
    text(N*dx/20 ,cmax - cmax/20,timestamp,'fontsize', 20, 'color','black');
    xlabel('Position ({\mu}m)','FontSize',16,'FontWeight','bold');
    ylabel('u','FontSize',16,'FontWeight','bold');
    ylim([cmin cmax]);
    ax = gca;
    ax.FontSize = 16;
    
    frames = getframe(outmovie2);
    writeVideo(Movie,frames);
end

close(Movie);
%}