% Natasha Savage 04April11
%
% Euler variable step size

tic

close all;
clear all;

%% Load parameters
Parameters
%%
% storage files
%M_tc = zeros((interval+1)*N, N);
%Em_tc = zeros((interval+1)*N, N);
%Ec_tc = zeros((interval+1)*N, N);
%Mi_tc = zeros((interval+1)*N, N);
%Eim_tc = zeros((interval+1)*N, N);
%Eic_tc = zeros((interval+1)*N, N);
%RD_tc = zeros((interval+1)*N, N);
%RDc_tc = zeros((interval+1)*N, N);
Rtot_tc = zeros(interval+1, 1);
Etot_tc = zeros(interval+1, 1);
P1_tc = zeros(interval+1, 1);
P2_tc = zeros(interval+1, 1);

% variables for time-stepping
 dt=0.05;             % diffusion interval [sec]
%dt=0.005;             % diffusion interval [sec]
maxt = interval/dt;  % number of time-steps in interval

% variables for spatial discretization
dx  = Cellsize*sqrt(pi)/N;          % spatial meshsize (1D)

curr_t  = 0;          % keeps track of current time
nRsteps = 100;        % defines the initial reaction time-step (dt2)
dt2     = dt/nRsteps; % reaction time-step

% compute diffusion-coeff times dt/dx^2
Diff1  = Dconst * dt/dx^2;
Diff2  = Dconst_c * dt/dx^2;

% diffusion matrix of the quarter domain, includes dt/dx^2 factor
e        = ones(N,1);
Dxx_half      = spdiags([e, -2*e, e], -1:1, N, N);
Dxx_half(1,N/2) = 1;                     % periodic boundary conditions
Dxx_half(N/2,1) = 1;                     % of the first half-domain
Dxx_half(N,N/2+1) = 1;                   % periodic boundary conditions
Dxx_half(N/2+1,N) = 1;                   % of the second half-domain
Dxx_half(N/2,N/2+1) = 0;                 % no communication between two
Dxx_half(N/2+1,N/2) = 0;                 % half-domains
Dxx1_half      = Dxx_half*Diff1;
Dxx2_half      = Dxx_half*Diff2;

Mxx1_half = kron(speye(N),Dxx1_half);
Myy1_half = kron(Dxx1_half,speye(N));
Hop1_barrier = speye(N^2) - Mxx1_half - Myy1_half;   % heat operator, I-Dxx

Mxx2_half = kron(speye(N),Dxx2_half);
Myy2_half = kron(Dxx2_half,speye(N));
Hop2_barrier = speye(N^2) - Mxx2_half - Myy2_half;   % heat operator, I-Dxx

% diffusion matrix of the full domain, includes dt/dx^2 factor
Dxx      = spdiags([e, -2*e, e], -1:1, N, N);
Dxx(1,N) = 1;                   % periodic boundary conditions
Dxx(N,1) = 1;
Dxx1      = Dxx*Diff1;
Dxx2      = Dxx*Diff2;

Mxx = kron(speye(N),Dxx1_half);
Myy = kron(Dxx1,speye(N));
Hop1_nobarrier = speye(N^2) - Mxx - Myy;   % heat operator, I-Dxx

Mxx = kron(speye(N),Dxx2_half);
Myy = kron(Dxx2,speye(N));
Hop2_nobarrier = speye(N^2) - Mxx - Myy;   % heat operator, I-Dxx

%% Initial condition

if load1pss == 1
    load('1pss.mat');
elseif load2pss == 1
    load('2pss.mat');
else
    Cdc42T   = Cdc42T0   *ones(N); Cdc42T(50, 25) = Cdc42T0 + Cdc42spike1;Cdc42T(50, 75) = Cdc42T0 + Cdc42spike2;
    Cdc42D   = Cdc42D0   *ones(N);
    Cdc42Dc  = Cdc42Dc0  *ones(N)- ((Cdc42spike1 + Cdc42spike2)*eta/N/N)*ones(N);
    BemGEF42 = BemGEF420 *ones(N);
    BemGEFi42= BemGEFi420*ones(N);
    BemGEF   = BemGEF0   *ones(N); BemGEF(50, 25) = BemGEF0 + BemGEFspike;
    BemGEFc  = BemGEFc0  *ones(N)- ((BemGEFspike)*eta/N/N)*ones(N);
    BemGEFi  = BemGEFi0  *ones(N);
    BemGEFic = BemGEFic0 *ones(N);
    
end

   
%%

% print initial conditions into file
%{
RT_tc(1:N,:)  = Cdc42T;
M_tc(1:N,:)   = BemGEF42;
Em_tc(1:N,:)  = BemGEF;
Ec_tc(1:N,:)  = BemGEFc;
Mi_tc(1:N,:)  = BemGEFi42;
Eim_tc(1:N,:) = BemGEFi;
Eic_tc(1:N,:) = BemGEFic;
RD_tc(1:N,:)  = Cdc42D;
RDc_tc(1:N,:) = Cdc42Dc;
%}
% calculate mass balance
Rtot_tc(1) = ((sum(sum(Cdc42Dc))+sum(sum(eta*(Cdc42T + Cdc42D + BemGEF42 + BemGEFi42)))));
Etot_tc(1) = sum(sum(BemGEFc + BemGEFic))+sum(sum(eta*(BemGEF42 + BemGEFi42 + BemGEF + BemGEFi)));

P1_tc(1) = sum(sum(Cdc42T(:,1:N/2)+BemGEF42(:,1:N/2)));
P2_tc(1) = sum(sum(Cdc42T(:,N/2+1:N)+BemGEF42(:,N/2+1:N)));

% writing mass into file
      
% print progress scale bar
fprintf('Total simulation time: %d seconds\n\n', interval);
fprintf('0            25          50           75         100 (percent) \n');
fprintf('|------------|-----------|------------|-----------|\n');
  
%% 
progress = 1;
break_countdown = 0;
Cdc42T_start = zeros(N);
Cdc42Dc_start = zeros(N);
BemGEFc_start = zeros(N);
t7030 = 0;
P1_now = 0;
P2_now = 0;
      
for t0=1:1:maxt                   % dt = 0.05 incraments: maxt = 20/dt
    curr_t = curr_t+dt;           % update clock    
    
    % Change cytoplasmic diffusion constant at the time of choice
    if break_time ~= 0
        if t0*dt == break_time
            
%{
            % clear background
            Cdc42T_background    = mode(mode(Cdc42T));
            Cdc42D_background    = mode(mode(Cdc42D));
            Cdc42Dc_background   = mode(mode(Cdc42Dc));
            BemGEF42_background  = mode(mode(BemGEF42));
            BemGEF_background    = mode(mode(BemGEF));
            BemGEFc_background   = mode(mode(BemGEFc));
            BemGEFi42_background = mode(mode(BemGEFi42));
            BemGEFi_background   = mode(mode(BemGEFi));
            BemGEFic_background  = mode(mode(BemGEFic));
            Cdc42T   = Cdc42T    - Cdc42T_background;
            Cdc42D   = Cdc42D    - Cdc42D_background;
            Cdc42Dc  = Cdc42Dc   - Cdc42Dc_background;
            BemGEF42 = BemGEF42  - BemGEF42_background;
            BemGEFi42= BemGEFi42 - BemGEFi42_background;
            BemGEF   = BemGEF    - BemGEF_background;
            BemGEFc  = BemGEFc   - BemGEFc_background;
            BemGEFi  = BemGEFi   - BemGEFi_background;
            BemGEFic = BemGEFic  - BemGEFic_background;
%}            
            % change protein amount of total BemGEF or Cdc42.
            Cdc42T = Cdc42T*P_Cdc42;
            Cdc42D = Cdc42D*P_Cdc42;
            if P_Cdc42 > 1
                Cdc42Dc = Cdc42Dc*P_Cdc42 + mean(mean((BemGEF42+BemGEFi42)*(P_Cdc42 - 1)*eta));
                BemGEF42 = BemGEF42;
                BemGEFi42 = BemGEFi42;
                BemGEFc = BemGEFc;
            else
                Cdc42Dc = Cdc42Dc*P_Cdc42; 
                BemGEFc = BemGEFc - mean(mean((BemGEF42+BemGEFi42)*(P_Cdc42 - 1)*eta));
                BemGEF42 = BemGEF42*P_Cdc42;
                BemGEFi42 = BemGEFi42*P_Cdc42;
            end
            
            if P_BemGEF > 1
                BemGEFc = BemGEFc*P_BemGEF + mean(mean((BemGEF42+BemGEFi42)*(P_BemGEF - 1)*eta));
                BemGEF42 = BemGEF42;
                BemGEFi42 = BemGEFi42;
                Cdc42Dc = Cdc42Dc;
            else
                Cdc42Dc = Cdc42Dc - mean(mean((BemGEF42+BemGEFi42)*(P_BemGEF - 1)*eta));
                BemGEFc = BemGEFc*P_BemGEF;
                BemGEF42 = BemGEF42*P_BemGEF;
                BemGEFi42 = BemGEFi42*P_BemGEF;
            end
            BemGEF = BemGEF*P_BemGEF;
            BemGEFi = BemGEFi*P_BemGEF;
            BemGEFic = BemGEFic*P_BemGEF;
            
            % raise one patch, lower the other
            Cdc42T   = cat(2,Cdc42T(:,1:50)*break_p1_multiplier,    Cdc42T(:,51:100)*break_p2_multiplier);
            Cdc42D   = cat(2,Cdc42D(:,1:50)*break_p1_multiplier,    Cdc42D(:,51:100)*break_p2_multiplier);
            Cdc42Dc  = cat(2,Cdc42Dc(:,1:50)*break_p1_multiplier,   Cdc42Dc(:,51:100)*break_p2_multiplier);
            BemGEF42 = cat(2,BemGEF42(:,1:50)*break_p1_multiplier,  BemGEF42(:,51:100)*break_p2_multiplier);
            BemGEF   = cat(2,BemGEF(:,1:50)*break_p1_multiplier,    BemGEF(:,51:100)*break_p2_multiplier);
            BemGEFc  = cat(2,BemGEFc(:,1:50)*break_p1_multiplier,   BemGEFc(:,51:100)*break_p2_multiplier);
            BemGEFi42= cat(2,BemGEFi42(:,1:50)*break_p1_multiplier,  BemGEFi42(:,51:100)*break_p2_multiplier);
            BemGEFi  = cat(2,BemGEFi(:,1:50)*break_p1_multiplier,    BemGEFi(:,51:100)*break_p2_multiplier);
            BemGEFic = cat(2,BemGEFic(:,1:50)*break_p1_multiplier,   BemGEFic(:,51:100)*break_p2_multiplier);
%{
            % add background back
            Cdc42T   = Cdc42T    + Cdc42T_background;
            Cdc42D   = Cdc42D    + Cdc42D_background;
            Cdc42Dc  = Cdc42Dc   + Cdc42Dc_background;
            BemGEF42 = BemGEF42  + BemGEF42_background;
            BemGEFi42= BemGEFi42 + BemGEFi42_background;
            BemGEF   = BemGEF    + BemGEF_background;
            BemGEFc  = BemGEFc   + BemGEFc_background;
            BemGEFi  = BemGEFi   + BemGEFi_background;
            BemGEFic = BemGEFic  + BemGEFic_background;
%}
        end
    end
    
    if t0*dt < start_compete
        Hop1 = Hop1_barrier;
        Hop2 = Hop2_barrier;
    elseif start_compete == t0*dt
        Cdc42T_start = Cdc42T;
        Cdc42Dc_start = Cdc42Dc;
        BemGEFc_start = BemGEFc;
        Hop1 = Hop1_barrier;
        Hop2 = Hop2_barrier;
    else
        Hop1 = Hop1_nobarrier;
        Hop2 = Hop2_nobarrier;
    end
    
    react_step_Euler_VSS
    

    if(t0 >= interval/dt/50*progress)
      fprintf('*');
      progress = progress +1;
    end
    
    % store data every second
    if(t0>=1/dt && mod(t0,1/dt)==0) 
      
        %{
        RT_tc((t0*dt*N + 1):(t0*dt + 1)*N ,:)  = Cdc42T;
        M_tc((t0*dt*N + 1):(t0*dt + 1)*N ,:)   = BemGEF42;
        Em_tc((t0*dt*N + 1):(t0*dt + 1)*N ,:)  = BemGEF;
        Ec_tc((t0*dt*N + 1):(t0*dt + 1)*N ,:)  = BemGEFc;
        Mi_tc((t0*dt*N + 1):(t0*dt + 1)*N ,:)  = BemGEF42;
        Eim_tc((t0*dt*N + 1):(t0*dt + 1)*N ,:) = BemGEFi;
        Eic_tc((t0*dt*N + 1):(t0*dt + 1)*N ,:) = BemGEFic;
        RD_tc((t0*dt*N + 1):(t0*dt + 1)*N ,:)  = Cdc42D;
        RDc_tc((t0*dt*N + 1):(t0*dt + 1)*N ,:) = Cdc42Dc;
        
        %}

  
      
        % calculate mass balance
        Rtot_tc(t0*dt) = ((sum(sum(Cdc42Dc))+sum(sum(eta*(Cdc42T + Cdc42D + BemGEF42 + BemGEFi42)))));
        Etot_tc(t0*dt) = sum(sum(BemGEFc + BemGEFic))+sum(sum(eta*(BemGEF42 + BemGEFi42 + BemGEF + BemGEFi)));

        P1_now = sum(sum(Cdc42T(:,1:N/2)+BemGEF42(:,1:N/2)));
        P2_now = sum(sum(Cdc42T(:,N/2+1:N)+BemGEF42(:,N/2+1:N)));
        P1_tc(t0*dt) = P1_now;
        P2_tc(t0*dt) = P2_now;
        
        if P1_now/(P1_now+P2_now) < 0.7
            t7030 = t0*dt;
        end
            
    end    
    
    if break_compete 
        if P2_now/(P1_now+P2_now) < 0.01 && break_countdown == 0
            fprintf('competition went to < 1%');
            break_countdown = curr_t;
        end
        if curr_t > break_countdown + 50 && break_countdown ~= 0
            fprintf('simulation stopped');
            break
        end
    end
end  

%% ________________________________________________________________________



time_whole = toc

data_mat = strcat('data_', output_basename, '.mat');
%save(data_mat, 'RT_tc', 'M_tc', 'Em_tc', 'Ec_tc','RD_tc', 'RDc_tc', 'Rtot_tc', 'Etot_tc');%, 'Mi_tc', 'Eim_tc', 'Eic_tc') %

%clear RT_tc M_tc Em_tc Ec_tc RD_tc RDc_tc Rtot_tc Etot_tc Mi_tc Eim_tc Eic_tc; %

output_mat = strcat(output_basename, '.mat');
save(output_mat);

%% Plots



