function dy = steady_state_ode_ic(t,y)
%%
      
% global so we don't have to pass into Euler function 
global k1a 
global k1b 
global k2a  
global k2b 
global k3 
global k4a 
global k4b 
global k5a 
global k5b 
global k7 
global eta
global k8
global k9

dy = zeros(9,1);

% RT      
dy(1) =  ((k2a.*y(3)  +k3.*y(2)  ).*y(5) - k2b.*y(1)  - k4a.*y(3).*y(1) + k4b.*y(2) - k7.*y(4).*y(1)) ...
        +(                                         - k4a.*y(8).*y(1) + k4b.*y(7) - k7.*y(9).*y(1));   

% M
dy(2) = (k4a*y(3).*y(1) - k4b*y(2) + k7*y(4).*y(1)) ...
             + (-k8*y(2).*y(2)) ...
             + (-k8*y(2).*y(7));
         
% Em
dy(3) = (k1a.*y(4) - k1b.*y(3) - k4a.*y(3).*y(1) + k4b.*y(2));

% Ec     
dy(4) = (eta.*(k1b.*y(3) - (k1a+k7.*y(1)).*y(4))) ...
             + (k9.*y(9)) ;

% RD
dy(5) = (k2b.*y(1)  - (k2a.*y(3) +k3.*y(2) ).*y(5) - k5b.*y(5) + k5a.*y(6));

% RDc
dy(6) = (eta.*(k5b.*y(5) - k5a.*y(6)));

% Ms
dy(7) = (k4a.*y(8).*y(1) - k4b.*y(7) + k7.*y(9).*y(1)) ...
             + ( k8.*y(2).*y(2)    )...
             + ( k8.*y(7).*y(2)    ); 

% Ems
dy(8) = (k4b.*y(7) - k1b.*y(8) + k1a.*y(9) - k4a.*y(8).*y(1));

% Ecs
dy(9) = (eta.*(k1b.*y(8) - (k1a+k7.*y(1)).*y(9)) - k9.*y(9) );

end

    

    
    





