# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
# Code to generate Figure 3 of Price, Shearer, et al. (2020)
# 
# Authors: David J Price & Freya M Shearer
# Date: 20 April, 2020
# 
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

library(ggplot2)
library(dplyr)

cases.dat <- read.csv("cases.csv")
cases.dat <- cases.dat %>% mutate(date=ymd(date))

projected.dat <- read.csv("forecast_14Apr.csv")
projected.dat <- projected.dat %>% mutate(date=ymd(date)) %>% filter(date<=ymd("2020-04-28"))


start.date <- ymd("2020-03-01")
forecast.date <- ymd("2020-04-14")

# For each region
cases.dat <- cases.dat %>% ungroup() %>% mutate(region=NULL) %>% group_by(date) %>% tally(wt=cases) %>% rename(cases=n)
# merge with projections
cases.dat <- full_join(cases.dat, projected.dat, by="date")

plot.end.date <- max(projected.dat$date)
dd <- seq.Date(start.date, plot.end.date, by="1 week")
legend.cols <- c("Observed"="grey90", "Model"="steelblue3", "Projected"="steelblue3")


proj.dat.tidy <- projected.dat %>% mutate(ribbon.col = ifelse(projected.dat$date<forecast.date, 0, 1))

proj.dat.tidy <- proj.dat.tidy %>% rbind(., proj.dat.tidy %>% filter(date==forecast.date)) %>% 
                  mutate(ribbon.col = ifelse(row_number() == n(), 0, ribbon.col)) %>% arrange(date, ribbon.col)



ggplot() + 
  geom_col(data= cases.dat, aes(x=date, y=cases, fill="Observed"), colour="grey70") +
  geom_vline(aes(xintercept=forecast.date), lty=2, colour="grey80") +
  geom_ribbon(data=proj.dat.tidy[proj.dat.tidy$ribbon.col==0,], aes(x=date, ymin=CI95_L, ymax=CI95_U, fill="Model"), alpha=0.35) +
  geom_ribbon(data=proj.dat.tidy[proj.dat.tidy$ribbon.col==0,], aes(x=date, ymin=CI50_L, ymax=CI50_U, fill="Model"), alpha=0.6) +
  geom_ribbon(data=proj.dat.tidy[proj.dat.tidy$ribbon.col==1,], aes(x=date, ymin=CI95_L, ymax=CI95_U, fill="Model"), alpha=0.2) +
  geom_ribbon(data=proj.dat.tidy[proj.dat.tidy$ribbon.col==1,], aes(x=date, ymin=CI50_L, ymax=CI50_U, fill="Model"), alpha=0.35) +
  scale_x_date("Date", date_labels = "%d-%b", breaks=dd, labels=dd, limits = c(start.date, plot.end.date)) +
  scale_y_continuous("Daily New Cases", limits=c(0,420)) +
  scale_fill_manual("",values=legend.cols) +
  theme(legend.position = "top", text=element_text(size=16))




